/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBase;

public class BlockNetherReed
extends BlockBase {
    public static final BooleanProperty TOP = BooleanProperty.func_177716_a((String)"top");

    public BlockNetherReed() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151679_y).func_200947_a(SoundType.field_222472_s).func_200946_b().func_200942_a().func_226896_b_().func_200944_c());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(true)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{TOP});
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAmbientOcclusionLightLevel(BlockState state, IBlockReader view, BlockPos pos) {
        return 1.0f;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        Block up = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        BlockState down = world.func_180495_p(pos.func_177977_b());
        if (BlocksHelper.isNetherGround(down)) {
            BlockPos posDown = pos.func_177977_b();
            boolean lava = BlocksHelper.isLava(world.func_180495_p(posDown.func_177978_c()));
            lava = lava || BlocksHelper.isLava(world.func_180495_p(posDown.func_177968_d()));
            lava = lava || BlocksHelper.isLava(world.func_180495_p(posDown.func_177974_f()));
            boolean bl = lava = lava || BlocksHelper.isLava(world.func_180495_p(posDown.func_177976_e()));
            if (lava) {
                return up == this ? (BlockState)this.func_176223_P().func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(false)) : this.func_176223_P();
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        if (down.func_177230_c() != this) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (up != this) {
            return this.func_176223_P();
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos posDown = pos.func_177977_b();
        BlockState down = world.func_180495_p(posDown);
        if (BlocksHelper.isNetherGround(down)) {
            boolean lava = BlocksHelper.isLava(world.func_180495_p(posDown.func_177978_c()));
            lava = lava || BlocksHelper.isLava(world.func_180495_p(posDown.func_177968_d()));
            lava = lava || BlocksHelper.isLava(world.func_180495_p(posDown.func_177974_f()));
            lava = lava || BlocksHelper.isLava(world.func_180495_p(posDown.func_177976_e()));
            return lava;
        }
        return down.func_177230_c() == this;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        BlockPos up;
        boolean grow;
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
            return;
        }
        if (((Boolean)state.func_177229_b((Property)TOP)).booleanValue() && (grow = world.func_175623_d(up = pos.func_177984_a()))) {
            int length = BlocksHelper.getLengthDown(world, pos, this);
            boolean isFertile = BlocksHelper.isFertile(world.func_180495_p(pos.func_177979_c(length)));
            if (isFertile) {
                length -= 2;
            }
            boolean bl = length < 3 && (isFertile ? random.nextInt(8) == 0 : random.nextInt(16) == 0) ? true : (grow = false);
            if (grow) {
                BlocksHelper.setWithUpdate((IWorld)world, up, this.func_176223_P());
                BlocksHelper.setWithUpdate((IWorld)world, pos, (BlockState)this.func_176223_P().func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(false)));
            }
        }
    }
}

