/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.structures.plants.StructureStalagnate;

public class BlockStalagnateSeed
extends BlockBaseNotFull
implements IGrowable {
    protected static final VoxelShape SHAPE_TOP = BlockStalagnateSeed.func_208617_a((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_BOTTOM = BlockStalagnateSeed.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final StructureStalagnate STRUCTURE = new StructureStalagnate();
    public static final BooleanProperty TOP = BooleanProperty.func_177716_a((String)"top");

    public BlockStalagnateSeed() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151679_y).func_200947_a(SoundType.field_222472_s).func_226896_b_().func_200946_b().func_200942_a().func_200944_c());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(true)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{TOP});
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState blockState = this.func_176223_P();
        if (ctx.func_196000_l() == Direction.DOWN) {
            return blockState;
        }
        if (ctx.func_196000_l() == Direction.UP) {
            return (BlockState)blockState.func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        return (Boolean)state.func_177229_b((Property)TOP) != false ? SHAPE_TOP : SHAPE_BOTTOM;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        if (random.nextInt(16) == 0) {
            if (((Boolean)state.func_177229_b((Property)TOP)).booleanValue()) {
                return BlocksHelper.downRay((IWorld)world, pos, 3) > 0;
            }
            return BlocksHelper.upRay((IWorld)world, pos, 3) > 0;
        }
        return false;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)TOP)).booleanValue()) {
            STRUCTURE.generateDown((IServerWorld)world, pos, random);
        } else {
            STRUCTURE.generate((IServerWorld)world, pos, random);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return BlocksHelper.isNetherrack(world.func_180495_p(pos.func_177984_a())) || BlocksHelper.isNetherrack(world.func_180495_p(pos.func_177977_b()));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.func_177229_b((Property)TOP)).booleanValue()) {
            if (BlocksHelper.isNetherrack(world.func_180495_p(pos.func_177984_a()))) {
                return state;
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        if (BlocksHelper.isNetherrack(world.func_180495_p(pos.func_177977_b()))) {
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        super.func_225534_a_(state, world, pos, random);
        if (this.func_180670_a((World)world, random, pos, state)) {
            this.func_225535_a_(world, random, pos, state);
        }
    }
}

