/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.blocks.materials.MaterialBuilder;
import someoneelse.betternetherreforged.registry.BlocksRegistry;

public class BlockWillowBranch
extends BlockBaseNotFull {
    private static final VoxelShape V_SHAPE = BlockWillowBranch.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final EnumProperty<WillowBranchShape> SHAPE = EnumProperty.func_177709_a((String)"shape", WillowBranchShape.class);

    public BlockWillowBranch() {
        super(MaterialBuilder.makeWood(MaterialColor.field_193559_aa).func_226896_b_().func_200942_a().func_235838_a_(BlockWillowBranch.getLuminance()));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(SHAPE, (Comparable)((Object)WillowBranchShape.MIDDLE)));
    }

    protected static ToIntFunction<BlockState> getLuminance() {
        return state -> state.func_177229_b(SHAPE) == WillowBranchShape.END ? 15 : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader view, BlockPos pos) {
        return 1.0f;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{SHAPE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        return V_SHAPE;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (world.func_175623_d(pos.func_177984_a())) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)(state.func_177229_b(SHAPE) == WillowBranchShape.END ? BlocksRegistry.WILLOW_TORCH : BlocksRegistry.WILLOW_LEAVES));
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        if (state.func_177229_b(SHAPE) == WillowBranchShape.END) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)BlocksRegistry.WILLOW_TORCH)});
        }
        return Lists.newArrayList();
    }

    public static enum WillowBranchShape implements IStringSerializable
    {
        END("end"),
        MIDDLE("middle");

        final String name;

        private WillowBranchShape(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

