/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.entity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ITag;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.registry.SoundsRegistry;

public class EntityFirefly
extends AnimalEntity
implements IFlyingAnimal {
    private static final HashSet<Block> FLOWERS;
    private static final Vector3i[] SEARCH;
    private static final DataParameter<Float> COLOR_RED;
    private static final DataParameter<Float> COLOR_GREEN;
    private static final DataParameter<Float> COLOR_BLUE;
    private boolean mustSit = false;

    public EntityFirefly(EntityType<? extends EntityFirefly> type, World world) {
        super(type, world);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.field_70749_g = new FreflyLookControl((MobEntity)this);
        this.func_184644_a(PathNodeType.LAVA, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.field_70728_aV = 1;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.makeColor(this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.5f + 0.25f, 1.0f);
    }

    public static AttributeModifierMap getAttributeContainer() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 1.0).func_233815_a_(Attributes.field_233822_e_, 0.6).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233819_b_, 48.0).func_233813_a_();
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator birdNavigation = new FlyingPathNavigator((MobEntity)this, world){

            public boolean func_188555_b(BlockPos pos) {
                boolean valid;
                BlockState state = this.field_75513_b.func_180495_p(pos.func_177977_b());
                boolean bl = valid = !state.func_177230_c().isAir(state, (IBlockReader)this.field_75513_b, pos.func_177977_b()) && state.func_185904_a() != Material.field_151587_i;
                if (valid) {
                    state = this.field_75513_b.func_180495_p(pos);
                    valid = state.func_177230_c().isAir(state, (IBlockReader)this.field_75513_b, pos) || !state.func_185904_a().func_76230_c();
                    valid = valid && state.func_177230_c() != BlocksRegistry.EGG_PLANT;
                    valid = valid && !state.func_185904_a().func_76230_c();
                }
                return valid;
            }

            public void func_75501_e() {
                super.func_75501_e();
            }
        };
        birdNavigation.func_192879_a(false);
        birdNavigation.func_212239_d(false);
        birdNavigation.func_192878_b(true);
        return birdNavigation;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new SittingGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveToFlowersGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new WanderAroundGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new MoveRandomGoal());
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldView) {
        return worldView.func_180495_p(pos).func_177230_c().isAir(worldView.func_180495_p(pos), (IBlockReader)worldView, pos) ? 10.0f : 0.0f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151114_aO;
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    protected void func_180466_bG(ITag<Fluid> fluid) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public boolean func_225502_at_() {
        return false;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public float getRed() {
        return ((Float)this.field_70180_af.func_187225_a(COLOR_RED)).floatValue();
    }

    public float getGreen() {
        return ((Float)this.field_70180_af.func_187225_a(COLOR_GREEN)).floatValue();
    }

    public float getBlue() {
        return ((Float)this.field_70180_af.func_187225_a(COLOR_BLUE)).floatValue();
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74776_a("ColorRed", this.getRed());
        tag.func_74776_a("ColorGreen", this.getGreen());
        tag.func_74776_a("ColorBlue", this.getBlue());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("ColorRed")) {
            this.field_70180_af.func_187227_b(COLOR_RED, (Object)Float.valueOf(tag.func_74760_g("ColorRed")));
        }
        if (tag.func_74764_b("ColorGreen")) {
            this.field_70180_af.func_187227_b(COLOR_GREEN, (Object)Float.valueOf(tag.func_74760_g("ColorGreen")));
        }
        if (tag.func_74764_b("ColorBlue")) {
            this.field_70180_af.func_187227_b(COLOR_BLUE, (Object)Float.valueOf(tag.func_74760_g("ColorBlue")));
        }
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        return null;
    }

    private void checkMovement() {
        Vector3d vel = this.func_213322_ci();
        if (Math.abs(vel.field_72450_a) > 0.1 || Math.abs(vel.field_72449_c) > 0.1) {
            double d = Math.abs(this.field_70169_q - this.func_226277_ct_());
            if ((d += Math.abs(this.field_70166_s - this.func_226281_cx_())) < 0.1) {
                this.field_70699_by.func_75499_g();
            }
        }
    }

    public SoundEvent func_184639_G() {
        return SoundsRegistry.MOB_FIREFLY_FLY;
    }

    protected float func_70599_aP() {
        return MHelper.randRange(0.1f, 0.3f, this.field_70146_Z);
    }

    private void makeColor(float hue, float saturation, float brightness) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float f3 = (hue - (float)Math.floor(hue)) * 6.0f;
        float f4 = f3 - (float)Math.floor(f3);
        float f5 = brightness * (1.0f - saturation);
        float f6 = brightness * (1.0f - saturation * f4);
        float f7 = brightness * (1.0f - saturation * (1.0f - f4));
        switch ((int)f3) {
            case 0: {
                red = (byte)(brightness * 255.0f + 0.5f);
                green = (byte)(f7 * 255.0f + 0.5f);
                blue = (byte)(f5 * 255.0f + 0.5f);
                break;
            }
            case 1: {
                red = (byte)(f6 * 255.0f + 0.5f);
                green = (byte)(brightness * 255.0f + 0.5f);
                blue = (byte)(f5 * 255.0f + 0.5f);
                break;
            }
            case 2: {
                red = (byte)(f5 * 255.0f + 0.5f);
                green = (byte)(brightness * 255.0f + 0.5f);
                blue = (byte)(f7 * 255.0f + 0.5f);
                break;
            }
            case 3: {
                red = (byte)(f5 * 255.0f + 0.5f);
                green = (byte)(f6 * 255.0f + 0.5f);
                blue = (byte)(brightness * 255.0f + 0.5f);
                break;
            }
            case 4: {
                red = (byte)(f7 * 255.0f + 0.5f);
                green = (byte)(f5 * 255.0f + 0.5f);
                blue = (byte)(brightness * 255.0f + 0.5f);
                break;
            }
            case 5: {
                red = (byte)(brightness * 255.0f + 0.5f);
                green = (byte)(f5 * 255.0f + 0.5f);
                blue = (byte)(f6 * 255.0f + 0.5f);
            }
        }
        this.field_70180_af.func_187214_a(COLOR_RED, (Object)Float.valueOf(red / 255.0f));
        this.field_70180_af.func_187214_a(COLOR_GREEN, (Object)Float.valueOf(green / 255.0f));
        this.field_70180_af.func_187214_a(COLOR_BLUE, (Object)Float.valueOf(blue / 255.0f));
    }

    public int func_70641_bl() {
        return 5;
    }

    public static boolean canSpawn(EntityType<? extends EntityFirefly> type, IWorld world, SpawnReason spawnReason, BlockPos pos, Random rand) {
        if (pos.func_177956_o() >= world.func_230315_m_().func_241513_m_()) {
            return false;
        }
        int h = BlocksHelper.downRay(world, pos, 10);
        if (h > 8) {
            return false;
        }
        for (int i = 1; i <= h; ++i) {
            if (!BlocksHelper.isLava(world.func_180495_p(pos.func_177979_c(i)))) continue;
            return false;
        }
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    static {
        COLOR_RED = EntityDataManager.func_187226_a(EntityFirefly.class, (IDataSerializer)DataSerializers.field_187193_c);
        COLOR_GREEN = EntityDataManager.func_187226_a(EntityFirefly.class, (IDataSerializer)DataSerializers.field_187193_c);
        COLOR_BLUE = EntityDataManager.func_187226_a(EntityFirefly.class, (IDataSerializer)DataSerializers.field_187193_c);
        ArrayList<Vector3i> points = new ArrayList<Vector3i>();
        int radius = 6;
        int r2 = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > r2) continue;
                    points.add(new Vector3i(x, y, z));
                }
            }
        }
        points.sort(new Comparator<Vector3i>(){

            @Override
            public int compare(Vector3i v1, Vector3i v2) {
                int d1 = v1.func_177958_n() * v1.func_177958_n() + v1.func_177956_o() * v1.func_177956_o() + v1.func_177952_p() * v1.func_177952_p();
                int d2 = v2.func_177958_n() * v2.func_177958_n() + v2.func_177956_o() * v2.func_177956_o() + v2.func_177952_p() * v2.func_177952_p();
                return d1 - d2;
            }
        });
        SEARCH = points.toArray(new Vector3i[0]);
        FLOWERS = new HashSet();
        FLOWERS.add(BlocksRegistry.NETHER_GRASS);
        FLOWERS.add(BlocksRegistry.SOUL_GRASS);
        FLOWERS.add(BlocksRegistry.SWAMP_GRASS);
        FLOWERS.add(BlocksRegistry.BLACK_APPLE);
        FLOWERS.add(BlocksRegistry.MAGMA_FLOWER);
        FLOWERS.add(BlocksRegistry.SOUL_VEIN);
        FLOWERS.add(BlocksRegistry.NETHER_REED);
        FLOWERS.add(BlocksRegistry.INK_BUSH);
        FLOWERS.add(BlocksRegistry.INK_BUSH_SEED);
        FLOWERS.add(BlocksRegistry.POTTED_PLANT);
        FLOWERS.add(Blocks.field_150388_bm);
    }

    class MoveRandomGoal
    extends Goal {
        int timer;
        int ammount;

        MoveRandomGoal() {
        }

        public boolean func_75250_a() {
            return EntityFirefly.this.field_70699_by.func_75500_f() && EntityFirefly.this.field_70146_Z.nextInt(20) == 0;
        }

        public boolean func_75253_b() {
            return this.timer < this.ammount;
        }

        public void func_75249_e() {
            this.timer = 0;
            this.ammount = EntityFirefly.this.field_70146_Z.nextInt(30) + 10;
            Vector3d velocity = new Vector3d(EntityFirefly.this.field_70146_Z.nextDouble(), EntityFirefly.this.field_70146_Z.nextDouble(), EntityFirefly.this.field_70146_Z.nextDouble());
            if (velocity.func_189985_c() == 0.0) {
                velocity = new Vector3d(1.0, 0.0, 0.0);
            }
            EntityFirefly.this.func_213317_d(velocity.func_72432_b().func_186678_a((double)EntityFirefly.this.field_70747_aH));
            super.func_75249_e();
        }

        public void func_75246_d() {
            ++this.timer;
            super.func_75246_d();
        }
    }

    class SittingGoal
    extends Goal {
        int timer;
        int ammount;

        SittingGoal() {
        }

        public boolean func_75250_a() {
            if (EntityFirefly.this.mustSit && EntityFirefly.this.field_70699_by.func_75500_f()) {
                BlockPos pos = new BlockPos(EntityFirefly.this.func_226277_ct_(), EntityFirefly.this.func_226278_cu_(), EntityFirefly.this.func_226281_cx_());
                BlockState state = EntityFirefly.this.field_70170_p.func_180495_p(pos.func_177977_b());
                return !state.func_177230_c().isAir(state, (IBlockReader)EntityFirefly.this.field_70170_p, pos.func_177977_b()) && !state.func_185904_a().func_76224_d();
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.timer < this.ammount;
        }

        public void func_75249_e() {
            this.timer = 0;
            this.ammount = EntityFirefly.this.field_70146_Z.nextInt(21) + 20;
            EntityFirefly.this.mustSit = false;
            EntityFirefly.this.func_213293_j(0.0, -0.1, 0.0);
            super.func_75249_e();
        }

        public void func_75251_c() {
            EntityFirefly.this.func_213293_j(0.0, 0.1, 0.0);
            super.func_75251_c();
        }

        public void func_75246_d() {
            ++this.timer;
            super.func_75246_d();
        }
    }

    class MoveToFlowersGoal
    extends Goal {
        MoveToFlowersGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntityFirefly.this.field_70699_by.func_75500_f() && EntityFirefly.this.field_70146_Z.nextInt(30) == 0;
        }

        public boolean func_75253_b() {
            return EntityFirefly.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            BlockPos pos = this.getFlowerLocation();
            if (pos != null) {
                Path path = EntityFirefly.this.field_70699_by.func_179680_a(new BlockPos((Vector3i)pos), 1);
                EntityFirefly.this.field_70699_by.func_75484_a(path, 1.0);
            }
            super.func_75249_e();
        }

        public void func_75251_c() {
            if (this.isFlower(EntityFirefly.this.func_213339_cH())) {
                EntityFirefly.this.mustSit = true;
            }
            super.func_75251_c();
        }

        private BlockPos getFlowerLocation() {
            World w = EntityFirefly.this.field_70170_p;
            BlockPos.Mutable bpos = new BlockPos.Mutable();
            for (Vector3i offset : SEARCH) {
                bpos.func_189532_c(EntityFirefly.this.func_226277_ct_() + (double)offset.func_177958_n(), EntityFirefly.this.func_226278_cu_() + (double)offset.func_177956_o(), EntityFirefly.this.func_226281_cx_() + (double)offset.func_177952_p());
                if (!this.isFlower(w.func_180495_p((BlockPos)bpos))) continue;
                return bpos;
            }
            return null;
        }

        private boolean isFlower(BlockState state) {
            Block b = state.func_177230_c();
            return FLOWERS.contains(b);
        }

        public void func_75246_d() {
            EntityFirefly.this.checkMovement();
            super.func_75246_d();
        }
    }

    class WanderAroundGoal
    extends Goal {
        WanderAroundGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntityFirefly.this.field_70699_by.func_75500_f() && EntityFirefly.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return EntityFirefly.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            BlockPos pos = this.getRandomLocation();
            Path path = EntityFirefly.this.field_70699_by.func_179680_a(pos, 1);
            if (path != null) {
                EntityFirefly.this.field_70699_by.func_75484_a(path, 1.0);
            } else {
                EntityFirefly.this.func_213293_j(0.0, -0.2, 0.0);
            }
            super.func_75249_e();
        }

        private BlockPos getRandomLocation() {
            World w = EntityFirefly.this.field_70170_p;
            BlockPos.Mutable bpos = new BlockPos.Mutable();
            bpos.func_189532_c(EntityFirefly.this.func_226277_ct_(), EntityFirefly.this.func_226278_cu_(), EntityFirefly.this.func_226281_cx_());
            if (w.func_175623_d(bpos.func_177979_c(2)) && w.func_175623_d(bpos.func_177977_b())) {
                int y = bpos.func_177956_o() - 1;
                while (w.func_175623_d(bpos.func_177979_c(2)) && y > 0) {
                    bpos.func_185336_p(y--);
                }
                return bpos;
            }
            Vector3d angle = EntityFirefly.this.func_70676_i(0.0f);
            Vector3d airTarget = RandomPositionGenerator.func_226340_a_((CreatureEntity)EntityFirefly.this, (int)8, (int)7, (Vector3d)angle, (float)1.5707964f, (int)2, (int)1);
            if (airTarget == null) {
                airTarget = RandomPositionGenerator.func_226340_a_((CreatureEntity)EntityFirefly.this, (int)16, (int)10, (Vector3d)angle, (float)1.5707964f, (int)3, (int)1);
            }
            if (airTarget == null) {
                bpos.func_223471_o(bpos.func_177958_n() + this.randomRange(8));
                bpos.func_223472_q(bpos.func_177952_p() + this.randomRange(8));
                bpos.func_185336_p(bpos.func_177956_o() + this.randomRange(2));
                return bpos;
            }
            bpos.func_189532_c(airTarget.func_82615_a(), airTarget.func_82617_b(), airTarget.func_82616_c());
            return bpos;
        }

        private int randomRange(int side) {
            Random rand = EntityFirefly.this.field_70146_Z;
            return rand.nextInt(side + 1) - (side >> 1);
        }

        public void func_75246_d() {
            EntityFirefly.this.checkMovement();
            super.func_75246_d();
        }
    }

    class FreflyLookControl
    extends LookController {
        FreflyLookControl(MobEntity entity) {
            super(entity);
        }

        protected boolean shouldStayHorizontal() {
            return true;
        }
    }
}

