/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ShieldItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.registry.SoundsRegistry;

public class EntitySkull
extends MonsterEntity
implements IFlyingAnimal {
    private static double particleX;
    private static double particleY;
    private static double particleZ;
    private int attackTick;
    private int dirTickTick;
    private int collideTick;

    public EntitySkull(EntityType<? extends EntitySkull> type, World world) {
        super(type, world);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.field_70749_g = new SkullLookControl((MobEntity)this);
        this.func_184644_a(PathNodeType.LAVA, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.field_70728_aV = 1;
        this.field_70747_aH = 0.5f;
    }

    public static AttributeModifierMap getAttributeContainer() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233822_e_, 0.5).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233813_a_();
    }

    public void func_70100_b_(PlayerEntity player) {
        ++this.collideTick;
        if (this.collideTick > 3) {
            boolean shield;
            this.collideTick = 0;
            boolean bl = shield = player.func_184607_cu().func_77973_b() instanceof ShieldItem && player.func_184587_cr();
            if (shield) {
                player.func_184185_a(SoundEvents.field_187767_eL, MHelper.randRange(0.8f, 1.2f, this.field_70146_Z), MHelper.randRange(0.8f, 1.2f, this.field_70146_Z));
                this.func_213317_d(new Vector3d(0.0, 0.0, 0.0).func_178788_d(this.func_213322_ci()));
            }
            if (player instanceof ServerPlayerEntity) {
                if (shield) {
                    player.func_184607_cu().func_96631_a(1, this.field_70146_Z, (ServerPlayerEntity)player);
                    if (player.func_184607_cu().func_77952_i() > player.func_184607_cu().func_77958_k()) {
                        player.func_213334_d(player.func_184600_cs());
                        if (player.func_184600_cs().equals((Object)Hand.MAIN_HAND)) {
                            player.field_71071_by.field_70462_a.clear();
                        } else if (player.func_184600_cs().equals((Object)Hand.OFF_HAND)) {
                            player.field_71071_by.field_184439_c.clear();
                        }
                        player.func_184602_cy();
                    }
                    return;
                }
                player.func_70097_a(DamageSource.field_76377_j, 1.0f);
                if (this.field_70146_Z.nextInt(16) == 0) {
                    player.func_70015_d(3);
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.updateParticlePos();
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.updateParticlePos();
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197617_j, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.updateParticlePos();
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        if (this.attackTick > 40 && this.func_70089_S()) {
            PlayerEntity target = this.field_70170_p.func_217366_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 20.0, true);
            if (target != null && this.func_70685_l((Entity)target)) {
                this.attackTick = 0;
                Vector3d velocity = target.func_213303_ch().func_72441_c(0.0, (double)(target.func_213302_cg() * 0.5f), 0.0).func_178788_d(this.func_213303_ch()).func_72432_b().func_186678_a((double)this.field_70747_aH);
                this.func_213317_d(velocity);
                this.func_70625_a((Entity)target, 360.0f, 360.0f);
                this.func_184185_a(SoundsRegistry.MOB_SKULL_FLIGHT, MHelper.randRange(0.15f, 0.3f, this.field_70146_Z), MHelper.randRange(0.9f, 1.5f, this.field_70146_Z));
            } else if (this.dirTickTick < 0) {
                this.dirTickTick = MHelper.randRange(20, 60, this.field_70146_Z);
                this.moveRandomDir();
            }
        } else if (this.dirTickTick < 0) {
            this.dirTickTick = MHelper.randRange(20, 60, this.field_70146_Z);
            this.moveRandomDir();
        }
        ++this.attackTick;
        --this.dirTickTick;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    private void moveRandomDir() {
        double dz;
        double dy;
        double dx = this.field_70146_Z.nextDouble() - 0.5;
        double l = dx * dx + (dy = this.field_70146_Z.nextDouble() - 0.5) * dy + (dz = this.field_70146_Z.nextDouble() - 0.5) * dz;
        l = l == 0.0 ? 1.0 : (double)((float)Math.sqrt(l));
        this.func_213293_j(dx /= (l /= (double)this.field_70747_aH), dy /= l, dz /= l);
        this.lookAt(this.func_213303_ch().func_178787_e(this.func_213322_ci()));
        this.func_184185_a(SoundsRegistry.MOB_SKULL_FLIGHT, MHelper.randRange(0.15f, 0.3f, this.field_70146_Z), MHelper.randRange(0.75f, 1.25f, this.field_70146_Z));
    }

    private void lookAt(Vector3d target) {
        float j;
        double d = target.func_82615_a() - this.func_226277_ct_();
        double e = target.func_82616_c() - this.func_226281_cx_();
        double g = target.func_82617_b() - this.func_226278_cu_();
        double h = MathHelper.func_76133_a((double)(d * d + e * e));
        float i = (float)(MathHelper.func_181159_b((double)e, (double)d) * 57.2957763671875) - 90.0f;
        this.field_70125_A = j = (float)(-(MathHelper.func_181159_b((double)g, (double)h) * 57.2957763671875));
        this.field_70177_z = i;
    }

    private void updateParticlePos() {
        particleX = this.field_70146_Z.nextDouble() - 0.5;
        double l = particleX * particleX + (particleY = this.field_70146_Z.nextDouble() - 0.5) * particleY + (particleZ = this.field_70146_Z.nextDouble() - 0.5) * particleZ;
        l = l == 0.0 ? 1.0 : (double)((float)Math.sqrt(l));
        particleX = particleX * 0.5 / l + this.func_226277_ct_();
        particleY = particleY * 0.5 / l + this.func_226278_cu_();
        particleZ = particleZ * 0.5 / l + this.func_226281_cx_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213307_e(Pose pose) {
        return this.func_213305_a((Pose)pose).field_220316_b * 0.5f;
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public boolean func_225502_at_() {
        return false;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public static boolean canSpawn(EntityType<? extends EntitySkull> type, IWorld world, SpawnReason spawnReason, BlockPos pos, Random rand) {
        if (world.func_175659_aa() == Difficulty.PEACEFUL || world.func_201696_r(pos) > 7) {
            return false;
        }
        if (pos.func_177956_o() >= world.func_230315_m_().func_241513_m_()) {
            return false;
        }
        AxisAlignedBB box = new AxisAlignedBB(pos).func_72321_a(256.0, 256.0, 256.0);
        List list = world.func_175647_a(EntitySkull.class, box, entity -> true);
        return list.size() < 4;
    }

    class SkullLookControl
    extends LookController {
        SkullLookControl(MobEntity entity) {
            super(entity);
        }

        protected boolean shouldStayHorizontal() {
            return false;
        }
    }
}

