/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures;

import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.noise.OpenSimplexNoise;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureCaves
implements IStructure {
    private static final boolean[][][] MASK = new boolean[16][24][16];
    private static final BlockPos.Mutable B_POS = new BlockPos.Mutable();
    private static int offset = 12;
    private OpenSimplexNoise heightNoise;
    private OpenSimplexNoise rigidNoise;
    private OpenSimplexNoise distortX;
    private OpenSimplexNoise distortY;

    public StructureCaves(long seed) {
        Random random = new Random(seed);
        this.heightNoise = new OpenSimplexNoise(random.nextLong());
        this.rigidNoise = new OpenSimplexNoise(random.nextLong());
        this.distortX = new OpenSimplexNoise(random.nextLong());
        this.distortY = new OpenSimplexNoise(random.nextLong());
    }

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        int wz;
        int z;
        int wx;
        int x;
        boolean isVoid = true;
        offset = (int)(this.getHeight(pos.func_177958_n() + 8, pos.func_177952_p() + 8) - 12.0);
        for (x = 0; x < 16; ++x) {
            wx = pos.func_177958_n() + x;
            for (z = 0; z < 16; ++z) {
                wz = pos.func_177952_p() + z;
                double height = this.getHeight(wx, wz);
                double rigid = this.getRigid(wx, wz);
                for (int y = 0; y < 24; ++y) {
                    int wy = offset + y;
                    double hRigid = Math.abs((double)wy - height);
                    double sdf = -this.opSmoothUnion(-hRigid / 30.0, -rigid, 0.15);
                    if (sdf < 0.15) {
                        StructureCaves.MASK[x][y][z] = true;
                        isVoid = false;
                        continue;
                    }
                    StructureCaves.MASK[x][y][z] = false;
                }
            }
        }
        if (isVoid) {
            return;
        }
        for (x = 0; x < 16; ++x) {
            wx = pos.func_177958_n() + x;
            for (z = 0; z < 16; ++z) {
                wz = pos.func_177952_p() + z;
                for (int y = 23; y >= 0; --y) {
                    int wy = offset + y;
                    B_POS.func_181079_c(wx, wy, wz);
                    if (!MASK[x][y][z] || !BlocksHelper.isNetherGroundMagma(world.func_180495_p((BlockPos)B_POS))) continue;
                    BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)B_POS, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    private double getHeight(int x, int z) {
        return this.heightNoise.eval((double)x * 0.01, (double)z * 0.01) * 32.0 + 64.0;
    }

    private double getRigid(int x, int z) {
        return Math.abs(this.rigidNoise.eval((double)x * 0.02 + this.distortX.eval((double)x * 0.05, (double)z * 0.05) * 0.2, (double)z * 0.02 + this.distortY.eval((double)x * 0.05, (double)z * 0.05) * 0.2)) * 0.6;
    }

    private double mix(double dist1, double dist2, double blend) {
        return dist1 * (1.0 - blend) + dist2 * blend;
    }

    private double opSmoothUnion(double dist1, double dist2, double blend) {
        double h = 0.5 + 0.5 * (dist2 - dist1) / blend;
        h = h > 1.0 ? 1.0 : (h < 0.0 ? 0.0 : h);
        return this.mix(dist2, dist1, h) - blend * h * (1.0 - h);
    }

    public boolean isInCave(int x, int y, int z) {
        int y2 = y - offset;
        if (y2 >= 0 && y < 24) {
            return MASK[x][y2][z];
        }
        return false;
    }
}

