/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LanternBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.noise.OpenSimplexNoise;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructurePath
implements IStructure {
    private static final BlockPos.Mutable B_POS = new BlockPos.Mutable();
    private OpenSimplexNoise heightNoise;
    private OpenSimplexNoise rigidNoise;
    private OpenSimplexNoise distortX;
    private OpenSimplexNoise distortY;

    public StructurePath(long seed) {
        Random random = new Random(seed);
        this.heightNoise = new OpenSimplexNoise(random.nextLong());
        this.rigidNoise = new OpenSimplexNoise(random.nextLong());
        this.distortX = new OpenSimplexNoise(random.nextLong());
        this.distortY = new OpenSimplexNoise(random.nextLong());
    }

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        for (int x = 0; x < 16; ++x) {
            int wx = pos.func_177958_n() + x;
            B_POS.func_223471_o(wx);
            for (int z = 0; z < 16; ++z) {
                int wz = pos.func_177952_p() + z;
                B_POS.func_223472_q(wz);
                double rigid = this.getRigid(wx, wz) + (double)MHelper.randRange(0.0f, 0.015f, random);
                if (!(rigid < 0.015)) continue;
                int height = this.getHeight(wx, wz);
                B_POS.func_185336_p(height);
                height -= BlocksHelper.downRay((IWorld)world, (BlockPos)B_POS, height);
                B_POS.func_185336_p(height);
                if (!world.func_175623_d((BlockPos)B_POS) || !world.func_180495_p((BlockPos)B_POS.func_189536_c(Direction.DOWN)).func_235785_r_((IBlockReader)world, (BlockPos)B_POS) || !this.isHeightValid((IWorld)world, B_POS.func_177984_a())) continue;
                Biome biome = world.func_226691_t_((BlockPos)B_POS);
                BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)B_POS, this.getRoadMaterial(world, (BlockPos)B_POS, biome));
                if (this.needsSlab(world, B_POS.func_177984_a())) {
                    BlocksHelper.setWithoutUpdate((IWorld)world, B_POS.func_177984_a(), this.getSlabMaterial(world, (BlockPos)B_POS, biome));
                    continue;
                }
                if (!(rigid > 0.01) || (x & 3) != 0 || (z & 3) != 0 || random.nextInt(8) != 0) continue;
                this.makeLantern((IWorld)world, B_POS.func_177984_a());
            }
        }
    }

    private int getHeight(int x, int z) {
        return (int)(this.heightNoise.eval((double)x * 0.001, (double)z * 0.001) * 32.0 + 64.0);
    }

    private double getRigid(double x, double z) {
        return Math.abs(this.rigidNoise.eval((x *= 0.1) * 0.02 + this.distortX.eval(x * 0.05, (z *= 0.1) * 0.05) * 0.2, z * 0.02 + this.distortY.eval(x * 0.05, z * 0.05) * 0.2));
    }

    private boolean isHeightValid(IWorld world, BlockPos pos) {
        return Math.abs(BlocksHelper.downRay(world, pos.func_177964_d(2), 5) - BlocksHelper.downRay(world, pos.func_177970_e(2), 5)) < 3 && Math.abs(BlocksHelper.downRay(world, pos.func_177965_g(2), 5) - BlocksHelper.downRay(world, pos.func_177985_f(2), 5)) < 3;
    }

    private void makeLantern(IWorld world, BlockPos pos) {
        BlocksHelper.setWithoutUpdate(world, pos, BlocksRegistry.NETHER_BRICK_WALL.func_176223_P());
        BlocksHelper.setWithoutUpdate(world, pos.func_177984_a(), Blocks.field_150386_bk.func_176223_P());
        BlocksHelper.setWithoutUpdate(world, pos.func_177981_b(2), Blocks.field_150386_bk.func_176223_P());
        Direction dir = Direction.NORTH;
        double d = 1000.0;
        double v = this.getRigid(pos.func_177958_n(), pos.func_177952_p());
        for (Direction face : BlocksHelper.HORIZONTAL) {
            BlockPos p = pos.func_177972_a(face);
            double v2 = this.getRigid(p.func_177958_n(), p.func_177952_p());
            double d2 = v - v2;
            if (!(d2 < d)) continue;
            d = d2;
            dir = face;
        }
        BlockPos p = pos.func_177981_b(3);
        BlocksHelper.setWithoutUpdate(world, p, Blocks.field_150386_bk.func_176223_P());
        world.func_217349_x(p).func_201594_d(new BlockPos(p.func_177958_n() & 0xF, p.func_177956_o(), p.func_177952_p() & 0xF));
        p = p.func_177972_a(dir.func_176734_d());
        BlocksHelper.setWithoutUpdate(world, p, Blocks.field_150386_bk.func_176223_P());
        world.func_217349_x(p).func_201594_d(new BlockPos(p.func_177958_n() & 0xF, p.func_177956_o(), p.func_177952_p() & 0xF));
        BlocksHelper.setWithoutUpdate(world, p.func_177977_b(), (BlockState)Blocks.field_222432_lU.func_176223_P().func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)));
    }

    private BlockState getRoadMaterial(IServerWorld world, BlockPos pos, Biome biome) {
        return Blocks.field_235337_cO_.func_176223_P();
    }

    private BlockState getSlabMaterial(IServerWorld world, BlockPos pos, Biome biome) {
        return BlocksRegistry.BASALT_SLAB.func_176223_P();
    }

    private boolean needsSlab(IServerWorld world, BlockPos pos) {
        for (Direction dir : BlocksHelper.HORIZONTAL) {
            BlockState state = world.func_180495_p(pos.func_177972_a(dir));
            if (!BlocksHelper.isNetherGround(state) && state.func_177230_c() != Blocks.field_235337_cO_ && state.func_177230_c() != BlocksRegistry.SOUL_SANDSTONE || world.func_180495_p(pos.func_177977_b().func_177972_a(dir.func_176734_d())).func_196958_f()) continue;
            return true;
        }
        return false;
    }
}

