/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.decorations;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.noise.OpenSimplexNoise;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureCrystal
implements IStructure {
    private static final Block[] PALETTES = new Block[]{BlocksRegistry.OBSIDIAN_GLASS, Blocks.field_150343_Z, BlocksRegistry.BLUE_OBSIDIAN_GLASS, BlocksRegistry.BLUE_OBSIDIAN};
    private static final double SQRT05 = Math.sqrt(0.5);
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    private static final float MAX_ANGLE_X = (float)Math.toRadians(45.0);
    private static final float MAX_ANGLE_Y = (float)Math.PI * 2;
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(0L);

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        int index = random.nextInt(PALETTES.length >> 1);
        double a = random.nextDouble();
        double radius = 2.0 + a * a * 5.0;
        int sideXZ = (int)Math.ceil(radius * 2.0);
        int sideY = (int)Math.ceil(radius * 3.0);
        float angleX = random.nextFloat() * MAX_ANGLE_X;
        float angleY = random.nextFloat() * ((float)Math.PI * 2);
        for (int y = -sideY; y <= sideY; ++y) {
            for (int x = -sideXZ; x <= sideXZ; ++x) {
                for (int z = -sideXZ; z <= sideXZ; ++z) {
                    Vector3d v = new Vector3d((double)x, (double)y, (double)z).func_178789_a(angleX).func_178785_b(angleY);
                    if (!this.isInside(v.field_72450_a, v.field_72448_b, v.field_72449_c, radius)) continue;
                    POS.func_223471_o(pos.func_177958_n() + x);
                    POS.func_185336_p(pos.func_177956_o() + y);
                    POS.func_223472_q(pos.func_177952_p() + z);
                    BlockState state = random.nextInt(40) == 0 && this.isNotEdge(v.field_72450_a, v.field_72448_b, v.field_72449_c, radius) ? Blocks.field_150426_aN.func_176223_P() : this.getState(index, v);
                    BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)POS, state);
                }
            }
        }
    }

    private boolean isInside(double x, double y, double z, double size) {
        return this.dodecahedronSDF(x / size, y / size * 0.3, z / size) <= 0.0;
    }

    private boolean isNotEdge(double x, double y, double z, double size) {
        return this.isInside(x + 1.0, y, z, size) && this.isInside(x - 1.0, y, z, size) && this.isInside(x, y + 1.0, z, size) && this.isInside(x, y - 1.0, z, size) && this.isInside(x, y, z + 1.0, size) && this.isInside(x, y, z - 1.0, size);
    }

    private double dodecahedronSDF(double x, double y, double z) {
        x = Math.abs(x);
        y = Math.abs(y);
        z = Math.abs(z);
        return (Math.max(Math.max(x + y, y + z), z + x) - 1.0) * SQRT05;
    }

    private double rigidNoise(Vector3d pos, double scale) {
        double val = NOISE.eval(pos.field_72450_a * scale, pos.field_72448_b * scale, pos.field_72449_c * scale);
        return Math.abs(val);
    }

    private BlockState getState(int index, Vector3d pos) {
        int subindex = this.rigidNoise(pos, 0.2) > 0.2 ? 0 : 1;
        int blockIndex = index << 1 | subindex;
        return PALETTES[blockIndex].func_176223_P();
    }
}

