/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.blocks.BlockPlantWall;
import someoneelse.betternetherreforged.noise.OpenSimplexNoise;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureAnchorTree
implements IStructure {
    protected static final OpenSimplexNoise NOISE = new OpenSimplexNoise(2145L);
    private static final Set<BlockPos> BLOCKS = new HashSet<BlockPos>(2048);
    private Block[] wallPlants;

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        if (this.canGenerate(pos)) {
            this.grow(world, pos, pos.func_177979_c(BlocksHelper.downRay((IWorld)world, pos, 255)), random);
        }
    }

    private boolean canGenerate(BlockPos pos) {
        return (pos.func_177958_n() & 0xF) == 7 && (pos.func_177952_p() & 0xF) == 7;
    }

    private void grow(IServerWorld world, BlockPos up, BlockPos down, Random random) {
        if (up.func_177956_o() - down.func_177956_o() < 30) {
            return;
        }
        int pd = BlocksHelper.downRay((IWorld)world, down, 128) + 1;
        for (int i = 0; i < 5; ++i) {
            Block block = world.func_180495_p(down.func_177979_c(pd + i)).func_177230_c();
            if (block != Blocks.field_196653_dH && block != BlocksRegistry.NETHER_BRICK_TILE_LARGE && block != BlocksRegistry.NETHER_BRICK_TILE_SMALL) continue;
            return;
        }
        BlockPos trunkTop = this.lerp(down, up, 0.6);
        BlockPos trunkBottom = this.lerp(down, up, 0.3);
        int count = (trunkTop.func_177956_o() - trunkBottom.func_177956_o()) / 7;
        if (count < 2) {
            count = 2;
        }
        List<BlockPos> blocks = this.line(trunkBottom, trunkTop, count, random, 2.5);
        BLOCKS.clear();
        if (this.wallPlants == null) {
            this.wallPlants = new Block[]{BlocksRegistry.JUNGLE_MOSS, BlocksRegistry.JUNGLE_MOSS, BlocksRegistry.WALL_MUSHROOM_BROWN, BlocksRegistry.WALL_MUSHROOM_RED};
        }
        this.buildLine(blocks, 4.0);
        count = (up.func_177956_o() - down.func_177956_o()) / 10 - 1;
        if (count < 3) {
            count = 3;
        }
        this.buildBigCircle(trunkTop, 15, count, 2, random.nextDouble() * Math.PI * 2.0, 3.5, random);
        this.buildBigCircle(trunkBottom, -15, count, 2, random.nextDouble() * Math.PI * 2.0, 3.5, random);
        int offset = random.nextInt(4);
        for (BlockPos bpos : BLOCKS) {
            BlockState state;
            if (bpos.func_177956_o() < 1 || bpos.func_177956_o() > 126 || !BlocksHelper.isNetherGround(state = world.func_180495_p(bpos)) && !state.func_185904_a().func_76222_j()) continue;
            boolean blockUp = true;
            blockUp = BLOCKS.contains(bpos.func_177984_a());
            if (blockUp && BLOCKS.contains(bpos.func_177977_b())) {
                BlocksHelper.setWithUpdate((IWorld)world, bpos, BlocksRegistry.ANCHOR_TREE.log.func_176223_P());
            } else {
                BlocksHelper.setWithUpdate((IWorld)world, bpos, BlocksRegistry.ANCHOR_TREE.bark.func_176223_P());
            }
            if (bpos.func_177956_o() > 45 && bpos.func_177956_o() < 90 && (bpos.func_177956_o() & 3) == offset && NOISE.eval((double)bpos.func_177958_n() * 0.1, (double)bpos.func_177956_o() * 0.1, (double)bpos.func_177952_p() * 0.1) > 0.0) {
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.func_177978_c())) {
                    StructureAnchorTree.makeMushroom(world, bpos.func_177978_c(), random.nextDouble() * 3.0 + 1.5);
                }
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.func_177968_d())) {
                    StructureAnchorTree.makeMushroom(world, bpos.func_177968_d(), random.nextDouble() * 3.0 + 1.5);
                }
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.func_177974_f())) {
                    StructureAnchorTree.makeMushroom(world, bpos.func_177974_f(), random.nextDouble() * 3.0 + 1.5);
                }
                if (random.nextInt(32) == 0 && !BLOCKS.contains(bpos.func_177976_e())) {
                    StructureAnchorTree.makeMushroom(world, bpos.func_177976_e(), random.nextDouble() * 3.0 + 1.5);
                }
            }
            if (bpos.func_177956_o() <= 64) continue;
            if (!blockUp && world.func_180495_p(bpos.func_177984_a()).func_185904_a().func_76222_j()) {
                BlocksHelper.setWithUpdate((IWorld)world, bpos.func_177984_a(), BlocksRegistry.MOSS_COVER.func_176223_P());
            }
            if (!(NOISE.eval((double)bpos.func_177958_n() * 0.05, (double)bpos.func_177956_o() * 0.05, (double)bpos.func_177952_p() * 0.05) > 0.0)) continue;
            state = this.wallPlants[random.nextInt(this.wallPlants.length)].func_176223_P();
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.func_177978_c()) && world.func_175623_d(bpos.func_177978_c())) {
                BlocksHelper.setWithUpdate((IWorld)world, bpos.func_177978_c(), (BlockState)state.func_206870_a((Property)BlockPlantWall.FACING, (Comparable)Direction.NORTH));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.func_177968_d()) && world.func_175623_d(bpos.func_177968_d())) {
                BlocksHelper.setWithUpdate((IWorld)world, bpos.func_177968_d(), (BlockState)state.func_206870_a((Property)BlockPlantWall.FACING, (Comparable)Direction.SOUTH));
            }
            if (random.nextInt(8) == 0 && !BLOCKS.contains(bpos.func_177974_f()) && world.func_175623_d(bpos.func_177974_f())) {
                BlocksHelper.setWithUpdate((IWorld)world, bpos.func_177974_f(), (BlockState)state.func_206870_a((Property)BlockPlantWall.FACING, (Comparable)Direction.EAST));
            }
            if (random.nextInt(8) != 0 || BLOCKS.contains(bpos.func_177976_e()) || !world.func_175623_d(bpos.func_177976_e())) continue;
            BlocksHelper.setWithUpdate((IWorld)world, bpos.func_177976_e(), (BlockState)state.func_206870_a((Property)BlockPlantWall.FACING, (Comparable)Direction.WEST));
        }
    }

    private void buildBigCircle(BlockPos pos, int length, int count, int iteration, double angle, double size, Random random) {
        if (iteration < 0) {
            return;
        }
        List<List<BlockPos>> lines = this.circleLinesEnds(pos, angle, count, length, (double)Math.abs(length) * 0.7, random);
        double sizeSmall = size * 0.8;
        length = (int)((double)length * 0.8);
        angle += Math.PI * 4 / (double)count;
        angle += random.nextDouble() * angle * 0.75;
        for (List<BlockPos> line : lines) {
            this.buildLine(line, size);
            this.buildBigCircle(line.get(1), length, count, iteration - 1, angle, sizeSmall, random);
        }
    }

    private void buildLine(List<BlockPos> blocks, double radius) {
        for (int i = 0; i < blocks.size() - 1; ++i) {
            double max;
            BlockPos a = blocks.get(i);
            BlockPos b = blocks.get(i + 1);
            if (b.func_177956_o() < a.func_177956_o()) {
                BlockPos c = b;
                b = a;
                a = c;
            }
            if ((max = (double)(b.func_177956_o() - a.func_177956_o())) < 1.0) {
                max = 1.0;
            }
            for (int y = a.func_177956_o(); y <= b.func_177956_o(); ++y) {
                this.cylinder(this.lerpCos(a, b, y, (double)(y - a.func_177956_o()) / max), radius);
            }
        }
    }

    private BlockPos lerp(BlockPos start, BlockPos end, double mix) {
        double x = MathHelper.func_219803_d((double)mix, (double)start.func_177958_n(), (double)end.func_177958_n());
        double y = MathHelper.func_219803_d((double)mix, (double)start.func_177956_o(), (double)end.func_177956_o());
        double z = MathHelper.func_219803_d((double)mix, (double)start.func_177952_p(), (double)end.func_177952_p());
        return new BlockPos(x, y, z);
    }

    private BlockPos lerpCos(BlockPos start, BlockPos end, int y, double mix) {
        double v = this.lcos(mix);
        double x = MathHelper.func_219803_d((double)v, (double)start.func_177958_n(), (double)end.func_177958_n());
        double z = MathHelper.func_219803_d((double)v, (double)start.func_177952_p(), (double)end.func_177952_p());
        return new BlockPos(x, (double)y, z);
    }

    private double lcos(double mix) {
        return MathHelper.func_151237_a((double)(0.5 - Math.cos(mix * Math.PI) * 0.5), (double)0.0, (double)1.0);
    }

    private List<BlockPos> line(BlockPos start, BlockPos end, int count, Random random, double range) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(count);
        int max = count - 1;
        result.add(start);
        for (int i = 1; i < max; ++i) {
            double delta = (double)i / (double)max;
            double x = MathHelper.func_219803_d((double)delta, (double)start.func_177958_n(), (double)end.func_177958_n()) + random.nextGaussian() * range;
            double y = MathHelper.func_219803_d((double)delta, (double)start.func_177956_o(), (double)end.func_177956_o());
            double z = MathHelper.func_219803_d((double)delta, (double)start.func_177952_p(), (double)end.func_177952_p()) + random.nextGaussian() * range;
            result.add(new BlockPos(x, y, z));
        }
        result.add(end);
        return result;
    }

    private void cylinder(BlockPos pos, double radius) {
        int x1 = MHelper.floor((double)pos.func_177958_n() - radius);
        int z1 = MHelper.floor((double)pos.func_177952_p() - radius);
        int x2 = MHelper.floor((double)pos.func_177958_n() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.func_177952_p() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.func_177958_n();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.func_177952_p();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius * (NOISE.eval((double)x * 0.5, (double)pos.func_177956_o() * 0.5, (double)z * 0.5) * 0.25 + 0.75))) continue;
                BLOCKS.add(new BlockPos(x, pos.func_177956_o(), z));
            }
        }
    }

    private List<List<BlockPos>> circleLinesEnds(BlockPos pos, double startAngle, int count, int height, double radius, Random random) {
        ArrayList<List<BlockPos>> result = new ArrayList<List<BlockPos>>(count);
        double angle = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.func_177958_n() + Math.sin(startAngle) * radius;
            double z = (double)pos.func_177952_p() + Math.cos(startAngle) * radius;
            BlockPos end = new BlockPos(x, (double)(pos.func_177956_o() + height) + (double)height * random.nextDouble() * 0.5, z);
            ArrayList<BlockPos> elem = new ArrayList<BlockPos>(2);
            elem.add(pos);
            elem.add(end);
            result.add(elem);
            startAngle += angle;
        }
        return result;
    }

    protected static void makeMushroom(IServerWorld world, BlockPos pos, double radius) {
        if (!world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            return;
        }
        int x1 = MHelper.floor((double)pos.func_177958_n() - radius);
        int z1 = MHelper.floor((double)pos.func_177952_p() - radius);
        int x2 = MHelper.floor((double)pos.func_177958_n() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.func_177952_p() + radius + 1.0);
        radius *= radius;
        ArrayList<BlockPos> placed = new ArrayList<BlockPos>((int)(radius * 4.0));
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.func_177958_n();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                BlockPos p;
                int pz2 = z - pos.func_177952_p();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius) || !world.func_180495_p(p = new BlockPos(x, pos.func_177956_o(), z)).func_185904_a().func_76222_j()) continue;
                placed.add(p);
            }
        }
        for (BlockPos p : placed) {
            boolean north = world.func_180495_p(p.func_177978_c()).func_177230_c() != BlocksRegistry.GIANT_LUCIS;
            boolean south = world.func_180495_p(p.func_177968_d()).func_177230_c() != BlocksRegistry.GIANT_LUCIS;
            boolean east = world.func_180495_p(p.func_177974_f()).func_177230_c() != BlocksRegistry.GIANT_LUCIS;
            boolean west = world.func_180495_p(p.func_177976_e()).func_177230_c() != BlocksRegistry.GIANT_LUCIS;
            BlockState state = BlocksRegistry.GIANT_LUCIS.func_176223_P();
            BlocksHelper.setWithUpdate((IWorld)world, p, (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(north))).func_206870_a((Property)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(south))).func_206870_a((Property)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(west)));
        }
    }
}

