/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.blocks.BlockAnchorTreeVine;
import someoneelse.betternetherreforged.blocks.shapes.TripleShape;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureAnchorTreeBranch
implements IStructure {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{-20.0f, -17.0f, -12.0f, -4.0f, 0.0f, 2.0f};
    private static final int MIDDLE_Y = 10;
    private static final Set<BlockPos> POINTS = new HashSet<BlockPos>();
    private static final Set<BlockPos> MIDDLE = new HashSet<BlockPos>();
    private static final Set<BlockPos> TOP = new HashSet<BlockPos>();
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        if (pos.func_177956_o() < 96) {
            return;
        }
        this.grow(world, pos, random, true);
    }

    public void grow(IServerWorld world, BlockPos pos, Random random, boolean natural) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 0);
        float scale = MHelper.randRange(0.5f, 1.0f, random);
        int minCount = (double)scale < 0.75 ? 3 : 4;
        int maxCount = (double)scale < 0.75 ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 0.8f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize;
            int x1 = Math.round((float)pos.func_177958_n() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.func_177956_o() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.func_177952_p() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 9.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((IWorld)world, new BlockPos(x1, y1 + 1, z1), crownR, random);
            int middle = Math.round((float)pos.func_177956_o() + (float)(10 + MHelper.randRange(-2, 2, random)) * branchSize);
            boolean generate = true;
            for (int i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.func_177958_n() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.func_177956_o() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.func_177952_p() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] >= 0.0f && this.canReplace(world.func_180495_p((BlockPos)POS.func_181079_c(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (this.canReplace(world.func_180495_p((BlockPos)POS.func_181079_c(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.func_177958_n();
                        y2 = pos.func_177956_o();
                        generate = false;
                    }
                }
                this.line((IWorld)world, x1, y1, z1, x2, y2, z2, middle);
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        Iterator<BlockPos> iterator = TOP.iterator();
        while (iterator.hasNext()) {
            BlockPos bpos = iterator.next();
            if (bpos == null || !POINTS.contains(bpos.func_177984_a()) || TOP.contains(bpos.func_177984_a())) continue;
            iterator.remove();
        }
        iterator = MIDDLE.iterator();
        while (iterator.hasNext()) {
            BlockPos bpos = iterator.next();
            if (bpos != null) {
                BlockPos up = bpos.func_177984_a();
                if (!MIDDLE.contains(up) && (TOP.contains(up) || !POINTS.contains(up))) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        for (BlockPos bpos : POINTS) {
            BlockState state = POINTS.contains(bpos.func_177984_a()) && POINTS.contains(bpos.func_177977_b()) ? BlocksRegistry.ANCHOR_TREE.log.func_176223_P() : BlocksRegistry.ANCHOR_TREE.bark.func_176223_P();
            BlocksHelper.setWithUpdate((IWorld)world, bpos, state);
        }
        POINTS.clear();
        MIDDLE.clear();
        TOP.clear();
    }

    private void line(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2, int middleY) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        BlockPos pos = POS.func_181079_c(x1, y1, z1).func_185334_h();
        POINTS.add(pos);
        if (pos.func_177956_o() == middleY) {
            MIDDLE.add(pos);
        } else if (pos.func_177956_o() > middleY) {
            TOP.add(pos);
        }
        pos = POS.func_181079_c(x2, y2, z2).func_185334_h();
        POINTS.add(pos);
        if (pos.func_177956_o() == middleY) {
            MIDDLE.add(pos);
        } else if (pos.func_177956_o() > middleY) {
            TOP.add(pos);
        }
        for (int i = 0; i < mx; ++i) {
            POS.func_181079_c(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            pos = POS.func_185334_h();
            POINTS.add(pos);
            if (POS.func_177956_o() == middleY) {
                MIDDLE.add(pos);
                continue;
            }
            if (POS.func_177956_o() <= middleY) continue;
            TOP.add(pos);
        }
    }

    private void crown(IWorld world, BlockPos pos, float radius, Random random) {
        int start;
        BlockState leaves = BlocksRegistry.ANCHOR_TREE_LEAVES.func_176223_P();
        BlockState vine = BlocksRegistry.ANCHOR_TREE_VINE.func_176223_P();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int cy = start = (int)Math.floor(-radius);
        while ((float)cy <= radius) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            POS.func_185336_p((int)((float)(pos.func_177956_o() + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx;
                POS.func_223471_o(pos.func_177958_n() + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    int cz2 = cz * cz;
                    if ((float)(cx2 + cy2_out + cz2) < r2 && (float)cx2 + cy2_in + (float)cz2 > r2) {
                        POS.func_223472_q(pos.func_177952_p() + cz);
                        if (world.func_180495_p((BlockPos)POS).func_185904_a().func_76222_j()) {
                            int length = BlocksHelper.downRay(world, (BlockPos)POS, 17);
                            if (length < 5) {
                                BlocksHelper.setWithUpdate(world, (BlockPos)POS, leaves);
                            } else {
                                if (length > 15) {
                                    length = MHelper.randRange(12, 15, random);
                                } else if (length > 12) {
                                    length = MHelper.randRange(12, length, random);
                                }
                                for (int i = 1; i < length - 2; ++i) {
                                    BlocksHelper.setWithUpdate(world, POS.func_177979_c(i), vine);
                                }
                                BlocksHelper.setWithUpdate(world, POS.func_177979_c(length - 2), (BlockState)vine.func_206870_a(BlockAnchorTreeVine.SHAPE, (Comparable)((Object)TripleShape.MIDDLE)));
                                BlocksHelper.setWithUpdate(world, POS.func_177979_c(length - 1), (BlockState)vine.func_206870_a(BlockAnchorTreeVine.SHAPE, (Comparable)((Object)TripleShape.BOTTOM)));
                                BlocksHelper.setWithUpdate(world, (BlockPos)POS, leaves);
                            }
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
    }

    private boolean canReplace(BlockState state) {
        return BlocksHelper.isNetherGround(state) || state.func_185904_a().func_76222_j();
    }
}

