/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BlockJellyfishMushroom;
import someoneelse.betternetherreforged.blocks.shapes.TripleShape;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureJellyfishMushroom
implements IStructure {
    BlockPos.Mutable npos = new BlockPos.Mutable();

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a((ITag)BlockTags.field_232873_an_)) {
            block0: for (int i = 0; i < 10; ++i) {
                int x = pos.func_177958_n() + (int)(random.nextGaussian() * 2.0);
                int z = pos.func_177952_p() + (int)(random.nextGaussian() * 2.0);
                int y = pos.func_177956_o() + random.nextInt(6);
                for (int j = 0; j < 6; ++j) {
                    this.npos.func_181079_c(x, y - j, z);
                    if (this.npos.func_177956_o() <= 31) continue block0;
                    Block under = world.func_180495_p(this.npos.func_177977_b()).func_177230_c();
                    if (!under.func_203417_a((ITag)BlockTags.field_232873_an_) || !world.func_175623_d((BlockPos)this.npos)) continue;
                    this.grow(world, (BlockPos)this.npos, random);
                }
            }
        }
    }

    public void grow(IServerWorld world, BlockPos pos, Random random) {
        if (random.nextBoolean() && world.func_175623_d(pos.func_177984_a())) {
            this.growMedium(world, pos);
        } else {
            this.growSmall(world, pos);
        }
    }

    public void growSmall(IServerWorld world, BlockPos pos) {
        Block down = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        BlockJellyfishMushroom.JellyShape visual = down == BlocksRegistry.MUSHROOM_GRASS ? BlockJellyfishMushroom.JellyShape.NORMAL : (down == BlocksRegistry.SEPIA_MUSHROOM_GRASS ? BlockJellyfishMushroom.JellyShape.SEPIA : BlockJellyfishMushroom.JellyShape.POOR);
        BlocksHelper.setWithUpdate((IWorld)world, pos, (BlockState)((BlockState)BlocksRegistry.JELLYFISH_MUSHROOM.func_176223_P().func_206870_a(BlockJellyfishMushroom.SHAPE, (Comparable)((Object)TripleShape.BOTTOM))).func_206870_a(BlockJellyfishMushroom.VISUAL, (Comparable)((Object)visual)));
    }

    public void growMedium(IServerWorld world, BlockPos pos) {
        Block down = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        BlockJellyfishMushroom.JellyShape visual = down == BlocksRegistry.MUSHROOM_GRASS ? BlockJellyfishMushroom.JellyShape.NORMAL : (down == BlocksRegistry.SEPIA_MUSHROOM_GRASS ? BlockJellyfishMushroom.JellyShape.SEPIA : BlockJellyfishMushroom.JellyShape.POOR);
        BlocksHelper.setWithUpdate((IWorld)world, pos, (BlockState)((BlockState)BlocksRegistry.JELLYFISH_MUSHROOM.func_176223_P().func_206870_a(BlockJellyfishMushroom.SHAPE, (Comparable)((Object)TripleShape.MIDDLE))).func_206870_a(BlockJellyfishMushroom.VISUAL, (Comparable)((Object)visual)));
        BlocksHelper.setWithUpdate((IWorld)world, pos.func_177984_a(), (BlockState)((BlockState)BlocksRegistry.JELLYFISH_MUSHROOM.func_176223_P().func_206870_a(BlockJellyfishMushroom.SHAPE, (Comparable)((Object)TripleShape.TOP))).func_206870_a(BlockJellyfishMushroom.VISUAL, (Comparable)((Object)visual)));
    }
}

