/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BlockBrownLargeMushroom;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureMedBrownMushroom
implements IStructure {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == BlocksRegistry.NETHER_MYCELIUM) {
            for (int i = 0; i < 10; ++i) {
                int z;
                int x = pos.func_177958_n() + (int)(random.nextGaussian() * 2.0);
                if ((x + (z = pos.func_177952_p() + (int)(random.nextGaussian() * 2.0)) + 1 & 1) == 0) {
                    if (random.nextBoolean()) {
                        x += random.nextBoolean() ? 1 : -1;
                    } else {
                        z += random.nextBoolean() ? 1 : -1;
                    }
                }
                int y = pos.func_177956_o() + random.nextInt(6);
                for (int j = 0; j < 12; ++j) {
                    POS.func_181079_c(x, y - j, z);
                    Block under = world.func_180495_p(POS.func_177977_b()).func_177230_c();
                    if (under != BlocksRegistry.NETHER_MYCELIUM) continue;
                    this.grow(world, (BlockPos)POS, random);
                }
            }
        }
    }

    public void grow(IServerWorld world, BlockPos pos, Random random) {
        int size = 2 + random.nextInt(3);
        for (int y = 1; y <= size; ++y) {
            if (world.func_175623_d(pos.func_177981_b(y))) continue;
            if (y < 3) {
                return;
            }
            size = y - 1;
            break;
        }
        boolean hasAir = true;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                hasAir = hasAir && world.func_175623_d(pos.func_177981_b(size).func_177982_a(x, 0, z));
            }
        }
        if (hasAir) {
            BlockState middle = (BlockState)BlocksRegistry.BROWN_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.BrownMushroomShape.MIDDLE));
            BlocksHelper.setWithUpdate((IWorld)world, pos, (BlockState)BlocksRegistry.BROWN_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.BrownMushroomShape.BOTTOM)));
            for (int y = 1; y < size; ++y) {
                BlocksHelper.setWithUpdate((IWorld)world, pos.func_177981_b(y), middle);
            }
            pos = pos.func_177981_b(size);
            BlocksHelper.setWithUpdate((IWorld)world, pos, (BlockState)BlocksRegistry.BROWN_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.BrownMushroomShape.TOP)));
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177978_c(), (BlockState)BlocksRegistry.BROWN_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.BrownMushroomShape.SIDE_N)));
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177968_d(), (BlockState)BlocksRegistry.BROWN_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.BrownMushroomShape.SIDE_S)));
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177974_f(), (BlockState)BlocksRegistry.BROWN_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.BrownMushroomShape.SIDE_E)));
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177976_e(), (BlockState)BlocksRegistry.BROWN_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.BrownMushroomShape.SIDE_W)));
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177978_c().func_177974_f(), (BlockState)BlocksRegistry.BROWN_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.BrownMushroomShape.CORNER_N)));
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177978_c().func_177976_e(), (BlockState)BlocksRegistry.BROWN_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.BrownMushroomShape.CORNER_W)));
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177968_d().func_177974_f(), (BlockState)BlocksRegistry.BROWN_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.BrownMushroomShape.CORNER_E)));
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177968_d().func_177976_e(), (BlockState)BlocksRegistry.BROWN_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)BlockBrownLargeMushroom.BrownMushroomShape.CORNER_S)));
        }
    }
}

