/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BlockRedLargeMushroom;
import someoneelse.betternetherreforged.blocks.shapes.TripleShape;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureMedRedMushroom
implements IStructure {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == BlocksRegistry.NETHER_MYCELIUM) {
            for (int i = 0; i < 10; ++i) {
                int z;
                int x = pos.func_177958_n() + (int)(random.nextGaussian() * 2.0);
                if ((x + (z = pos.func_177952_p() + (int)(random.nextGaussian() * 2.0)) & 1) == 0) {
                    if (random.nextBoolean()) {
                        x += random.nextBoolean() ? 1 : -1;
                    } else {
                        z += random.nextBoolean() ? 1 : -1;
                    }
                }
                int y = pos.func_177956_o() + random.nextInt(6);
                for (int j = 0; j < 12; ++j) {
                    POS.func_181079_c(x, y - j, z);
                    Block under = world.func_180495_p(POS.func_177977_b()).func_177230_c();
                    if (under != BlocksRegistry.NETHER_MYCELIUM) continue;
                    this.grow(world, (BlockPos)POS, random);
                }
            }
        }
    }

    public void grow(IServerWorld world, BlockPos pos, Random random) {
        int size = 1 + random.nextInt(4);
        for (int y = 1; y <= size; ++y) {
            if (world.func_175623_d(pos.func_177981_b(y))) continue;
            if (y == 1) {
                return;
            }
            size = y - 1;
            break;
        }
        BlockState middle = (BlockState)BlocksRegistry.RED_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockRedLargeMushroom.SHAPE, (Comparable)((Object)TripleShape.MIDDLE));
        for (int y = 1; y < size; ++y) {
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177981_b(y), middle);
        }
        BlocksHelper.setWithUpdate((IWorld)world, pos.func_177981_b(size), (BlockState)BlocksRegistry.RED_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockRedLargeMushroom.SHAPE, (Comparable)((Object)TripleShape.TOP)));
        BlocksHelper.setWithUpdate((IWorld)world, pos, (BlockState)BlocksRegistry.RED_LARGE_MUSHROOM.func_176223_P().func_206870_a(BlockRedLargeMushroom.SHAPE, (Comparable)((Object)TripleShape.BOTTOM)));
    }
}

