/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureNetherSakura
implements IStructure {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    private static final BlockPos.Mutable POS2 = new BlockPos.Mutable();

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        if (pos.func_177956_o() < 96) {
            return;
        }
        this.grow(world, pos, random, true);
    }

    public void grow(IServerWorld world, BlockPos pos, Random random, boolean natural) {
        int l = MHelper.randRange(15, 24, random);
        double height = MHelper.randRange(10, 15, random);
        double radius = height * (0.2 + random.nextDouble() * 0.1);
        if ((double)l + height - (double)BlocksHelper.downRay((IWorld)world, pos, (int)((double)l + height)) > 10.0) {
            return;
        }
        l = BlocksHelper.downRay((IWorld)world, pos, l + 1);
        int l2 = l * 2 / 3;
        for (int x = -3; x <= 3; ++x) {
            int x2 = x * x;
            POS.func_223471_o(pos.func_177958_n() + x);
            for (int z = -3; z <= 3; ++z) {
                int z2 = z * z;
                double d = (double)(x2 + z2) + 1.4;
                if (!(d < 10.0)) continue;
                if (d < 2.8 || random.nextBoolean()) {
                    int start;
                    POS.func_223472_q(pos.func_177952_p() + z);
                    double length = (double)MHelper.randRange(l2, l, random) / (d > 2.0 ? d : 1.0);
                    if (length < 1.0) {
                        length = 1.0;
                    }
                    int y = start = MHelper.randRange(-2, 0, random);
                    while ((double)y < length) {
                        POS.func_185336_p(pos.func_177956_o() - y);
                        if (this.canReplace(world.func_180495_p((BlockPos)POS))) {
                            BlocksHelper.setWithUpdate((IWorld)world, (BlockPos)POS, BlocksRegistry.NETHER_SAKURA.log.func_176223_P());
                        }
                        ++y;
                    }
                    if (BlocksRegistry.NETHER_SAKURA.isTreeLog(world.func_180495_p((BlockPos)POS).func_177230_c())) {
                        BlocksHelper.setWithUpdate((IWorld)world, (BlockPos)POS, BlocksRegistry.NETHER_SAKURA.bark.func_176223_P());
                    }
                }
                if (!(d < 2.0)) continue;
                this.crown((IWorld)world, (BlockPos)POS, radius, height, random);
            }
        }
    }

    private void crown(IWorld world, BlockPos pos, double radius, double height, Random random) {
        int cz2;
        int cz;
        int cx2;
        int cx;
        BlockState leaves = BlocksRegistry.NETHER_SAKURA_LEAVES.func_176223_P();
        double r2 = radius * radius;
        int start = (int)Math.floor(-radius);
        int cy = 0;
        while ((double)cy <= radius) {
            int cy2 = cy * cy;
            POS2.func_185336_p(pos.func_177956_o() + cy);
            cx = start;
            while ((double)cx <= radius) {
                cx2 = cx * cx;
                POS2.func_223471_o(pos.func_177958_n() + cx);
                cz = start;
                while ((double)cz <= radius) {
                    cz2 = cz * cz;
                    if ((double)(cx2 + cy2 + cz2) < r2) {
                        POS2.func_223472_q(pos.func_177952_p() + cz);
                        if (world.func_180495_p((BlockPos)POS2).func_185904_a().func_76222_j()) {
                            BlocksHelper.setWithUpdate(world, (BlockPos)POS2, leaves);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
        int cy2 = 0;
        while ((double)cy2 <= height) {
            r2 = radius * (1.0 - (double)cy2 / height);
            r2 *= r2;
            POS2.func_223471_o(pos.func_177958_n());
            POS2.func_223472_q(pos.func_177952_p());
            POS2.func_185336_p(pos.func_177956_o() - cy2);
            BlockState state = world.func_180495_p((BlockPos)POS2);
            if (!state.func_185904_a().func_76222_j() && !BlocksRegistry.NETHER_SAKURA.isTreeLog(state.func_177230_c())) {
                return;
            }
            cx = start;
            while ((double)cx <= radius) {
                cx2 = cx * cx;
                POS2.func_223471_o(pos.func_177958_n() + cx);
                cz = start;
                while ((double)cz <= radius) {
                    cz2 = cz * cz;
                    if ((double)(cx2 + cz2) < r2) {
                        POS2.func_223472_q(pos.func_177952_p() + cz);
                        if (world.func_180495_p((BlockPos)POS2).func_185904_a().func_76222_j()) {
                            BlocksHelper.setWithUpdate(world, (BlockPos)POS2, leaves);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy2;
        }
    }

    private boolean canReplace(BlockState state) {
        return BlocksHelper.isNetherGround(state) || state.func_185904_a().func_76222_j();
    }
}

