/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureWall
implements IStructure {
    private static final Direction[] DIRECTIONS = HorizontalBlock.field_185512_D.func_177700_c().toArray(new Direction[0]);
    private static final Direction[] SHUFFLED = new Direction[DIRECTIONS.length];
    private final Block plantBlock;

    public StructureWall(Block plantBlock) {
        this.plantBlock = plantBlock;
    }

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        BlockState state;
        if (world.func_175623_d(pos) && (state = this.getPlacementState(world, pos, random)) != null) {
            BlocksHelper.setWithoutUpdate((IWorld)world, pos, state);
        }
    }

    private BlockState getPlacementState(IServerWorld world, BlockPos pos, Random random) {
        BlockState blockState = this.plantBlock.func_176223_P();
        this.shuffle(random);
        for (int i = 0; i < 4; ++i) {
            Direction direction = SHUFFLED[i];
            Direction direction2 = direction.func_176734_d();
            if (!(blockState = (BlockState)blockState.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)direction2)).func_196955_c((IWorldReader)world, pos)) continue;
            return blockState;
        }
        return null;
    }

    private void shuffle(Random random) {
        int i;
        for (i = 0; i < 4; ++i) {
            StructureWall.SHUFFLED[i] = DIRECTIONS[i];
        }
        for (i = 0; i < 4; ++i) {
            int i2 = random.nextInt(4);
            Direction d = SHUFFLED[i2];
            StructureWall.SHUFFLED[i2] = SHUFFLED[i];
            StructureWall.SHUFFLED[i] = d;
        }
    }
}

