/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BlockWartSeed;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.StructureFuncScatter;

public class StructureWartTree
extends StructureFuncScatter {
    private static final BlockState WART_BLOCK = Blocks.field_189878_dg.func_176223_P();
    private static final Direction[] HORIZONTAL = HorizontalBlock.field_185512_D.func_177700_c().toArray(new Direction[0]);

    public StructureWartTree() {
        super(7);
    }

    @Override
    public void grow(IServerWorld world, BlockPos pos, Random random) {
        if (world.func_175623_d(pos.func_177981_b(1)) && world.func_175623_d(pos.func_177981_b(2)) && world.func_175623_d(pos.func_177981_b(2).func_177978_c()) && world.func_175623_d(pos.func_177981_b(2).func_177968_d()) && world.func_175623_d(pos.func_177981_b(2).func_177974_f()) && world.func_175623_d(pos.func_177981_b(2).func_177976_e()) && world.func_175623_d(pos.func_177981_b(3).func_177964_d(2)) && world.func_175623_d(pos.func_177981_b(3).func_177970_e(2)) && world.func_175623_d(pos.func_177981_b(3).func_177965_g(2)) && world.func_175623_d(pos.func_177981_b(3).func_177985_f(2))) {
            int py;
            int y;
            int pz;
            int z;
            int px;
            int x;
            int height = 5 + random.nextInt(5);
            int h2 = height - 1;
            int width = (height >>> 2) + 1;
            int offset = width >>> 1;
            ArrayList<BlockPos> seedBlocks = new ArrayList<BlockPos>();
            for (x = 0; x < width; ++x) {
                px = x + pos.func_177958_n() - offset;
                for (z = 0; z < width; ++z) {
                    pz = z + pos.func_177952_p() - offset;
                    for (y = 0; y < height; ++y) {
                        py = y + pos.func_177956_o();
                        POS.func_181079_c(px, py, pz);
                        if (!this.isReplaceable(world.func_180495_p((BlockPos)POS))) continue;
                        if (y == 0 && !this.isReplaceable(world.func_180495_p(POS.func_177977_b()))) {
                            BlocksHelper.setWithUpdate((IWorld)world, (BlockPos)POS, BlocksRegistry.WART_ROOTS.func_176223_P());
                        } else if (y < h2) {
                            BlocksHelper.setWithUpdate((IWorld)world, (BlockPos)POS, BlocksRegistry.WART_LOG.func_176223_P());
                        } else {
                            BlocksHelper.setWithUpdate((IWorld)world, (BlockPos)POS, WART_BLOCK);
                        }
                        if (random.nextInt(8) != 0) continue;
                        Direction dir = HORIZONTAL[random.nextInt(HORIZONTAL.length)];
                        seedBlocks.add(new BlockPos((Vector3i)POS).func_177972_a(dir));
                    }
                }
            }
            for (x = 0; x < width; ++x) {
                px = x + pos.func_177958_n() - offset;
                block4: for (z = 0; z < width; ++z) {
                    pz = z + pos.func_177952_p() - offset;
                    for (y = 1; y < height >> 1; ++y) {
                        py = pos.func_177956_o() - y;
                        POS.func_181079_c(px, py, pz);
                        if (!this.isReplaceable(world.func_180495_p((BlockPos)POS))) continue;
                        if (this.isReplaceable(world.func_180495_p(POS.func_177977_b()))) {
                            BlocksHelper.setWithUpdate((IWorld)world, (BlockPos)POS, BlocksRegistry.WART_LOG.func_176223_P());
                            continue;
                        }
                        BlocksHelper.setWithUpdate((IWorld)world, (BlockPos)POS, BlocksRegistry.WART_ROOTS.func_176223_P());
                        continue block4;
                    }
                }
            }
            int headWidth = width + 2;
            ++offset;
            height = height - width - 1 + pos.func_177956_o();
            for (int x2 = 0; x2 < headWidth; ++x2) {
                int px2 = x2 + pos.func_177958_n() - offset;
                for (int z2 = 0; z2 < headWidth; ++z2) {
                    if (x2 == z2 || x2 == headWidth - z2 - 1) continue;
                    int pz2 = z2 + pos.func_177952_p() - offset;
                    for (int y2 = 0; y2 < width; ++y2) {
                        int py2 = y2 + height;
                        POS.func_181079_c(px2, py2, pz2);
                        if (!world.func_175623_d((BlockPos)POS)) continue;
                        BlocksHelper.setWithUpdate((IWorld)world, (BlockPos)POS, WART_BLOCK);
                        for (int i = 0; i < 4; ++i) {
                            seedBlocks.add(new BlockPos((Vector3i)POS).func_177972_a(Direction.values()[random.nextInt(6)]));
                        }
                    }
                }
            }
            for (BlockPos pos2 : seedBlocks) {
                this.PlaceRandomSeed((IWorld)world, pos2);
            }
        }
    }

    private void PlaceRandomSeed(IWorld world, BlockPos pos) {
        BlockState seed = BlocksRegistry.WART_SEED.func_176223_P();
        if (this.isReplaceable(world.func_180495_p(pos))) {
            if (this.isWart(world.func_180495_p(pos.func_177984_a()))) {
                seed = (BlockState)seed.func_206870_a((Property)BlockWartSeed.FACING, (Comparable)Direction.DOWN);
            } else if (this.isWart(world.func_180495_p(pos.func_177977_b()))) {
                seed = (BlockState)seed.func_206870_a((Property)BlockWartSeed.FACING, (Comparable)Direction.UP);
            } else if (this.isWart(world.func_180495_p(pos.func_177978_c()))) {
                seed = (BlockState)seed.func_206870_a((Property)BlockWartSeed.FACING, (Comparable)Direction.SOUTH);
            } else if (this.isWart(world.func_180495_p(pos.func_177968_d()))) {
                seed = (BlockState)seed.func_206870_a((Property)BlockWartSeed.FACING, (Comparable)Direction.NORTH);
            } else if (this.isWart(world.func_180495_p(pos.func_177974_f()))) {
                seed = (BlockState)seed.func_206870_a((Property)BlockWartSeed.FACING, (Comparable)Direction.WEST);
            } else if (this.isWart(world.func_180495_p(pos.func_177976_e()))) {
                seed = (BlockState)seed.func_206870_a((Property)BlockWartSeed.FACING, (Comparable)Direction.EAST);
            }
            BlocksHelper.setWithUpdate(world, pos, seed);
        }
    }

    private boolean isReplaceable(BlockState state) {
        Block block = state.func_177230_c();
        return state.func_185904_a().func_76222_j() || block == Blocks.field_150350_a || block == BlocksRegistry.WART_SEED || block == BlocksRegistry.BLACK_BUSH || block == BlocksRegistry.SOUL_VEIN || block == BlocksRegistry.SOUL_LILY || block == BlocksRegistry.SOUL_LILY_SAPLING || block == Blocks.field_150388_bm;
    }

    private boolean isWart(BlockState state) {
        return state == WART_BLOCK || state.func_177230_c() == BlocksRegistry.WART_LOG;
    }

    @Override
    protected boolean isStructure(BlockState state) {
        return this.isWart(state);
    }

    @Override
    protected boolean isGround(BlockState state) {
        return BlocksHelper.isSoulSand(state);
    }
}

