/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.structures.plants;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BlockWillowBranch;
import someoneelse.betternetherreforged.blocks.BlockWillowLeaves;
import someoneelse.betternetherreforged.blocks.BlockWillowTrunk;
import someoneelse.betternetherreforged.blocks.shapes.TripleShape;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.IStructure;

public class StructureWillow
implements IStructure {
    private static final Direction[] HOR = HorizontalBlock.field_185512_D.func_177700_c().toArray(new Direction[0]);

    @Override
    public void generate(IServerWorld world, BlockPos pos, Random random) {
        int i;
        if (!BlocksHelper.isNetherGround(world.func_180495_p(pos.func_177977_b()))) {
            return;
        }
        int h2 = 5 + random.nextInt(3);
        int mh = BlocksHelper.upRay((IWorld)world, pos.func_177984_a(), h2);
        if (mh < 5) {
            return;
        }
        h2 = Math.min(h2, mh);
        BlocksHelper.setWithUpdate((IWorld)world, pos, (BlockState)BlocksRegistry.WILLOW_TRUNK.func_176223_P().func_206870_a(BlockWillowTrunk.SHAPE, (Comparable)((Object)TripleShape.BOTTOM)));
        for (int h = 1; h < h2; ++h) {
            if (!world.func_175623_d(pos.func_177981_b(h))) continue;
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177981_b(h), (BlockState)BlocksRegistry.WILLOW_TRUNK.func_176223_P().func_206870_a(BlockWillowTrunk.SHAPE, (Comparable)((Object)TripleShape.MIDDLE)));
        }
        if (world.func_175623_d(pos.func_177981_b(h2))) {
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177981_b(h2), (BlockState)BlocksRegistry.WILLOW_TRUNK.func_176223_P().func_206870_a(BlockWillowTrunk.SHAPE, (Comparable)((Object)TripleShape.TOP)));
        }
        for (i = 0; i < 4; ++i) {
            this.branch(world, pos.func_177981_b(h2).func_177972_a(HOR[i]), 3 + random.nextInt(2), random, HOR[i], pos.func_177981_b(h2), 0);
        }
        BlocksHelper.setWithUpdate((IWorld)world, pos.func_177981_b(h2 + 1), (BlockState)BlocksRegistry.WILLOW_LEAVES.func_176223_P().func_206870_a((Property)BlockWillowLeaves.FACING, (Comparable)Direction.UP));
        for (i = 0; i < 4; ++i) {
            BlocksHelper.setWithUpdate((IWorld)world, pos.func_177981_b(h2 + 1).func_177972_a(HOR[i]), (BlockState)BlocksRegistry.WILLOW_LEAVES.func_176223_P().func_206870_a((Property)BlockWillowLeaves.FACING, (Comparable)HOR[i]));
        }
    }

    private void branch(IServerWorld world, BlockPos pos, int length, Random random, Direction direction, BlockPos center, int level) {
        if (level > 5) {
            return;
        }
        BlockPos.Mutable bpos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        BlocksHelper.setWithUpdate((IWorld)world, (BlockPos)bpos, (BlockState)BlocksRegistry.WILLOW_LEAVES.func_176223_P().func_206870_a((Property)BlockWillowLeaves.FACING, (Comparable)direction));
        this.vine(world, pos.func_177977_b(), 1 + random.nextInt(1));
        Direction preDir = direction;
        int l2 = length * length;
        for (int i = 0; i < l2; ++i) {
            Direction dir2;
            BlockPos p2;
            Direction dir = random.nextInt(3) > 0 ? preDir : (random.nextBoolean() ? preDir.func_176746_e() : preDir.func_176735_f());
            BlockPos p = bpos.func_177972_a(dir);
            if (!world.func_175623_d(p)) continue;
            bpos.func_189533_g((Vector3i)p);
            if (bpos.func_218139_n((Vector3i)center) > length) break;
            BlocksHelper.setWithUpdate((IWorld)world, (BlockPos)bpos, (BlockState)BlocksRegistry.WILLOW_LEAVES.func_176223_P().func_206870_a((Property)BlockWillowLeaves.FACING, (Comparable)dir));
            if (random.nextBoolean()) {
                BlocksHelper.setWithUpdate((IWorld)world, bpos.func_177984_a(), (BlockState)BlocksRegistry.WILLOW_LEAVES.func_176223_P().func_206870_a((Property)BlockWillowLeaves.FACING, (Comparable)Direction.UP));
            }
            if (random.nextInt(3) == 0) {
                bpos.func_185336_p(bpos.func_177956_o() - 1);
                BlocksHelper.setWithUpdate((IWorld)world, (BlockPos)bpos, (BlockState)BlocksRegistry.WILLOW_LEAVES.func_176223_P().func_206870_a((Property)BlockWillowLeaves.FACING, (Comparable)Direction.DOWN));
            }
            if (random.nextBoolean()) {
                this.vine(world, bpos.func_177977_b(), 1 + random.nextInt(4));
            }
            if (random.nextBoolean()) {
                Direction right = dir.func_176746_e();
                p2 = bpos.func_177972_a(right);
                if (world.func_175623_d(p2)) {
                    this.branch(world, p2, length, random, right, center, level + 1);
                }
                if (world.func_175623_d(p2 = bpos.func_177972_a(right = right.func_176734_d()))) {
                    this.branch(world, p2, length, random, right, center, level + 1);
                }
            }
            if (world.func_175623_d(p2 = bpos.func_177972_a(dir2 = HOR[random.nextInt(4)]))) {
                BlocksHelper.setWithUpdate((IWorld)world, p2, (BlockState)BlocksRegistry.WILLOW_LEAVES.func_176223_P().func_206870_a((Property)BlockWillowLeaves.FACING, (Comparable)dir2));
            }
            preDir = dir;
        }
        if (random.nextBoolean() && world.func_175623_d((BlockPos)bpos)) {
            BlocksHelper.setWithUpdate((IWorld)world, (BlockPos)bpos, (BlockState)BlocksRegistry.WILLOW_LEAVES.func_176223_P().func_206870_a((Property)BlockWillowLeaves.FACING, (Comparable)preDir));
        }
    }

    private void vine(IServerWorld world, BlockPos pos, int length) {
        if (!world.func_175623_d(pos)) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            BlockPos p = pos.func_177979_c(i);
            if (!world.func_175623_d(p.func_177977_b())) {
                BlocksHelper.setWithUpdate((IWorld)world, p, (BlockState)BlocksRegistry.WILLOW_BRANCH.func_176223_P().func_206870_a(BlockWillowBranch.SHAPE, (Comparable)((Object)BlockWillowBranch.WillowBranchShape.END)));
                return;
            }
            BlocksHelper.setWithUpdate((IWorld)world, p, (BlockState)BlocksRegistry.WILLOW_BRANCH.func_176223_P().func_206870_a(BlockWillowBranch.SHAPE, (Comparable)((Object)BlockWillowBranch.WillowBranchShape.MIDDLE)));
        }
        BlocksHelper.setWithUpdate((IWorld)world, pos.func_177979_c(length), (BlockState)BlocksRegistry.WILLOW_BRANCH.func_176223_P().func_206870_a(BlockWillowBranch.SHAPE, (Comparable)((Object)BlockWillowBranch.WillowBranchShape.END)));
    }
}

