/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.world;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.blocks.BlockStalactite;
import someoneelse.betternetherreforged.config.Configs;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.registry.NetherBiomesRegistry;
import someoneelse.betternetherreforged.structures.StructureCaves;
import someoneelse.betternetherreforged.structures.StructurePath;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.world.structures.CityFeature;

public class BNWorldGenerator {
    private static boolean hasCleaningPass;
    private static boolean hasFixPass;
    private static float cincinnasiteDensity;
    private static float rubyDensity;
    private static float lapisDensity;
    private static float structureDensity;
    private static float lavaStructureDensity;
    private static float globalDensity;
    private static final BlockState AIR;
    private static BlockPos.Mutable popPos;
    private static final NetherBiome[][][] BIOMES;
    private static final List<BlockPos> LIST_FLOOR;
    private static final List<BlockPos> LIST_WALL;
    private static final List<BlockPos> LIST_CEIL;
    private static final List<BlockPos> LIST_LAVA;
    private static final HashSet<Biome> MC_BIOMES;
    private static boolean hasCaves;
    private static boolean hasPaths;
    private static StructureCaves caves;
    private static StructurePath paths;
    private static NetherBiome biome;
    protected static int biomeSizeXZ;
    protected static int biomeSizeY;
    protected static boolean volumetric;
    public static final CityFeature CITY;
    public static final StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> CITY_CONFIGURED;
    public static int distance;
    public static int separation;

    public static void onModInit() {
        hasCleaningPass = Configs.GENERATOR.getBoolean("generator.world.terrain", "terrain_cleaning_pass", true);
        hasFixPass = Configs.GENERATOR.getBoolean("generator.world.terrain", "world_fixing_pass", true);
        hasCaves = Configs.GENERATOR.getBoolean("generator.world.environment", "generate_caves", true);
        hasPaths = Configs.GENERATOR.getBoolean("generator.world.environment", "generate_paths", true);
        cincinnasiteDensity = Configs.GENERATOR.getFloat("generator.world.ores", "cincinnasite_ore_density", 9.765625E-4f);
        rubyDensity = Configs.GENERATOR.getFloat("generator.world.ores", "ruby_ore_density", 2.5E-4f);
        lapisDensity = Configs.GENERATOR.getFloat("generator.world.ores", "lapis_ore_density", 2.5E-4f);
        structureDensity = Configs.GENERATOR.getFloat("generator.world", "structures_density", 0.0625f) * 1.0001f;
        lavaStructureDensity = Configs.GENERATOR.getFloat("generator.world", "lava_structures_density", 0.005f) * 1.0001f;
        globalDensity = Configs.GENERATOR.getFloat("generator.world", "global_plant_and_structures_density", 1.0f) * 1.0001f;
        biomeSizeXZ = Configs.GENERATOR.getInt("generator_world", "biome_size_xz", 200);
        biomeSizeY = Configs.GENERATOR.getInt("generator_world", "biome_size_y", 40);
        volumetric = Configs.GENERATOR.getBoolean("generator_world", "volumetric_biomes", true);
        Configs.GENERATOR.getBoolean("generator.world.cities", "generate", true);
    }

    public static void init(long seed) {
        caves = new StructureCaves(seed);
        paths = new StructurePath(seed + 1L);
    }

    private static NetherBiome getBiomeLocal(int x, int y, int z, Random random) {
        int px = (int)Math.round((double)x + random.nextGaussian() * 0.5) >> 1;
        int py = (int)Math.round((double)y + random.nextGaussian() * 0.5) >> 1;
        int pz = (int)Math.round((double)z + random.nextGaussian() * 0.5) >> 1;
        return BIOMES[BNWorldGenerator.clamp(px, 7)][BNWorldGenerator.clamp(py, 63)][BNWorldGenerator.clamp(pz, 7)];
    }

    private static int clamp(int x, int max) {
        return x < 0 ? 0 : (x > max ? max : x);
    }

    public static void populate(WorldGenRegion world, int sx, int sz, Random random) {
        if (random.nextFloat() < structureDensity) {
            popPos.func_181079_c(sx + random.nextInt(16), MHelper.randRange(33, 100, random), sz + random.nextInt(16));
            StructureType type = StructureType.FLOOR;
            boolean isAir = world.func_180495_p((BlockPos)popPos).func_185904_a().func_76222_j();
            boolean airUp = world.func_180495_p(popPos.func_177984_a()).func_185904_a().func_76222_j() && world.func_180495_p(popPos.func_177981_b(3)).func_185904_a().func_76222_j();
            boolean airDown = world.func_180495_p(popPos.func_177977_b()).func_185904_a().func_76222_j() && world.func_180495_p(popPos.func_177979_c(3)).func_185904_a().func_76222_j();
            NetherBiome biome = BNWorldGenerator.getBiomeLocal(popPos.func_177958_n() - sx, popPos.func_177956_o(), popPos.func_177952_p() - sz, random);
            if (!(isAir || airUp || airDown || random.nextInt(8) != 0)) {
                type = StructureType.UNDER;
            } else if (popPos.func_177956_o() < 45 || !biome.hasCeilStructures() || random.nextBoolean()) {
                if (!isAir) {
                    while (!world.func_180495_p((BlockPos)popPos).func_185904_a().func_76222_j() && popPos.func_177956_o() > 1) {
                        popPos.func_185336_p(popPos.func_177956_o() - 1);
                    }
                }
                while (world.func_180495_p(popPos.func_177977_b()).func_185904_a().func_76222_j() && popPos.func_177956_o() > 1) {
                    popPos.func_185336_p(popPos.func_177956_o() - 1);
                }
            } else {
                if (!isAir) {
                    while (!world.func_180495_p((BlockPos)popPos).func_185904_a().func_76222_j() && popPos.func_177956_o() > 1) {
                        popPos.func_185336_p(popPos.func_177956_o() + 1);
                    }
                }
                while (!BlocksHelper.isNetherGroundMagma(world.func_180495_p(popPos.func_177984_a())) && popPos.func_177956_o() < 127) {
                    popPos.func_185336_p(popPos.func_177956_o() + 1);
                }
                type = StructureType.CEIL;
            }
            biome = BNWorldGenerator.getBiomeLocal(popPos.func_177958_n() - sx, popPos.func_177956_o(), popPos.func_177952_p() - sz, random);
            if (world.func_180495_p((BlockPos)popPos).func_185904_a().func_76222_j()) {
                BlockState up;
                if (type == StructureType.FLOOR) {
                    BlockState down = world.func_180495_p(popPos.func_177977_b());
                    if (BlocksHelper.isNetherGroundMagma(down)) {
                        biome.genFloorBuildings((IServerWorld)world, (BlockPos)popPos, random);
                    }
                } else if (type == StructureType.CEIL && BlocksHelper.isNetherGroundMagma(up = world.func_180495_p(popPos.func_177984_a()))) {
                    biome.genCeilBuildings((IServerWorld)world, (BlockPos)popPos, random);
                }
            } else {
                biome.genUnderBuildings((IServerWorld)world, (BlockPos)popPos, random);
            }
        }
        if (random.nextFloat() < lavaStructureDensity) {
            popPos.func_181079_c(sx + random.nextInt(16), 32, sz + random.nextInt(16));
            if (world.func_175623_d((BlockPos)popPos) && BlocksHelper.isLava(world.func_180495_p(popPos.func_177977_b()))) {
                biome = BNWorldGenerator.getBiomeLocal(popPos.func_177958_n() - sx, popPos.func_177956_o(), popPos.func_177952_p() - sz, random);
                biome.genLavaBuildings((IServerWorld)world, (BlockPos)popPos, random);
            }
        }
        LIST_LAVA.clear();
        LIST_FLOOR.clear();
        LIST_WALL.clear();
        LIST_CEIL.clear();
        int ex = sx + 16;
        int ez = sz + 16;
        for (int x = 0; x < 16; ++x) {
            int wx = sx + x;
            for (int z = 0; z < 16; ++z) {
                int wz = sz + z;
                for (int y = 1; y < 126; ++y) {
                    if (caves.isInCave(x, y, z)) continue;
                    biome = BNWorldGenerator.getBiomeLocal(x, y, z, random);
                    popPos.func_181079_c(wx, y, wz);
                    BlockState state = world.func_180495_p((BlockPos)popPos);
                    boolean lava = BlocksHelper.isLava(state);
                    if (!lava && !BlocksHelper.isNetherGroundMagma(state) && state.func_177230_c() != Blocks.field_150351_n) continue;
                    if (!(lava || !(state = world.func_180495_p(popPos.func_177984_a())).func_196958_f() && state.func_185904_a().func_76218_k() && state.func_185904_a().func_76230_c() || !state.func_204520_s().func_206888_e())) {
                        biome.genSurfColumn((IWorld)world, (BlockPos)popPos, random);
                    }
                    if ((x + y + z & 1) == 0 && random.nextFloat() < globalDensity && random.nextFloat() < biome.getPlantDensity()) {
                        if (world.func_175623_d(popPos.func_177984_a())) {
                            if (lava) {
                                LIST_LAVA.add(popPos.func_177984_a());
                            } else {
                                LIST_FLOOR.add(new BlockPos((Vector3i)popPos.func_177984_a()));
                            }
                        } else if (world.func_175623_d(popPos.func_177977_b())) {
                            LIST_CEIL.add(new BlockPos((Vector3i)popPos.func_177977_b()));
                        } else {
                            boolean bNorth = world.func_175623_d(popPos.func_177978_c());
                            boolean bSouth = world.func_175623_d(popPos.func_177968_d());
                            boolean bEast = world.func_175623_d(popPos.func_177974_f());
                            boolean bWest = world.func_175623_d(popPos.func_177976_e());
                            if (bNorth || bSouth || bEast || bWest) {
                                BlockPos objPos = null;
                                objPos = bNorth ? popPos.func_177978_c() : (bSouth ? popPos.func_177968_d() : (bEast ? popPos.func_177974_f() : popPos.func_177976_e()));
                                if (popPos.func_177958_n() >= sx && popPos.func_177958_n() < ex && popPos.func_177952_p() >= sz && popPos.func_177952_p() < ez) {
                                    boolean bDown = world.func_175623_d(objPos.func_177977_b());
                                    boolean bUp = world.func_175623_d(objPos.func_177984_a());
                                    if (bDown && bUp) {
                                        LIST_WALL.add(new BlockPos((Vector3i)objPos));
                                    }
                                }
                            }
                        }
                    }
                    if (random.nextFloat() < cincinnasiteDensity) {
                        BNWorldGenerator.spawnOre(BlocksRegistry.CINCINNASITE_ORE.func_176223_P(), (IWorld)world, (BlockPos)popPos, random, 6, 14);
                    }
                    if (random.nextFloat() < rubyDensity) {
                        BNWorldGenerator.spawnOre(BlocksRegistry.NETHER_RUBY_ORE.func_176223_P(), (IWorld)world, (BlockPos)popPos, random, 1, 5);
                    }
                    if (!(random.nextFloat() < lapisDensity)) continue;
                    BNWorldGenerator.spawnOre(BlocksRegistry.NETHER_LAPIS_ORE.func_176223_P(), (IWorld)world, (BlockPos)popPos, random, 1, 6);
                }
            }
        }
        for (BlockPos pos : LIST_LAVA) {
            if (!world.func_175623_d(pos) || (biome = BNWorldGenerator.getBiomeLocal(pos.func_177958_n() - sx, pos.func_177956_o(), pos.func_177952_p() - sz, random)) == null) continue;
            biome.genLavaObjects((IServerWorld)world, pos, random);
        }
        for (BlockPos pos : LIST_FLOOR) {
            if (!world.func_175623_d(pos) || (biome = BNWorldGenerator.getBiomeLocal(pos.func_177958_n() - sx, pos.func_177956_o(), pos.func_177952_p() - sz, random)) == null) continue;
            biome.genFloorObjects((IServerWorld)world, pos, random);
        }
        for (BlockPos pos : LIST_WALL) {
            if (!world.func_175623_d(pos) || (biome = BNWorldGenerator.getBiomeLocal(pos.func_177958_n() - sx, pos.func_177956_o(), pos.func_177952_p() - sz, random)) == null) continue;
            biome.genWallObjects((IServerWorld)world, pos, random);
        }
        for (BlockPos pos : LIST_CEIL) {
            if (!world.func_175623_d(pos) || (biome = BNWorldGenerator.getBiomeLocal(pos.func_177958_n() - sx, pos.func_177956_o(), pos.func_177952_p() - sz, random)) == null) continue;
            biome.genCeilObjects((IServerWorld)world, pos, random);
        }
    }

    private static void makeLocalBiomes(WorldGenRegion world, int sx, int sz) {
        MC_BIOMES.clear();
        for (int x = 0; x < 8; ++x) {
            popPos.func_223471_o(sx + (x << 1) + 2);
            for (int y = 0; y < 64; ++y) {
                popPos.func_185336_p((y << 1) + 2);
                for (int z = 0; z < 8; ++z) {
                    popPos.func_223472_q(sz + (z << 1) + 2);
                    Biome b = world.func_226691_t_((BlockPos)popPos);
                    BNWorldGenerator.BIOMES[x][y][z] = NetherBiomesRegistry.getFromBiome(b);
                    MC_BIOMES.add(b);
                }
            }
        }
    }

    public static void prePopulate(WorldGenRegion world, int sx, int sz, Random random) {
        BNWorldGenerator.makeLocalBiomes(world, sx, sz);
        if (hasCaves) {
            popPos.func_181079_c(sx, 0, sz);
            caves.generate((IServerWorld)world, (BlockPos)popPos, random);
        }
        if (hasCleaningPass) {
            BlockPos up;
            ArrayList<BlockPos> pos = new ArrayList<BlockPos>();
            for (int y = 32; y < 110; ++y) {
                popPos.func_185336_p(y);
                for (int x = 0; x < 16; ++x) {
                    popPos.func_223471_o(x | sx);
                    for (int z = 0; z < 16; ++z) {
                        popPos.func_223472_q(z | sz);
                        if (!BNWorldGenerator.canReplace((IWorld)world, (BlockPos)popPos)) continue;
                        up = popPos.func_177984_a();
                        BlockPos down = popPos.func_177977_b();
                        BlockPos north = popPos.func_177978_c();
                        BlockPos south = popPos.func_177968_d();
                        BlockPos east = popPos.func_177974_f();
                        BlockPos west = popPos.func_177976_e();
                        if (world.func_175623_d(north) && world.func_175623_d(south)) {
                            pos.add(new BlockPos((Vector3i)popPos));
                            continue;
                        }
                        if (world.func_175623_d(east) && world.func_175623_d(west)) {
                            pos.add(new BlockPos((Vector3i)popPos));
                            continue;
                        }
                        if (world.func_175623_d(up) && world.func_175623_d(down)) {
                            pos.add(new BlockPos((Vector3i)popPos));
                            continue;
                        }
                        if (world.func_175623_d(popPos.func_177978_c().func_177974_f().func_177977_b()) && world.func_175623_d(popPos.func_177968_d().func_177976_e().func_177984_a())) {
                            pos.add(new BlockPos((Vector3i)popPos));
                            continue;
                        }
                        if (world.func_175623_d(popPos.func_177968_d().func_177974_f().func_177977_b()) && world.func_175623_d(popPos.func_177978_c().func_177976_e().func_177984_a())) {
                            pos.add(new BlockPos((Vector3i)popPos));
                            continue;
                        }
                        if (world.func_175623_d(popPos.func_177978_c().func_177976_e().func_177977_b()) && world.func_175623_d(popPos.func_177968_d().func_177974_f().func_177984_a())) {
                            pos.add(new BlockPos((Vector3i)popPos));
                            continue;
                        }
                        if (!world.func_175623_d(popPos.func_177968_d().func_177976_e().func_177977_b()) || !world.func_175623_d(popPos.func_177978_c().func_177974_f().func_177984_a())) continue;
                        pos.add(new BlockPos((Vector3i)popPos));
                    }
                }
            }
            for (BlockPos p : pos) {
                BlocksHelper.setWithoutUpdate((IWorld)world, p, AIR);
                up = p.func_177984_a();
                BlockState state = world.func_180495_p(up);
                if (state.func_177230_c().func_196260_a(state, (IWorldReader)world, up)) continue;
                BlocksHelper.setWithoutUpdate((IWorld)world, up, AIR);
            }
        }
        if (hasPaths) {
            popPos.func_181079_c(sx, 0, sz);
            paths.generate((IServerWorld)world, (BlockPos)popPos, random);
        }
    }

    private static boolean canReplace(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return BlocksHelper.isNetherGround(state) || state.func_177230_c() == Blocks.field_150351_n;
    }

    private static void spawnOre(BlockState state, IWorld world, BlockPos pos, Random random, int minSize, int maxSize) {
        int size = MHelper.randRange(minSize, maxSize, random);
        for (int i = 0; i < size; ++i) {
            BlockPos local = pos.func_177982_a(random.nextInt(3), random.nextInt(3), random.nextInt(3));
            if (!BlocksHelper.isNetherrack(world.func_180495_p(local))) continue;
            BlocksHelper.setWithoutUpdate(world, local, state);
        }
    }

    public static void cleaningPass(IWorld world, int sx, int sz) {
        if (hasFixPass) {
            BNWorldGenerator.fixBlocks(world, sx, 30, sz, sx + 15, 110, sz + 15);
        }
    }

    private static void fixBlocks(IWorld world, int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int y = y1; y <= y2; ++y) {
            popPos.func_185336_p(y);
            for (int x = x1; x <= x2; ++x) {
                popPos.func_223471_o(x);
                for (int z = z1; z <= z2; ++z) {
                    popPos.func_223472_q(z);
                    BlockState state = world.func_180495_p((BlockPos)popPos);
                    if (!state.func_196955_c((IWorldReader)world, (BlockPos)popPos)) {
                        BlocksHelper.setWithoutUpdate(world, (BlockPos)popPos, AIR);
                        continue;
                    }
                    if (!state.func_200132_m() && world.func_180495_p(popPos.func_177984_a()).func_177230_c() == Blocks.field_196653_dH) {
                        BlocksHelper.setWithoutUpdate(world, (BlockPos)popPos, Blocks.field_196653_dH.func_176223_P());
                        continue;
                    }
                    if (BlocksHelper.isLava(state) && world.func_175623_d(popPos.func_177984_a()) && world.func_175623_d(popPos.func_177977_b())) {
                        BlocksHelper.setWithoutUpdate(world, (BlockPos)popPos, AIR);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_189878_dg || state.func_177230_c() == Blocks.field_235374_mn_) {
                        if (!world.func_175623_d(popPos.func_177977_b()) || !world.func_175623_d(popPos.func_177984_a()) || !world.func_175623_d(popPos.func_177978_c()) || !world.func_175623_d(popPos.func_177968_d()) || !world.func_175623_d(popPos.func_177974_f()) || !world.func_175623_d(popPos.func_177976_e())) continue;
                        BlocksHelper.setWithoutUpdate(world, (BlockPos)popPos, AIR);
                        continue;
                    }
                    if (!(state.func_177230_c() instanceof BlockStalactite) || (state = world.func_180495_p(popPos.func_177977_b())).func_235785_r_((IBlockReader)world, popPos.func_177977_b()) || state.func_177230_c() instanceof BlockStalactite) continue;
                    BlockPos.Mutable sp = new BlockPos.Mutable().func_189533_g((Vector3i)popPos);
                    while (world.func_180495_p((BlockPos)sp).func_177230_c() instanceof BlockStalactite) {
                        BlocksHelper.setWithoutUpdate(world, (BlockPos)sp, AIR);
                        sp.func_177972_a(Direction.UP);
                    }
                }
            }
        }
    }

    public static HashSet<Biome> getPopulateBiomes() {
        return MC_BIOMES;
    }

    static {
        AIR = Blocks.field_150350_a.func_176223_P();
        popPos = new BlockPos.Mutable();
        BIOMES = new NetherBiome[8][64][8];
        LIST_FLOOR = new ArrayList<BlockPos>(4096);
        LIST_WALL = new ArrayList<BlockPos>(4096);
        LIST_CEIL = new ArrayList<BlockPos>(4096);
        LIST_LAVA = new ArrayList<BlockPos>(1024);
        MC_BIOMES = new HashSet();
        CITY = new CityFeature();
        CITY_CONFIGURED = CITY.func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_);
        distance = Configs.GENERATOR.getInt("generator.world.cities", "distance", 64);
        separation = distance >> 1;
    }
}

