/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.world.structures.city;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import someoneelse.betternetherreforged.blocks.BNPlanks;
import someoneelse.betternetherreforged.blocks.BlockBNPot;
import someoneelse.betternetherreforged.blocks.BlockPottedPlant;
import someoneelse.betternetherreforged.blocks.BlockSmallLantern;
import someoneelse.betternetherreforged.world.structures.city.palette.CityPalette;

public class BuildingStructureProcessor
extends StructureProcessor {
    protected final CityPalette palette;

    public BuildingStructureProcessor(CityPalette palette) {
        this.palette = palette;
    }

    private Template.BlockInfo setState(BlockState state, Template.BlockInfo info) {
        return new Template.BlockInfo(info.field_186242_a, state, info.field_186244_c);
    }

    public Template.BlockInfo process(IWorldReader worldView, BlockPos pos, BlockPos blockPos, Template.BlockInfo structureBlockInfo, Template.BlockInfo structureBlockInfo2, PlacementSettings structurePlacementData, Template template) {
        BlockState state = structureBlockInfo.field_186243_b;
        if (state.func_196958_f()) {
            return structureBlockInfo2;
        }
        Block block = state.func_177230_c();
        String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).func_110623_a();
        if (name.startsWith("roof_tile")) {
            if (block instanceof StairsBlock) {
                return this.setState(this.palette.getRoofStair(state), structureBlockInfo2);
            }
            if (block instanceof SlabBlock) {
                return this.setState(this.palette.getRoofSlab(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getRoofBlock(state), structureBlockInfo2);
        }
        if (name.contains("nether") && name.contains("brick")) {
            if (block instanceof StairsBlock) {
                return this.setState(this.palette.getFoundationStair(state), structureBlockInfo2);
            }
            if (block instanceof SlabBlock) {
                return this.setState(this.palette.getFoundationSlab(state), structureBlockInfo2);
            }
            if (block instanceof WallBlock) {
                return this.setState(this.palette.getFoundationWall(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getFoundationBlock(state), structureBlockInfo2);
        }
        if (name.contains("plank") || name.contains("reed") || block instanceof BNPlanks) {
            if (block instanceof StairsBlock) {
                return this.setState(this.palette.getPlanksStair(state), structureBlockInfo2);
            }
            if (block instanceof SlabBlock) {
                return this.setState(this.palette.getPlanksSlab(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getPlanksBlock(state), structureBlockInfo2);
        }
        if (name.contains("glass") || name.contains("frame")) {
            if (block instanceof PaneBlock) {
                return this.setState(this.palette.getGlassPane(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getGlassBlock(state), structureBlockInfo2);
        }
        if (block instanceof RotatedPillarBlock) {
            if (name.contains("log")) {
                return this.setState(this.palette.getLog(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getBark(state), structureBlockInfo2);
        }
        if (block instanceof StairsBlock) {
            return this.setState(this.palette.getStoneStair(state), structureBlockInfo2);
        }
        if (block instanceof SlabBlock) {
            return this.setState(this.palette.getStoneSlab(state), structureBlockInfo2);
        }
        if (block instanceof WallBlock) {
            return this.setState(this.palette.getWall(state), structureBlockInfo2);
        }
        if (block instanceof FenceBlock) {
            return this.setState(this.palette.getFence(state), structureBlockInfo2);
        }
        if (block instanceof FenceGateBlock) {
            return this.setState(this.palette.getGate(state), structureBlockInfo2);
        }
        if (block instanceof DoorBlock) {
            return this.setState(this.palette.getDoor(state), structureBlockInfo2);
        }
        if (block instanceof TrapDoorBlock) {
            return this.setState(this.palette.getTrapdoor(state), structureBlockInfo2);
        }
        if (block instanceof PressurePlateBlock) {
            if (block.func_220072_p(state) == SoundType.field_185848_a) {
                return this.setState(this.palette.getWoodenPlate(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getStonePlate(state), structureBlockInfo2);
        }
        if (block instanceof BlockSmallLantern) {
            if (state.func_177229_b((Property)BlockSmallLantern.FACING) == Direction.UP) {
                return this.setState(this.palette.getCeilingLight(state), structureBlockInfo2);
            }
            if (state.func_177229_b((Property)BlockSmallLantern.FACING) != Direction.DOWN) {
                return this.setState(this.palette.getWallLight(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getFloorLight(state), structureBlockInfo2);
        }
        if (block instanceof BlockBNPot) {
            return this.setState(this.palette.getPot(state), structureBlockInfo2);
        }
        if (block instanceof BlockPottedPlant) {
            return this.setState(this.palette.getPlant(state), structureBlockInfo2);
        }
        if (block instanceof StructureBlock) {
            return this.setState(Blocks.field_150350_a.func_176223_P(), structureBlockInfo2);
        }
        if (!name.contains("nether") && !name.contains("mycelium") && state.func_235785_r_((IBlockReader)worldView, structureBlockInfo.field_186242_a) && state.func_200132_m() && !(state.func_177230_c() instanceof ContainerBlock)) {
            if (state.func_185906_d() > 0) {
                return this.setState(this.palette.getGlowingBlock(state), structureBlockInfo2);
            }
            return this.setState(this.palette.getStoneBlock(state), structureBlockInfo2);
        }
        return structureBlockInfo2;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return IStructureProcessorType.field_214925_g;
    }
}

