/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.world.structures.city;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import someoneelse.betternetherreforged.structures.StructureNBT;
import someoneelse.betternetherreforged.world.structures.city.BoundingBox;

public class StructureCityBuilding
extends StructureNBT {
    protected static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private BoundingBox bb;
    public BlockPos[] ends;
    private Direction[] dirs;
    private BlockPos rotationOffset;
    private int offsetY;

    public StructureCityBuilding(String structure) {
        super(structure);
        this.offsetY = 0;
        this.init();
    }

    public StructureCityBuilding(String structure, int offsetY) {
        super(structure);
        this.offsetY = offsetY;
        this.init();
    }

    protected StructureCityBuilding(ResourceLocation location, Template structure) {
        super(location, structure);
        this.init();
    }

    private void init() {
        BlockPos size = this.structure.func_186259_a();
        this.bb = new BoundingBox(size);
        List map = this.structure.func_215386_a(BlockPos.field_177992_a, new PlacementSettings(), Blocks.field_185779_df, false);
        this.ends = new BlockPos[map.size()];
        this.dirs = new Direction[map.size()];
        int i = 0;
        BlockPos center = new BlockPos(size.func_177958_n() >> 1, size.func_177956_o(), size.func_177952_p() >> 1);
        for (Template.BlockInfo info : map) {
            this.ends[i] = info.field_186242_a;
            this.dirs[i++] = this.getDir(info.field_186242_a.func_177982_a(-center.func_177958_n(), 0, -center.func_177952_p()));
        }
        this.rotationOffset = new BlockPos(0, 0, 0);
        this.rotation = Rotation.NONE;
    }

    private Direction getDir(BlockPos pos) {
        int az;
        int ax = Math.abs(pos.func_177958_n());
        int mx = Math.max(ax, az = Math.abs(pos.func_177952_p()));
        if (mx == ax) {
            if (pos.func_177958_n() > 0) {
                return Direction.EAST;
            }
            return Direction.WEST;
        }
        if (pos.func_177952_p() > 0) {
            return Direction.SOUTH;
        }
        return Direction.NORTH;
    }

    public BoundingBox getBoungingBox() {
        return this.bb;
    }

    protected Rotation mirrorRotation(Rotation r) {
        switch (r) {
            case CLOCKWISE_90: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return r;
    }

    public void placeInChunk(IServerWorld world, BlockPos pos, MutableBoundingBox boundingBox, StructureProcessor paletteProcessor) {
        BlockPos p = pos.func_177971_a((Vector3i)this.rotationOffset);
        this.structure.func_237144_a_(world, p, new PlacementSettings().func_186220_a(this.rotation).func_186214_a(this.mirror).func_186223_a(boundingBox).func_215222_a(paletteProcessor), world.func_201674_k());
    }

    public BlockPos[] getEnds() {
        return this.ends;
    }

    public int getEndsCount() {
        return this.ends.length;
    }

    public BlockPos getOffsettedPos(int index) {
        return this.ends[index].func_177972_a(this.dirs[index]);
    }

    public BlockPos getPos(int index) {
        return this.ends[index];
    }

    public StructureCityBuilding getRotated(Rotation rotation) {
        StructureCityBuilding building = this.clone();
        building.rotation = rotation;
        building.rotationOffset = building.structure.func_186259_a().func_190942_a(rotation);
        int x = building.rotationOffset.func_177958_n();
        int z = building.rotationOffset.func_177952_p();
        x = x < 0 ? -x - 1 : 0;
        z = z < 0 ? -z - 1 : 0;
        building.rotationOffset = new BlockPos(x, 0, z);
        for (int i = 0; i < building.dirs.length; ++i) {
            building.dirs[i] = this.rotated(building.dirs[i], rotation);
            building.ends[i] = building.ends[i].func_190942_a(rotation).func_177971_a((Vector3i)building.rotationOffset);
        }
        building.bb.rotate(rotation);
        building.offsetY = this.offsetY;
        return building;
    }

    public StructureCityBuilding getRandomRotated(Random random) {
        return this.getRotated(Rotation.values()[random.nextInt(4)]);
    }

    public StructureCityBuilding clone() {
        return new StructureCityBuilding(this.location, this.structure);
    }

    private Direction rotated(Direction dir, Rotation rotation) {
        Direction f;
        switch (rotation) {
            case CLOCKWISE_90: {
                f = dir.func_176746_e();
                break;
            }
            case CLOCKWISE_180: {
                f = dir.func_176734_d();
                break;
            }
            case COUNTERCLOCKWISE_90: {
                f = dir.func_176735_f();
                break;
            }
            default: {
                f = dir;
            }
        }
        return f;
    }

    public int getYOffset() {
        return this.offsetY;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    @Override
    public MutableBoundingBox getBoundingBox(BlockPos pos) {
        return this.structure.func_215388_b(new PlacementSettings().func_186220_a(this.rotation).func_186214_a(this.mirror), pos.func_177971_a((Vector3i)this.rotationOffset));
    }

    @Override
    public StructureCityBuilding setRotation(Rotation rotation) {
        this.rotation = rotation;
        this.rotationOffset = this.structure.func_186259_a().func_190942_a(rotation);
        return this;
    }
}

