/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.world.structures.piece;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import someoneelse.betternetherreforged.noise.OpenSimplexNoise;
import someoneelse.betternetherreforged.world.structures.piece.CustomPiece;
import someoneelse.betternetherreforged.world.structures.piece.StructureTypes;

public class CavePiece
extends CustomPiece {
    private static final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(927649L);
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    private BlockPos center;
    private int radius;
    private int radSqr;
    private int minY;
    private int maxY;

    public CavePiece(BlockPos center, int radius, Random random) {
        super(StructureTypes.CAVE, random.nextInt());
        this.center = center.func_185334_h();
        this.radius = radius;
        this.radSqr = radius * radius;
        this.makeBoundingBox();
    }

    protected CavePiece(TemplateManager manager, CompoundNBT tag) {
        super(StructureTypes.CAVE, tag);
        this.center = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("center"));
        this.radius = tag.func_74762_e("radius");
        this.radSqr = this.radius * this.radius;
        this.makeBoundingBox();
    }

    protected void func_143011_b(CompoundNBT tag) {
        tag.func_218657_a("center", (INBT)NBTUtil.func_186859_a((BlockPos)this.center));
        tag.func_74768_a("radius", this.radius);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager arg, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        BlockState bottom = LAVA;
        if (!world.func_230315_m_().func_236037_d_()) {
            bottom = Blocks.field_150424_aL.func_176223_P();
        }
        for (int x = blockBox.field_78897_a; x <= blockBox.field_78893_d; ++x) {
            int px = x - this.center.func_177958_n();
            px *= px;
            for (int z = blockBox.field_78896_c; z <= blockBox.field_78892_f; ++z) {
                int pz = z - this.center.func_177952_p();
                pz *= pz;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    int py = y - this.center.func_177956_o() << 1;
                    if (!((double)(px + (py *= py) + pz) <= (double)this.radSqr + NOISE.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * 800.0)) continue;
                    POS.func_181079_c(x, y, z);
                    if (y > 31) {
                        world.func_180501_a((BlockPos)POS, field_202556_l, 0);
                        continue;
                    }
                    world.func_180501_a((BlockPos)POS, bottom, 0);
                }
            }
        }
        return true;
    }

    private void makeBoundingBox() {
        int x1 = this.center.func_177958_n() - this.radius;
        int x2 = this.center.func_177958_n() + this.radius;
        this.minY = Math.max(22, this.center.func_177956_o() - this.radius);
        this.maxY = Math.min(96, this.center.func_177956_o() + this.radius);
        int z1 = this.center.func_177952_p() - this.radius;
        int z2 = this.center.func_177952_p() + this.radius;
        this.field_74887_e = new MutableBoundingBox(x1, this.minY, z1, x2, this.maxY, z2);
    }
}

