/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies;

import com.google.common.collect.ImmutableMap;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.BlueSkiesProxy;
import com.legacy.blue_skies.MLSupporter;
import com.legacy.blue_skies.assets.BlueSkiesAssets;
import com.legacy.blue_skies.blocks.util.Composting;
import com.legacy.blue_skies.blocks.util.DispenserBehaviors;
import com.legacy.blue_skies.blocks.util.Flammability;
import com.legacy.blue_skies.blocks.util.ToolCompat;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.capability.util.CapabilityStorage;
import com.legacy.blue_skies.capability.util.ISkiesPlayer;
import com.legacy.blue_skies.client.audio.SkiesMusicHandler;
import com.legacy.blue_skies.client.events.SkiesClientEvents;
import com.legacy.blue_skies.client.gui.screen.AlchemyTableScreen;
import com.legacy.blue_skies.client.gui.screen.ArcsScreen;
import com.legacy.blue_skies.client.gui.screen.BagOfSpoilsScreen;
import com.legacy.blue_skies.client.gui.screen.FoodPrepScreen;
import com.legacy.blue_skies.client.gui.screen.HorizoniteForgeScreen;
import com.legacy.blue_skies.client.gui.screen.MountInventoryScreen;
import com.legacy.blue_skies.client.gui.screen.SnowcapOvenScreen;
import com.legacy.blue_skies.client.gui.screen.SummoningTableScreen;
import com.legacy.blue_skies.client.gui.screen.ToolboxScreen;
import com.legacy.blue_skies.client.init.SkiesAtlases;
import com.legacy.blue_skies.client.init.SkyBlockColoring;
import com.legacy.blue_skies.client.init.SkyBlockLayers;
import com.legacy.blue_skies.client.init.SkyItemColoring;
import com.legacy.blue_skies.client.init.SkyItemModelPredicates;
import com.legacy.blue_skies.client.renders.SkiesEntityRendering;
import com.legacy.blue_skies.client.renders.SkiesTileEntityRendering;
import com.legacy.blue_skies.client.resource_pack.SkyResourcePackHandler;
import com.legacy.blue_skies.commands.BlueSkiesCommand;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.BlueSkiesDataGen;
import com.legacy.blue_skies.data.objects.SkiesBlockTags;
import com.legacy.blue_skies.data.objects.SkiesEntityTags;
import com.legacy.blue_skies.data.objects.SkiesItemTags;
import com.legacy.blue_skies.events.SkiesEvents;
import com.legacy.blue_skies.events.SkiesMappingChanges;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.blue_skies.items.util.FoodPrepUtils;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.registries.SkiesContainers;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesRegistry;
import com.legacy.blue_skies.registries.SkiesStats;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.registries.SkiesTriggers;
import com.legacy.blue_skies.world.SkiesNoiseChunkGenerator;
import com.legacy.structure_gel.access_helpers.BiomeAccessHelper;
import com.legacy.structure_gel.access_helpers.JigsawAccessHelper;
import com.legacy.structure_gel.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.events.RegisterDimensionEvent;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Calendar;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="blue_skies")
public class BlueSkies {
    public static final String MODID = "blue_skies";
    public static final Logger LOGGER = LogManager.getLogger((String)"ModdingLegacy/blue_skies");
    public static final MLSupporter.Supporters SUPPORTERS = new MLSupporter.Supporters();
    public static BlueSkiesProxy proxy = new BlueSkiesProxy.Common();
    public static boolean IS_CHRISTMAS = Calendar.getInstance().get(2) + 1 == 12 && Calendar.getInstance().get(5) >= 24 && Calendar.getInstance().get(5) <= 26;
    public static boolean IS_HALLOWEEN = Calendar.getInstance().get(2) + 1 == 10 && Calendar.getInstance().get(5) >= 30 && Calendar.getInstance().get(5) <= 31;
    private static final boolean INDEV = false;
    public static final boolean IDE = BlueSkies.isRunningFromIDE();

    public BlueSkies() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, BlueSkiesConfig.COMMON_SPEC);
        IEventBus mod = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forge = MinecraftForge.EVENT_BUS;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            proxy = new BlueSkiesProxy.Client();
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, BlueSkiesConfig.CLIENT_SPEC);
            SkyResourcePackHandler.init();
            BlueSkiesAssets.init();
            mod.addListener(BlueSkies::clientInit);
            mod.addListener(SkiesClientEvents::onModelBake);
            forge.register(SkiesMusicHandler.class);
            forge.register(SkiesClientEvents.class);
        });
        SkiesBlockTags.init();
        SkiesItemTags.init();
        SkiesEntityTags.init();
        mod.addListener(BlueSkies::commonInit);
        mod.addListener(SkiesEntityTypes::onAttributesRegistered);
        mod.register(SkiesRegistry.class);
        mod.register(BlueSkiesDataGen.class);
        forge.addListener(BlueSkies::onCommandsRegistered);
        forge.addListener(BlueSkies::onRegisterDimensions);
        forge.addListener(EventPriority.LOWEST, BlueSkies::onBiomesLoaded);
        forge.addListener(BlueSkiesData::addListeners);
        forge.register(SkiesEvents.class);
        forge.register(SkiesPlayerEvents.class);
        forge.register(SkiesMappingChanges.class);
    }

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }

    public static String find(String key) {
        return "blue_skies:" + key;
    }

    public static void commonInit(FMLCommonSetupEvent event) {
        if (BlueSkies.isRunningFromIDE()) {
            LOGGER.warn("Blue Skies is being run from an IDE or via Gradle.");
            LOGGER.warn("If you are planning to make a contribution to Blue Skies, please refer to the LICENSE.md file at the root directory of this repository.");
        } else if (BlueSkies.isIndevBuild()) {
            LOGGER.warn("This is an indev build of Blue Skies. Do NOT expect support with it! Things WILL break. Treat it like a Minecraft snapshot version!");
        }
        PacketHandler.register();
        CapabilityManager.INSTANCE.register(ISkiesPlayer.class, new CapabilityStorage(), SkiesPlayer::new);
        JigsawAccessHelper.addIllagerStructures((Structure[])new Structure[]{SkiesStructures.GATEKEEPER_HOUSE.getStructure(), SkiesStructures.BLUE_SKIES_VILLAGE.getStructure()});
        Registry.func_218325_a((Registry)Registry.field_239690_aB_, (String)"blue_skies_noise", SkiesNoiseChunkGenerator.CODEC);
        Flammability.init();
        Composting.init();
        ToolCompat.init();
        DispenserBehaviors.init();
        SkiesStats.init();
        SkiesTriggers.init();
        BlueSkiesData.addSyncedListeners();
        new MLSupporter.GetSupportersThread().start();
    }

    public static void clientInit(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(SkiesContainers.ARC_INVENTORY, ArcsScreen::new);
        ScreenManager.func_216911_a(SkiesContainers.MOUNT_INVENTORY, MountInventoryScreen::new);
        ScreenManager.func_216911_a(SkiesContainers.HORIZONITE_FORGE, HorizoniteForgeScreen::new);
        ScreenManager.func_216911_a(SkiesContainers.SNOWCAP_OVEN, SnowcapOvenScreen::new);
        ScreenManager.func_216911_a(SkiesContainers.SUMMONING_TABLE, SummoningTableScreen::new);
        ScreenManager.func_216911_a(SkiesContainers.ALCHEMY_TABLE, AlchemyTableScreen::new);
        ScreenManager.func_216911_a(SkiesContainers.TOOLBOX, ToolboxScreen::new);
        ScreenManager.func_216911_a(SkiesContainers.FOOD_PREP_TABLE, FoodPrepScreen::new);
        ScreenManager.func_216911_a(SkiesContainers.BAG_OF_SPOILS, BagOfSpoilsScreen::new);
        SkiesEntityRendering.init();
        SkiesTileEntityRendering.init();
        SkyBlockColoring.init();
        SkyItemColoring.init();
        SkyBlockLayers.init();
        SkyItemModelPredicates.init();
        SkiesClientEvents.Panoramas.registerPanoramas();
        SkiesClientEvents.initDimensionRenderInfo();
        SkiesAtlases.init();
        FoodPrepUtils.FoodColor.setupColors();
    }

    public static void onCommandsRegistered(RegisterCommandsEvent event) {
        BlueSkiesCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public static void onRegisterDimensions(RegisterDimensionEvent event) {
        SkiesDimensions.init(event);
    }

    public static void onBiomesLoaded(BiomeLoadingEvent event) {
        ImmutableMap.of((Object)BiomeDictionary.PLAINS, (Object)"plains", (Object)BiomeDictionary.SNOWY, (Object)"snowy", (Object)BiomeDictionary.SNOWY_SPRUCE_FOREST, (Object)"snowy", (Object)BiomeDictionary.MOUNTAIN, (Object)"mountain").forEach((type, name) -> {
            if (type.getBiomes().contains(event.getName())) {
                BiomeAccessHelper.addStructure((BiomeLoadingEvent)event, (StructureFeature)SkiesStructures.GATEKEEPER_HOUSE.getStructureFeature(name));
            }
        });
        if (event.getName() != null && event.getName().func_110624_b().startsWith(MODID)) {
            for (EntityClassification entityClass : EntityClassification.values()) {
                event.getSpawns().getSpawner(entityClass).removeIf(spawn -> {
                    ResourceLocation registryName = spawn.field_242588_c.getRegistryName();
                    boolean shouldKeep = registryName != null && (registryName.func_110624_b().equals(MODID) || spawn.field_242588_c == EntityType.field_203780_j || spawn.field_242588_c == EntityType.field_203778_ae);
                    return !shouldKeep;
                });
            }
        }
    }

    private static boolean isRunningFromIDE() {
        String p = System.getProperty(String.format("%s.iside", MODID));
        return Boolean.parseBoolean(p);
    }

    public static Logger makeLogger(Class<?> containerClass) {
        return LogManager.getLogger((String)("ModdingLegacy/blue_skies/" + containerClass.getSimpleName()));
    }

    public static boolean isIndevBuild() {
        return IDE;
    }
}

