/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies;

import com.legacy.blue_skies.BlueSkies;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;

public class MLSupporter {
    public final String name;
    public final UUID uuid;
    public final int rank;

    public MLSupporter(String name, String uuid, int rank) {
        this.name = name;
        this.uuid = UUID.fromString(uuid);
        this.rank = rank;
    }

    public String toString() {
        return String.format("name=%s, UUID=%s", this.name, this.uuid.toString());
    }

    public static class GetSupportersThread
    extends Thread {
        public GetSupportersThread() {
            super("Blue Skies supporters thread.");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                String line;
                String address = "https://moddinglegacy.com/supporters-changelogs/supporters.txt";
                BlueSkies.LOGGER.info("Attempting to load the Modding Legacy supporters list from " + address);
                ArrayList<String> names = new ArrayList<String>();
                URL url = new URL(address);
                HttpURLConnection httpcon = (HttpURLConnection)url.openConnection();
                httpcon.addRequestProperty("User-Agent", "Mozilla/4.0");
                BufferedReader reader = new BufferedReader(new InputStreamReader(httpcon.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    names.add(line);
                }
                reader.close();
                this.loadSupporters(names.stream().filter(s -> !s.isEmpty() && !s.startsWith("#")).map(s -> {
                    String[] values = s.split(",");
                    return new MLSupporter(values[0], values[1], Integer.parseInt(values[2]));
                }).collect(Collectors.toList()));
                BlueSkies.LOGGER.info("Successfully loaded the Modding legacy supporters list.");
            }
            catch (IOException e) {
                BlueSkies.LOGGER.info("Couldn't load the Modding Legacy supporters list. You may be offline or our website could be having issues. If you are a supporter, some cosmetic features may not work.");
                e.printStackTrace();
            }
            catch (Exception e) {
                BlueSkies.LOGGER.info("Failed to load the Modding Legacy supporters list. If you are a supporter, some cosmetic features may not work.");
                e.printStackTrace();
            }
        }

        private void loadSupporters(List<MLSupporter> supporters) {
            BlueSkies.SUPPORTERS.getSupporters().clear();
            BlueSkies.SUPPORTERS.getSupporters().addAll(supporters);
        }
    }

    public static class Supporters {
        private final List<MLSupporter> supporters = new ArrayList<MLSupporter>();

        public boolean isRanked(PlayerEntity player) {
            return this.isSupporter(player) || this.isDeveloper(player);
        }

        public boolean isSupporter(PlayerEntity player) {
            return this.supporters.stream().anyMatch(s -> player.func_110124_au().equals(s.uuid) && s.rank == 1);
        }

        public boolean isDeveloper(PlayerEntity player) {
            return this.supporters.stream().anyMatch(s -> player.func_110124_au().equals(s.uuid) && s.rank == 0);
        }

        public List<MLSupporter> getSupporters() {
            return this.supporters;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.supporters.size(); ++i) {
                builder.append(this.supporters.get(i).toString()).append(i < this.supporters.size() - 1 ? ", " : "");
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

