/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.misc;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.WebBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SkyWebbingBlock
extends Block {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty HAS_COLLISION = BooleanProperty.func_177716_a((String)"has_collision");
    public static final VoxelShape X = Block.func_208617_a((double)7.5, (double)0.0, (double)0.0, (double)8.5, (double)16.0, (double)16.0);
    public static final VoxelShape Y = Block.func_208617_a((double)0.0, (double)7.5, (double)0.0, (double)16.0, (double)8.5, (double)16.0);
    public static final VoxelShape Z = Block.func_208617_a((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)8.5);

    public SkyWebbingBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_COLLISION, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        boolean xFlag = false;
        boolean yFlag = false;
        boolean zFlag = false;
        if (this.connectedAtCorner(state, NORTH, UP, SOUTH, DOWN)) {
            xFlag = true;
        }
        if (this.connectedAtCorner(state, NORTH, EAST, SOUTH, WEST)) {
            yFlag = true;
        }
        if (this.connectedAtCorner(state, EAST, UP, WEST, DOWN)) {
            zFlag = true;
        }
        if (xFlag && yFlag && zFlag) {
            return VoxelShapes.func_197868_b();
        }
        VoxelShape shape = VoxelShapes.func_197880_a();
        if (xFlag) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)X);
        }
        if (yFlag) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Y);
        }
        if (zFlag) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Z);
        }
        return shape;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)HAS_COLLISION)).booleanValue()) {
            return this.func_220053_a(state, worldIn, pos, context);
        }
        return VoxelShapes.func_197880_a();
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!((Boolean)state.func_177229_b((Property)HAS_COLLISION)).booleanValue() && state.func_196954_c((IBlockReader)worldIn, pos).func_197752_a().func_186670_a(pos).func_72326_a(entityIn.func_174813_aQ())) {
            entityIn.func_213295_a(state, new Vector3d(0.75, 0.55, 0.75));
        }
    }

    public boolean connectedAtCorner(BlockState state, BooleanProperty a, BooleanProperty b, BooleanProperty c, BooleanProperty d) {
        return (Boolean)state.func_177229_b((Property)a) != false && (Boolean)state.func_177229_b((Property)b) != false || (Boolean)state.func_177229_b((Property)b) != false && (Boolean)state.func_177229_b((Property)c) != false || (Boolean)state.func_177229_b((Property)c) != false && (Boolean)state.func_177229_b((Property)d) != false || (Boolean)state.func_177229_b((Property)d) != false && (Boolean)state.func_177229_b((Property)a) != false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : (BlockState)stateIn.func_206870_a((Property)this.getProperty(facing), (Comparable)Boolean.valueOf(this.canAttachTo(facingState, facingState.func_224755_d((IBlockReader)worldIn, facingPos, facing.func_176734_d()))));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        World world = context.func_195991_k();
        for (Direction facing : Direction.values()) {
            BlockPos facingPos = context.func_195995_a().func_177972_a(facing);
            BlockState facingState = world.func_180495_p(facingPos);
            state = (BlockState)state.func_206870_a((Property)this.getProperty(facing), (Comparable)Boolean.valueOf(this.canAttachTo(facingState, facingState.func_224755_d((IBlockReader)world, facingPos, facing.func_176734_d()))));
        }
        return state;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            BlockPos facingPos = pos.func_177972_a(facing);
            BlockState facingState = worldIn.func_180495_p(facingPos);
            state = (BlockState)state.func_206870_a((Property)this.getProperty(facing), (Comparable)Boolean.valueOf(this.canAttachTo(facingState, facingState.func_224755_d((IBlockReader)worldIn, facingPos, facing.func_176734_d()))));
        }
        return this.connectedAtCorner(state, NORTH, EAST, SOUTH, WEST) || this.connectedAtCorner(state, NORTH, UP, SOUTH, DOWN) || this.connectedAtCorner(state, EAST, UP, WEST, DOWN);
    }

    public final boolean canAttachTo(BlockState attachState, boolean ifSolidSide) {
        Block block = attachState.func_177230_c();
        return !SkyWebbingBlock.func_220073_a((Block)block) && ifSolidSide || block instanceof SkyWebbingBlock || block instanceof WebBlock;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)EAST, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)EAST, state.func_177229_b((Property)NORTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)WEST, state.func_177229_b((Property)SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN, HAS_COLLISION});
    }

    public BooleanProperty getProperty(Direction facing) {
        switch (facing) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
        }
        return DOWN;
    }
}

