/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.capability;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.dungeon.KeystoneBlock;
import com.legacy.blue_skies.capability.ArcInventory;
import com.legacy.blue_skies.capability.util.ISkiesPlayer;
import com.legacy.blue_skies.entities.SupporterPetEntity;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.items.arcs.IArcItem;
import com.legacy.blue_skies.items.tools.weapons.AlchemyScrollItem;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.DisplayToastPacket;
import com.legacy.blue_skies.network.s_to_c.DungeonMusicPacket;
import com.legacy.blue_skies.network.s_to_c.SyncPlayerPacket;
import com.legacy.blue_skies.network.s_to_c.UpdateBlueLorePacket;
import com.legacy.blue_skies.network.s_to_c.UpdateNatureHealthPacket;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesPointsOfInterest;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.NonNullSupplier;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class SkiesPlayer
implements ISkiesPlayer {
    @CapabilityInject(value=ISkiesPlayer.class)
    public static Capability<ISkiesPlayer> INSTANCE = null;
    private static final Marker MARKER = MarkerManager.getMarker((String)"Player Capability");
    private PlayerEntity player;
    private SkiesDungeonType activeBossType;
    private ArcInventory arcInventory;
    public SkiesDungeonType dungeonMusicType;
    private boolean wasInStructure = false;
    private boolean supporterPetEnabled = false;
    private boolean supporterPetAudible = false;
    private boolean usedBlueLore = false;
    private boolean fullDuskInvis = false;
    private byte brightProgression = 0;
    private byte dawnProgression = 0;
    private byte supporterPetId = 0;
    private byte supporterStyleId = 0;
    private float natureHealth;
    private Vector3d preservedMotionVec;
    private LivingEntity supporterPet;
    private String supporterPetName = "";
    private BlockPos prevKeystonePos = null;

    public SkiesPlayer() {
    }

    public SkiesPlayer(PlayerEntity player) {
        this.player = player;
        this.arcInventory = new ArcInventory();
        this.arcInventory.refreshArcs(player);
    }

    @Override
    public Capability<ISkiesPlayer> getDefaultInstance() {
        return INSTANCE;
    }

    @Nullable
    public static ISkiesPlayer get(PlayerEntity player) {
        return SkiesPlayer.getIfPresent(player, skyPlayer -> skyPlayer);
    }

    public static <E extends PlayerEntity> void ifPresent(E player, Consumer<ISkiesPlayer> action) {
        if (player != null && player.getCapability(INSTANCE).resolve().isPresent()) {
            action.accept((ISkiesPlayer)player.getCapability(INSTANCE).resolve().get());
        }
    }

    @Nullable
    public static <E extends PlayerEntity, R> R getIfPresent(E player, Function<ISkiesPlayer, R> action) {
        if (player != null && player.getCapability(INSTANCE).resolve().isPresent()) {
            return action.apply((ISkiesPlayer)player.getCapability(INSTANCE).resolve().get());
        }
        return null;
    }

    public static <E extends PlayerEntity, R> R getIfPresent(E player, Function<ISkiesPlayer, R> action, NonNullSupplier<R> elseSupplier) {
        if (player != null && player.getCapability(INSTANCE).resolve().isPresent()) {
            return action.apply((ISkiesPlayer)player.getCapability(INSTANCE).resolve().get());
        }
        return (R)elseSupplier.get();
    }

    @Override
    public void serverTick() {
        if (this.player != null && this.player instanceof ServerPlayerEntity && !this.player.func_130014_f_().func_201670_d()) {
            this.getArcInventory().getStacks().forEach(stack -> {
                if (stack.func_77973_b() instanceof IArcItem) {
                    ((IArcItem)stack.func_77973_b()).serverTick((ItemStack)stack, (ServerPlayerEntity)this.player);
                }
            });
            this.updateDungeonMusic();
            if (!this.player.func_184812_l_() && !this.player.func_175149_v() && this.player.field_70173_aa % 40 == 0 && (this.getBrightProgression() < 1 && EntityUtil.isPosInStructure(this.player.field_70170_p, this.player.func_233580_cy_(), SkiesStructures.NATURE_DUNGEON.getStructure()) || this.getDawnProgression() < 1 && this.player.func_233580_cy_().func_177956_o() < 63 && EntityUtil.isPosInStructure(this.player.field_70170_p, this.player.func_233580_cy_(), SkiesStructures.POISON_DUNGEON.getStructure()))) {
                this.player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.blue_skies.tooltip.not_progressed"), true);
                this.player.func_195064_c(new EffectInstance(Effects.field_76440_q, 80));
                this.player.func_195064_c(new EffectInstance(Effects.field_76421_d, 80, 1));
                this.player.func_195064_c(new EffectInstance(Effects.field_76436_u, 50, 1));
            }
            if (BlueSkies.SUPPORTERS.isRanked(this.player)) {
                if (this.isSupporterPetEnabled()) {
                    this.checkAndSpawnPet();
                    if (this.getSupporterPet() != null && !this.getSupporterPet().field_70170_p.func_234923_W_().func_240901_a_().equals((Object)this.player.field_70170_p.func_234923_W_().func_240901_a_())) {
                        this.getSupporterPet().func_70106_y();
                        this.setSupporterPet(null);
                    }
                } else if (this.getSupporterPet() != null) {
                    this.getSupporterPet().func_70106_y();
                    this.setSupporterPet(null);
                }
            }
            if (this.player.func_184607_cu().func_77973_b() instanceof AlchemyScrollItem && this.player.field_70173_aa % 5 == 0) {
                AlchemyScrollItem.beginSpikeSpawning(this.player, false, 8);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        if (this.player != null && this.player instanceof ClientPlayerEntity && this.player.func_130014_f_().func_201670_d()) {
            this.getArcInventory().getStacks().forEach(stack -> {
                if (stack.func_77973_b() instanceof IArcItem) {
                    ((IArcItem)stack.func_77973_b()).clientTick((ItemStack)stack, (ClientPlayerEntity)this.player);
                }
            });
        }
    }

    @Override
    public CompoundNBT writeAdditional(CompoundNBT compound) {
        compound.func_218657_a("ArcInventory", (INBT)this.arcInventory.write(new ListNBT()));
        compound.func_74774_a("EverbrightProgression", this.getBrightProgression());
        compound.func_74774_a("EverdawnProgression", this.getDawnProgression());
        compound.func_74774_a("SupporterPetID", this.getSupporterPetID());
        compound.func_74757_a("SupporterPetEnabled", this.isSupporterPetEnabled());
        compound.func_74757_a("SupporterPetAudible", this.isSupporterPetAudible());
        compound.func_74774_a("SupporterStyleID", this.getSupporterStyleID());
        compound.func_74757_a("UsedBlueLore", this.hasUsedBlueLore());
        compound.func_74757_a("FullDuskInvis", this.hasFullDuskInvis());
        compound.func_74776_a("NatureHealth", this.getNatureHealth());
        if (this.prevKeystonePos != null) {
            compound.func_218657_a("KeystoneTeleportPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.prevKeystonePos));
        }
        if (this.getSupporterPetName().length() > 1) {
            compound.func_74778_a("SupporterPetName", this.getSupporterPetName());
        }
        return compound;
    }

    @Override
    public void read(CompoundNBT compound) {
        this.arcInventory.read(compound.func_150295_c("ArcInventory", 10));
        this.setBrightProgression(compound.func_74771_c("EverbrightProgression"));
        this.setDawnProgression(compound.func_74771_c("EverdawnProgression"));
        this.setSupporterPetID(compound.func_74771_c("SupporterPetID"));
        this.setSupporterPetEnabled(compound.func_74767_n("SupporterPetEnabled"));
        this.setSupporterPetAudible(compound.func_74767_n("SupporterPetAudible"));
        this.setSupporterStyleID(compound.func_74771_c("SupporterStyleID"));
        this.setUsedBlueLore(compound.func_74767_n("UsedBlueLore"));
        this.setFullDuskInvis(compound.func_74767_n("FullDuskInvis"));
        this.setNatureHealth(compound.func_74760_g("NatureHealth"));
        this.prevKeystonePos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("KeystoneTeleportPos"));
        if (compound.func_74779_i("SupporterPetName").length() > 1) {
            this.setSupporterPetName(compound.func_74779_i("SupporterPetName"));
        }
    }

    @Override
    public void syncDataToClient() {
        if (this.getPlayer() instanceof ServerPlayerEntity) {
            PacketHandler.sendToClient(new SyncPlayerPacket(this.writeAdditional(new CompoundNBT())), (ServerPlayerEntity)this.getPlayer());
        }
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public void setBossType(SkiesDungeonType bossType) {
        this.activeBossType = bossType;
    }

    @Override
    public SkiesDungeonType getBossType() {
        return this.activeBossType;
    }

    @Override
    public void setDungeonMusicId(SkiesDungeonType musicType) {
        this.dungeonMusicType = musicType;
    }

    @Override
    public SkiesDungeonType getDungeonMusicId() {
        return this.dungeonMusicType;
    }

    @Override
    public ArcInventory getArcInventory() {
        return this.arcInventory;
    }

    @Override
    public void onDeath() {
        if (!this.player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            for (int i = 0; i < this.arcInventory.func_70302_i_(); ++i) {
                ItemStack stack = this.arcInventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (EnchantmentHelper.func_190939_c((ItemStack)stack)) {
                    this.arcInventory.func_70304_b(i);
                    continue;
                }
                this.player.func_146097_a(stack.func_77946_l(), true, false);
                this.arcInventory.func_70301_a(i);
            }
        }
        this.syncDataToClient();
        this.player.field_70170_p.func_175647_a(MobEntity.class, this.player.func_174813_aQ().func_186662_g(30.0), ISkyBoss.IS_BOSS).forEach(boss -> {
            boolean playersAlive;
            List players = this.player.field_70170_p.func_175647_a(PlayerEntity.class, this.player.func_174813_aQ().func_186662_g(30.0), entity -> entity.func_70089_S() && entity.func_110143_aJ() > 0.0f && !entity.func_184812_l_() && !entity.func_175149_v());
            boolean bl = playersAlive = players.size() > 0;
            if (playersAlive) {
                boss.func_70691_i(((ISkyBoss)boss).getHealAmount());
            } else if (this.player.field_70170_p.func_175659_aa() == Difficulty.EASY) {
                boss.func_70691_i(((ISkyBoss)boss).getHealAmount() * 1.5f);
            } else {
                boss.func_70691_i(boss.func_110138_aP());
            }
        });
    }

    private void updateDungeonMusic() {
        boolean inDungeon;
        boolean bl = inDungeon = EntityUtil.isPosInStructure(this.player.field_70170_p, this.player.func_233580_cy_(), SkiesStructures.NATURE_DUNGEON.getStructure()) || EntityUtil.isPosInStructure(this.player.field_70170_p, this.player.func_233580_cy_(), SkiesStructures.POISON_DUNGEON.getStructure()) || EntityUtil.isPosInStructure(this.player.field_70170_p, this.player.func_233580_cy_(), SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure()) || EntityUtil.isPosInStructure(this.player.field_70170_p, this.player.func_233580_cy_(), SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure());
        if (this.wasInStructure != inDungeon) {
            SkiesDungeonType dungeonType = EntityUtil.isPosInStructure(this.player.field_70170_p, this.player.func_233580_cy_(), SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure()) || EntityUtil.isPosInStructure(this.player.field_70170_p, this.player.func_233580_cy_(), SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure()) ? SkiesDungeonType.BLINDING : (EntityUtil.isPosInStructure(this.player.field_70170_p, this.player.func_233580_cy_(), SkiesStructures.NATURE_DUNGEON.getStructure()) ? SkiesDungeonType.NATURE : (EntityUtil.isPosInStructure(this.player.field_70170_p, this.player.func_233580_cy_(), SkiesStructures.POISON_DUNGEON.getStructure()) ? SkiesDungeonType.POISON : SkiesDungeonType.NONE));
            PacketHandler.sendToClient(new DungeonMusicPacket((byte)dungeonType.getId()), (ServerPlayerEntity)this.player);
            this.wasInStructure = inDungeon;
        }
    }

    @Override
    public void teleportToNearestKeystone() {
        if (!(this.player.field_70170_p instanceof ServerWorld)) {
            return;
        }
        BlockPos playerPos = this.player.func_233580_cy_();
        int distance = 30;
        ServerWorld world = (ServerWorld)this.player.field_70170_p;
        PointOfInterestManager pointofinterestmanager = world.func_217443_B();
        pointofinterestmanager.func_226347_a_((IWorldReader)this.player.field_70170_p, playerPos, distance);
        Optional optional = world.func_217443_B().func_226353_b_(poiType -> poiType == SkiesPointsOfInterest.KEYSTONE, playerPos, distance, PointOfInterestManager.Status.ANY).findFirst();
        if (optional.isPresent()) {
            BlockState keystoneState = world.func_180495_p(((PointOfInterest)optional.get()).func_218261_f());
            BlockPos spawnPos = keystoneState.func_235901_b_(KeystoneBlock.DirectionalKeystoneBlock.FACING) ? ((PointOfInterest)optional.get()).func_218261_f().func_177967_a((Direction)keystoneState.func_177229_b(KeystoneBlock.DirectionalKeystoneBlock.FACING), 2) : ((PointOfInterest)optional.get()).func_218261_f().func_177967_a(Direction.NORTH, 3);
            this.player.func_70107_b((double)((float)spawnPos.func_177958_n() + 0.5f), (double)spawnPos.func_177956_o(), (double)((float)spawnPos.func_177952_p() + 0.5f));
            if (this.player instanceof ServerPlayerEntity) {
                PacketHandler.sendToClient(new DisplayToastPacket(1), (ServerPlayerEntity)this.player);
            }
        }
    }

    @Override
    public void checkAndSpawnPet() {
        if (this.isSupporterPetEnabled() && this.getSupporterPet() == null && BlueSkies.SUPPORTERS.isRanked(this.player)) {
            try {
                SupporterPetEntity pet = SkiesPlayer.createPet(this.player.field_70170_p);
                pet.func_70903_f(true);
                pet.func_184754_b(this.player.func_110124_au());
                this.setSupporterPet((LivingEntity)pet);
                pet.setTypeID((byte)Math.max(0, this.getSupporterPetID()));
                pet.func_70107_b(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_());
                pet.func_174810_b(!this.isSupporterPetAudible());
                if (this.getSupporterPetName() != null && !pet.func_145818_k_() && this.getSupporterPetName().length() > 0) {
                    pet.func_174805_g(true);
                    pet.func_200203_b((ITextComponent)new StringTextComponent(this.getSupporterPetName()).func_240699_a_(TextFormatting.values()[Math.max(0, this.supporterStyleId)]));
                }
                this.player.field_70170_p.func_217376_c((Entity)pet);
            }
            catch (NullPointerException e) {
                BlueSkies.LOGGER.error(MARKER, "Something went wrong trying to spawn a supporter pet for {}!", (Object)this.player.func_200200_C_().getString(), (Object)e);
            }
        }
    }

    private static SupporterPetEntity createPet(World level) {
        return (SupporterPetEntity)Objects.requireNonNull(SkiesEntityTypes.SUPPORTER_PET.func_200721_a(level));
    }

    @Override
    public byte getBrightProgression() {
        return this.brightProgression;
    }

    @Override
    public byte getDawnProgression() {
        return this.dawnProgression;
    }

    @Override
    public byte getSupporterPetID() {
        return this.supporterPetId;
    }

    @Override
    public Vector3d getSavedClientMotion() {
        return this.preservedMotionVec;
    }

    @Override
    public LivingEntity getSupporterPet() {
        return this.supporterPet;
    }

    @Override
    public boolean isSupporterPetEnabled() {
        return this.supporterPetEnabled;
    }

    @Override
    public boolean isSupporterPetAudible() {
        return this.supporterPetAudible;
    }

    @Override
    public String getSupporterPetName() {
        return this.supporterPetName;
    }

    @Override
    public boolean hasUsedBlueLore() {
        return this.usedBlueLore;
    }

    @Override
    public void setBrightProgression(byte bossNumber) {
        this.brightProgression = bossNumber;
    }

    @Override
    public void setDawnProgression(byte bossNumber) {
        this.dawnProgression = bossNumber;
    }

    @Override
    public void setSavedClientMotion(double motionX, double motionY, double motionZ) {
        this.preservedMotionVec = new Vector3d(motionX, 0.0, motionZ);
    }

    @Override
    public void setSupporterPetID(byte id) {
        this.supporterPetId = id;
    }

    @Override
    public void setSupporterPetEnabled(boolean enabled) {
        this.supporterPetEnabled = enabled;
    }

    @Override
    public void setSupporterPetAudible(boolean audible) {
        this.supporterPetAudible = audible;
    }

    @Override
    public void setSupporterPetName(String name) {
        this.supporterPetName = name;
    }

    @Override
    public void setSupporterPet(LivingEntity entity) {
        this.supporterPet = entity;
    }

    @Override
    public byte getSupporterStyleID() {
        return this.supporterStyleId;
    }

    @Override
    public void setSupporterStyleID(byte id) {
        this.supporterStyleId = id;
    }

    @Override
    public void setUsedBlueLore(boolean used) {
        this.usedBlueLore = used;
        if (this.getPlayer() != null && this.getPlayer() instanceof ServerPlayerEntity) {
            PacketHandler.sendToClient(new UpdateBlueLorePacket(used), (ServerPlayerEntity)this.getPlayer());
        }
    }

    @Override
    public boolean hasFullDuskInvis() {
        return this.fullDuskInvis;
    }

    @Override
    public void setFullDuskInvis(boolean isInvisible) {
        this.fullDuskInvis = isInvisible;
    }

    @Override
    public float getNatureHealth() {
        return this.natureHealth;
    }

    @Override
    public void setNatureHealth(float value) {
        this.natureHealth = value;
        if (this.getPlayer() != null && this.getPlayer() instanceof ServerPlayerEntity) {
            PacketHandler.sendToClient(new UpdateNatureHealthPacket(value), (ServerPlayerEntity)this.getPlayer());
        }
    }
}

