/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.container;

import com.legacy.blue_skies.client.gui.container.ServerRecipePlacerHorizoniteForge;
import com.legacy.blue_skies.registries.SkiesContainers;
import com.legacy.blue_skies.tile_entity.HorizoniteForgeTileEntity;
import com.legacy.blue_skies.tile_entity.IRecipeUnlocker;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.FurnaceResultSlot;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeBookCategory;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class HorizoniteForgeContainer
extends RecipeBookContainer<IInventory> {
    private final HorizoniteForgeTileEntity tile;
    private final IIntArray furnaceData;
    protected final World world;

    public HorizoniteForgeContainer(int id, PlayerInventory playerInv) {
        this(id, playerInv, new HorizoniteForgeTileEntity(), (IIntArray)new IntArray(4));
    }

    public HorizoniteForgeContainer(int id, PlayerInventory playerInv, HorizoniteForgeTileEntity tile, IIntArray furnaceData) {
        super(SkiesContainers.HORIZONITE_FORGE, id);
        this.tile = tile;
        this.furnaceData = furnaceData;
        this.world = playerInv.field_70458_d.field_70170_p;
        this.func_75146_a(new Slot((IInventory)tile, 0, 56, 17));
        this.func_75146_a(new FuelSlot(this, (IInventory)tile, 1, 22, 54));
        this.func_75146_a((Slot)new ResultSlot(playerInv.field_70458_d, (IInventory)tile, 2, 116, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInv, k, 8 + k * 18, 142));
        }
        this.func_216961_a(furnaceData);
    }

    public void func_201771_a(RecipeItemHelper itemHelperIn) {
        if (this.tile instanceof IRecipeHelperPopulator) {
            this.tile.func_194018_a(itemHelperIn);
        }
    }

    public void func_201768_e() {
        this.tile.func_174888_l();
    }

    public void func_217056_a(boolean placeAll, IRecipe<?> recipe, ServerPlayerEntity player) {
        new ServerRecipePlacerHorizoniteForge<IInventory>(this).func_194327_a(player, recipe, placeAll);
    }

    public boolean func_201769_a(IRecipe<? super IInventory> recipeIn) {
        return recipeIn.func_77569_a((IInventory)this.tile, this.world);
    }

    public int func_201767_f() {
        return 2;
    }

    public int func_201770_g() {
        return 1;
    }

    public int func_201772_h() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_203721_h() {
        return 3;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.tile.func_70300_a(player);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack existingClone = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack existingStack = slot.func_75211_c();
            existingClone = existingStack.func_77946_l();
            if (index == 2) {
                if (!this.func_75135_a(existingStack, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(existingStack, existingClone);
            } else if (index != 1 && index != 0 ? (this.hasRecipe(existingStack) ? !this.func_75135_a(existingStack, 0, 1, false) : (this.isFuel(existingStack) ? !this.func_75135_a(existingStack, 1, 2, false) : (index >= 3 && index < 30 ? !this.func_75135_a(existingStack, 30, 39, false) : index >= 30 && index < 39 && !this.func_75135_a(existingStack, 3, 30, false)))) : !this.func_75135_a(existingStack, 3, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (existingStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (existingStack.func_190916_E() == existingClone.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, existingStack);
        }
        return existingClone;
    }

    protected boolean hasRecipe(ItemStack stack) {
        return this.world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), this.world).isPresent();
    }

    protected boolean isFuel(ItemStack stack) {
        return HorizoniteForgeTileEntity.isFuel(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressionScaled() {
        double cookTime = this.furnaceData.func_221476_a(2);
        double maxCookTime = this.furnaceData.func_221476_a(3);
        return (int)(cookTime / maxCookTime * 24.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergyLeftScaled() {
        double maxEnergy;
        double energy = this.furnaceData.func_221476_a(0);
        double scaled = energy / (maxEnergy = (double)this.furnaceData.func_221476_a(1)) * 32.0;
        return scaled > 0.0 && scaled < 1.0 ? 1 : (int)scaled;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isCooking() {
        return this.furnaceData.func_221476_a(2) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RecipeBookCategory func_241850_m() {
        return RecipeBookCategory.FURNACE;
    }

    public static class ResultSlot
    extends FurnaceResultSlot {
        private final PlayerEntity player;
        private int removeCount;

        public ResultSlot(PlayerEntity player, IInventory furnaceInv, int id, int x, int y) {
            super(player, furnaceInv, id, x, y);
            this.player = player;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_75209_a(int amount) {
            if (this.func_75216_d()) {
                this.removeCount += Math.min(amount, this.func_75211_c().func_190916_E());
            }
            return super.func_75209_a(amount);
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            this.func_75208_c(stack);
            super.func_190901_a(player, stack);
            return stack;
        }

        protected void func_75210_a(ItemStack stack, int amount) {
            this.removeCount += amount;
            this.func_75208_c(stack);
        }

        protected void func_75208_c(ItemStack stack) {
            stack.func_77980_a(this.player.field_70170_p, this.player, this.removeCount);
            if (!this.player.field_70170_p.field_72995_K && this.field_75224_c instanceof IRecipeUnlocker) {
                ((IRecipeUnlocker)this.field_75224_c).unlockRecipes(this.player);
            }
            this.removeCount = 0;
            BasicEventHooks.firePlayerSmeltedEvent((PlayerEntity)this.player, (ItemStack)stack);
        }
    }

    public static class FuelSlot
    extends Slot {
        private final HorizoniteForgeContainer container;

        public FuelSlot(HorizoniteForgeContainer container, IInventory furnaceInv, int id, int x, int y) {
            super(furnaceInv, id, x, y);
            this.container = container;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.container.isFuel(stack);
        }
    }
}

