/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen.journal;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.assets.BlueSkiesAssets;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalScreen;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalNarratorButton;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalSectionButton;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.journal.JournalEntry;
import com.legacy.blue_skies.data.objects.journal.JournalRequirement;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public class BlueJournalEntryScreen
extends BlueJournalScreen {
    private final JournalEntry entry;
    public final JournalSectionButton sectionButton;
    private List<List<ITextProperties>> pagesOfLines = new ArrayList<List<ITextProperties>>();
    private JournalEntry.Lore lore;

    public BlueJournalEntryScreen(@Nullable BlueJournalScreen previousScreen, JournalEntry entry, JournalSectionButton sectionButton) {
        super(previousScreen);
        this.entry = entry;
        this.sectionButton = sectionButton;
    }

    @Override
    protected void loadData() {
        this.pagesOfLines.clear();
        int lineWidth = 135;
        this.lore = this.getLore();
        List lines = this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)new StringTextComponent("\n\n").func_230529_a_((ITextComponent)BlueSkiesAssets.JOURNAL_LANG.getTranslation(this.lore.text)), lineWidth, Style.field_240709_b_);
        int linesPerPage = 16;
        this.totalPages = lines.size() / linesPerPage + (lines.size() % linesPerPage == 0 ? 0 : 1);
        for (int i = 0; i < this.totalPages; ++i) {
            this.pagesOfLines.add(lines.subList(i * linesPerPage, Math.min(linesPerPage * (i + 1), lines.size())));
        }
        if (this.lore.display != null) {
            ++this.totalPages;
            if (this.pagesOfLines.size() >= 1) {
                this.pagesOfLines.add(1, new ArrayList());
            }
            this.lore.display.init(this.field_230706_i_);
        }
        JournalSectionButton currentSectionButton = new JournalSectionButton(this.field_230708_k_ / 2 + 145, this.field_230709_l_ / 2 - 100, this.sectionButton.section, button -> this.previousScreen.goBack());
        currentSectionButton.forced = true;
        this.func_230480_a_((Widget)currentSectionButton);
        this.func_230480_a_((Widget)new JournalNarratorButton(this.field_230708_k_ / 2 - 120, this.field_230709_l_ / 2 + 84, button -> {
            ArrayList<ITextProperties> text = new ArrayList<ITextProperties>();
            for (List<ITextProperties> page : this.pagesOfLines) {
                for (ITextProperties line : page) {
                    text.add(line);
                }
            }
            JournalNarratorButton.narrate(Arrays.asList(text));
        }));
    }

    protected JournalEntry.Lore getLore() {
        if (this.entry.lores.size() == 1) {
            return this.entry.lores.get(0);
        }
        this.entry.lores.sort((p1, p2) -> {
            JournalRequirement r1 = (JournalRequirement)BlueSkiesData.JOURNAL_REQUIREMENTS.getValue(p1.requirement);
            JournalRequirement r2 = (JournalRequirement)BlueSkiesData.JOURNAL_REQUIREMENTS.getValue(p2.requirement);
            if (r1 == null || r2 == null) {
                return 0;
            }
            int a1 = r1.advancement == null ? 0 : 1;
            int a2 = r2.advancement == null ? 0 : 1;
            int b1 = r1.everbrightProgression < 0 ? 0 : r1.everbrightProgression;
            int b2 = r2.everbrightProgression < 0 ? 0 : r2.everbrightProgression;
            int d1 = r1.everdawnProgression < 0 ? 0 : r1.everdawnProgression;
            int d2 = r2.everdawnProgression < 0 ? 0 : r2.everdawnProgression;
            int total1 = a1 + b1 + d1;
            int total2 = a2 + b2 + d2;
            return Integer.compare(total1, total2);
        });
        for (JournalEntry.Lore lorePair : Lists.reverse(this.entry.lores)) {
            if (lorePair.requirement != null) {
                ClientAdvancementManager advancements;
                Advancement advancement;
                ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
                JournalRequirement requirement = (JournalRequirement)BlueSkiesData.JOURNAL_REQUIREMENTS.getValue(lorePair.requirement);
                if (requirement == null) continue;
                boolean advancementDone = false;
                if (requirement.advancement != null && (advancement = (advancements = player.field_71174_a.func_191982_f()).func_194229_a().func_192084_a(requirement.advancement)) != null) {
                    advancementDone = ((AdvancementProgress)advancements.field_192803_d.get(advancement)).func_192105_a();
                }
                int everbrightProg = SkiesPlayer.getIfPresent(player, s -> s.getBrightProgression(), () -> -1);
                int everdawnProg = SkiesPlayer.getIfPresent(player, s -> s.getDawnProgression(), () -> -1);
                if (!advancementDone && requirement.advancement != null || everbrightProg < requirement.everbrightProgression && requirement.everbrightProgression >= 0 || everdawnProg < requirement.everdawnProgression && requirement.everdawnProgression >= 0) continue;
                return lorePair;
            }
            return lorePair;
        }
        return this.entry.lores.get(this.entry.lores.size() - 1);
    }

    @Override
    protected void renderExtra(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.page == 0) {
            this.renderTitle(matrix);
            if (this.lore.display != null) {
                this.renderDisplay(matrix, partialTicks);
            }
        }
        this.renderText(matrix, this.page);
    }

    protected void renderTitle(MatrixStack matrix) {
        StringTextComponent title = BlueSkiesAssets.JOURNAL_LANG.getTranslation(this.entry.title);
        int centerX = this.field_230708_k_ / 2;
        int centerY = this.field_230709_l_ / 2;
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)title, (float)(centerX - this.field_230712_o_.func_238414_a_((ITextProperties)title) / 2 - 80), (float)(centerY - 90), 0);
        this.field_230706_i_.func_110434_K().func_110577_a(BlueJournalScreen.WIDGETS);
        this.func_238474_b_(matrix, centerX - 140, centerY - 80, 0, 74, 122, 6);
    }

    protected void renderText(MatrixStack matrix, int page) {
        int middleX = this.field_230708_k_ / 2;
        int middleY = this.field_230709_l_ / 2;
        for (int i = 0; i < 2 && page + i < this.pagesOfLines.size(); ++i) {
            int offset = 0;
            for (ITextProperties t : this.pagesOfLines.get(page + i)) {
                this.field_230712_o_.func_243248_b(matrix, (ITextComponent)new StringTextComponent(t.getString()), (float)(middleX + (i == 0 ? -145 : 4)), (float)(middleY - 105 + (offset += 11)), 0);
            }
        }
    }

    protected void renderDisplay(MatrixStack matrix, float partialTicks) {
        this.field_230706_i_.func_110434_K().func_110577_a(BlueJournalScreen.DISPLAY_FRAME);
        int bookHeight = 220;
        this.func_238474_b_(matrix, this.field_230708_k_ / 2, (this.field_230709_l_ - bookHeight) / 2, 0, 0, 153, bookHeight);
        this.lore.display.render(matrix, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, partialTicks);
    }
}

