/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen.journal;

import com.google.gson.JsonObject;
import com.legacy.blue_skies.data.objects.IToJson;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JournalEntryRenderers {

    public static class EntityDisplay
    implements IRenderable {
        private static float rotation = 0.0f;
        private static LivingEntity entity;
        private final EntityType<?> entityType;
        private final int scale;
        private final int yOffset;

        public EntityDisplay(EntityType<?> entityType, int scale, int yOffset) {
            this.entityType = entityType;
            this.scale = scale;
            this.yOffset = yOffset;
        }

        public EntityType<?> getEntity() {
            return this.entityType;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void init(Minecraft mc) {
            ClientWorld world;
            Entity newEntity;
            if (entity != null) {
                entity.func_70106_y();
            }
            entity = (newEntity = this.entityType.func_200721_a((World)(world = mc.field_71441_e))) instanceof LivingEntity ? (LivingEntity)newEntity : (LivingEntity)EntityType.field_200784_X.func_200721_a((World)world);
            EntityDisplay.entity.field_70759_as = 0.0f;
            EntityDisplay.entity.field_70761_aq = 0.0f;
            EntityDisplay.entity.field_70177_z = 0.0f;
            EntityDisplay.entity.field_70125_A = 0.0f;
            ClientPlayerEntity player = mc.field_71439_g;
            rotation = -player.field_70173_aa - 45;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(MatrixStack matrix, Minecraft mc, int width, int height, float partialTicks) {
            ClientPlayerEntity player = mc.field_71439_g;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(width / 2 + 70), (double)(height / 2 + this.yOffset), (double)200.0);
            float rotationTick = rotation + (float)player.field_70173_aa + partialTicks;
            RenderSystem.rotatef((float)rotationTick, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.rotatef((float)((float)Math.sin(rotationTick / 20.0f) * 2.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.translated((double)0.0, (double)0.0, (double)-50.0);
            int lightX = 6;
            int lightY = 5;
            int lightZ = 4;
            RenderSystem.setupGui3DDiffuseLighting((Vector3f)new Vector3f((float)(-lightX), (float)lightY, (float)lightZ), (Vector3f)new Vector3f((float)lightX, (float)lightY, (float)(-lightZ)));
            InventoryScreen.func_228187_a_((int)0, (int)0, (int)this.scale, (float)0.0f, (float)0.0f, (LivingEntity)entity);
            RenderSystem.popMatrix();
        }

        @Override
        public String getType() {
            return "entity";
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("entity", this.entityType.getRegistryName().toString());
            json.addProperty("scale", (Number)this.scale);
            json.addProperty("y_offset", (Number)this.yOffset);
            return json;
        }
    }

    public static class ImageDisplay
    implements IRenderable {
        private final ResourceLocation image;

        public ImageDisplay(ResourceLocation image) {
            this.image = image;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(MatrixStack matrix, Minecraft mc, int width, int height, float partialTicks) {
            mc.field_71446_o.func_110577_a(this.image);
            int bookHeight = 220;
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(width / 2), (int)((height - bookHeight) / 2), (float)0.0f, (float)0.0f, (int)153, (int)bookHeight, (int)256, (int)256);
        }

        @Override
        public String getType() {
            return "image";
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("image", this.image.toString());
            return json;
        }
    }

    public static class TextureIcon
    implements IRenderable {
        private final ResourceLocation texture;

        public TextureIcon(ResourceLocation texture) {
            this.texture = texture;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(MatrixStack matrix, Minecraft mc, int x, int y, float partialTicks) {
            mc.field_71446_o.func_110577_a(this.texture);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }

        @Override
        public String getType() {
            return "texture";
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("texture", this.texture.toString());
            return json;
        }
    }

    public static class ItemIcon
    implements IRenderable {
        private final ItemStack item;

        public ItemIcon(IItemProvider item) {
            this.item = new ItemStack(item);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(MatrixStack matrix, Minecraft mc, int x, int y, float partialTicks) {
            mc.func_175599_af().func_239390_c_(this.item, x, y);
        }

        @Override
        public String getType() {
            return "item";
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("item", this.item.func_77973_b().getRegistryName().toString());
            return json;
        }
    }

    public static interface IRenderable
    extends IToJson<IRenderable> {
        @OnlyIn(value=Dist.CLIENT)
        public void render(MatrixStack var1, Minecraft var2, int var3, int var4, float var5);

        public String getType();

        @OnlyIn(value=Dist.CLIENT)
        default public void init(Minecraft mc) {
        }
    }
}

