/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.crafting;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesRecipes;
import com.legacy.blue_skies.util.StringUtil;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ToolRecipe
extends ShapedRecipe {
    private final Item tool;
    private final Materials material;
    private final RecipeShapes shape;
    private NonNullList<Ingredient> ingredients;

    public ToolRecipe(ResourceLocation id, Materials material, Item tool, RecipeShapes shape) {
        super(id, "", shape.width, shape.height, NonNullList.func_191196_a(), new ItemStack((IItemProvider)tool));
        this.tool = tool;
        this.material = material;
        this.shape = shape;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SkiesRecipes.SERIALIZERS.get(this.func_199560_c());
    }

    public NonNullList<Ingredient> func_192400_c() {
        if (this.ingredients == null) {
            this.ingredients = this.shape.create(this.material.getIngredient());
        }
        return this.ingredients;
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        for (int x = 0; x <= inv.func_174922_i() - this.getRecipeWidth(); ++x) {
            for (int y = 0; y <= inv.func_174923_h() - this.getRecipeHeight(); ++y) {
                if (!this.checkMatch(inv, x, y, true) && !this.checkMatch(inv, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(CraftingInventory craftingInventory, int width, int height, boolean mirrored) {
        for (int x = 0; x < craftingInventory.func_174922_i(); ++x) {
            for (int y = 0; y < craftingInventory.func_174923_h(); ++y) {
                int k = x - width;
                int l = y - height;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.getRecipeWidth() && l < this.getRecipeHeight()) {
                    ingredient = mirrored ? (Ingredient)this.func_192400_c().get(this.getRecipeWidth() - k - 1 + l * this.getRecipeWidth()) : (Ingredient)this.func_192400_c().get(k + l * this.getRecipeWidth());
                }
                if (ingredient.test(craftingInventory.func_70301_a(x + y * craftingInventory.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        boolean stickFlag = true;
        Item stick = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (stick == null && BlueSkiesData.TOOL_HANDLE_TYPES.hasHandle(inv.func_70301_a(i).func_77973_b())) {
                stick = inv.func_70301_a(i).func_77973_b();
            }
            if (stick == null || !BlueSkiesData.TOOL_HANDLE_TYPES.hasHandle(inv.func_70301_a(i).func_77973_b()) || stick == inv.func_70301_a(i).func_77973_b()) continue;
            stickFlag = false;
        }
        if (stick != null && stickFlag) {
            ItemStack output = new ItemStack((IItemProvider)this.tool);
            output.func_196082_o().func_74778_a("Stick", BlueSkiesData.TOOL_HANDLE_TYPES.getHandle(stick).getName());
            return output;
        }
        return ItemStack.field_190927_a;
    }

    public static enum Materials {
        BLUEBRIGHT((IItemProvider)SkiesBlocks.bluebright_planks),
        STARLIT((IItemProvider)SkiesBlocks.starlit_planks),
        FROSTBRIGHT((IItemProvider)SkiesBlocks.frostbright_planks),
        LUNAR((IItemProvider)SkiesBlocks.lunar_planks),
        DUSK((IItemProvider)SkiesBlocks.dusk_planks),
        MAPLE((IItemProvider)SkiesBlocks.maple_planks),
        CHERRY((IItemProvider)SkiesBlocks.cherry_planks),
        TURQUOISE_STONE((IItemProvider)SkiesBlocks.turquoise_cobblestone),
        LUNAR_STONE((IItemProvider)SkiesBlocks.lunar_cobblestone),
        PYROPE((IItemProvider)SkiesItems.pyrope_gem),
        AQUITE((IItemProvider)SkiesItems.aquite_gem),
        DIOPSIDE((IItemProvider)SkiesItems.diopside_gem),
        CHAROITE((IItemProvider)SkiesItems.charoite),
        HORIZONITE((IItemProvider)SkiesItems.horizonite_ingot);

        private final Ingredient ingredient;

        private Materials(IItemProvider item) {
            this.ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        public IItemProvider getItem() {
            return this.ingredient.func_193365_a()[0].func_77973_b();
        }
    }

    public static enum RecipeShapes {
        AXE(2, 3, "mm", "ms", " s"),
        PICKAXE(3, 3, "mmm", " s ", " s "),
        SHOVEL(1, 3, "m", "s", "s"),
        HOE(2, 3, "mm", " s", " s"),
        SWORD(1, 3, "m", "m", "s");

        public final int width;
        public final int height;
        public final String[] rows;

        private RecipeShapes(int width, int height, String ... rows) {
            this.width = width;
            this.height = height;
            this.rows = rows;
        }

        public NonNullList<Ingredient> create(Ingredient material) {
            Object[] ingredients = new Ingredient[this.width * this.height];
            for (int row = 0; row < this.height; ++row) {
                for (int col = 0; col < this.width; ++col) {
                    Object sticks;
                    char c = this.rows[row].charAt(col);
                    Object object = sticks = !BlueSkiesData.TOOL_HANDLE_TYPES.getData().keySet().isEmpty() ? BlueSkiesData.TOOL_HANDLE_TYPES.getData().keySet() : ImmutableSet.of((Object)Items.field_151055_y);
                    Ingredient ingredient = c == 'm' ? material : (c == 's' ? Ingredient.func_199804_a((IItemProvider[])((IItemProvider[])sticks.toArray(new Item[0]))) : Ingredient.field_193370_a);
                    ingredients[row * this.width + col] = ingredient;
                }
            }
            return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients);
        }

        public static RecipeShapes fromString(String key) {
            for (RecipeShapes shape : RecipeShapes.values()) {
                if (!StringUtil.toLower(shape.name()).equals(key)) continue;
                return shape;
            }
            return HOE;
        }
    }
}

