/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.objects.alchemy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.objects.alchemy.AlchemyRecipe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class CatylistRecipe
extends AlchemyRecipe {
    private static final String INPUT_KEY = "input";
    private static final String CATYLIST_KEY = "catylist";
    private static final String RESULTS_KEY = "results";
    private final Item input;
    private final Item catylist;
    private final Set<Item> results;

    public CatylistRecipe(Item input, Item catylist, Set<Item> results, boolean shouldOverride) {
        super(shouldOverride, BlueSkies.locate(CATYLIST_KEY));
        this.input = input;
        this.catylist = catylist;
        this.results = results;
    }

    public Item getInput() {
        return this.input;
    }

    public Item getCatylist() {
        return this.catylist;
    }

    @Override
    public void addResults(Set<Item> items) {
        this.results.addAll(items);
    }

    @Override
    public Set<Item> getResults(ItemStack inputA, ItemStack inputB) {
        return new HashSet<Item>(this.results);
    }

    @Override
    public Set<Item> getResults() {
        return new HashSet<Item>(this.results);
    }

    @Override
    public List<ImmutableTriple<ItemStack, ItemStack, ItemStack>> getAllCombinations() {
        ArrayList<ImmutableTriple<ItemStack, ItemStack, ItemStack>> data = new ArrayList<ImmutableTriple<ItemStack, ItemStack, ItemStack>>();
        for (Item output : this.results) {
            data.add((ImmutableTriple<ItemStack, ItemStack, ItemStack>)ImmutableTriple.of((Object)new ItemStack((IItemProvider)this.input), (Object)new ItemStack((IItemProvider)this.catylist), (Object)new ItemStack((IItemProvider)output)));
        }
        return data;
    }

    @Override
    public boolean matches(ItemStack itemA, ItemStack itemB) {
        return this.input == itemA.func_77973_b() && this.catylist == itemB.func_77973_b();
    }

    @Override
    public CatylistRecipe fromJson(JsonObject json) throws SkiesDataManager.RegistryObjectNotFoundException {
        boolean shouldOverride = JSONUtils.func_151209_a((JsonObject)json, (String)"override", (boolean)false);
        Item input = SkiesDataManager.parseItem(json, INPUT_KEY);
        Item catylist = SkiesDataManager.parseItem(json, CATYLIST_KEY);
        HashSet<Item> results = new HashSet<Item>();
        JSONUtils.func_151214_t((JsonObject)json, (String)RESULTS_KEY).forEach(j -> {
            ResourceLocation name = new ResourceLocation(j.getAsString());
            if (ForgeRegistries.ITEMS.containsKey(name)) {
                results.add((Item)ForgeRegistries.ITEMS.getValue(name));
            }
        });
        return new CatylistRecipe(input, catylist, results, shouldOverride);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type.toString());
        json.addProperty("override", Boolean.valueOf(this.shouldOverride));
        json.addProperty(INPUT_KEY, this.input.getRegistryName().toString());
        json.addProperty(CATYLIST_KEY, this.catylist.getRegistryName().toString());
        JsonArray results = new JsonArray();
        this.results.forEach(i -> results.add(i.getRegistryName().toString()));
        json.add(RESULTS_KEY, (JsonElement)results);
        return json;
    }

    @Override
    public CatylistRecipe fromNbt(CompoundNBT nbt) {
        boolean shouldOverride = nbt.func_74767_n("override");
        HashSet<Item> results = new HashSet<Item>();
        Item input = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i(INPUT_KEY)));
        Item catylist = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i(CATYLIST_KEY)));
        nbt.func_150295_c(RESULTS_KEY, 8).forEach(inbt -> results.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(inbt.func_150285_a_()))));
        return new CatylistRecipe(input, catylist, results, shouldOverride);
    }

    @Override
    public CompoundNBT toNbt(AlchemyRecipe recipe) {
        if (recipe instanceof CatylistRecipe) {
            CatylistRecipe catylistRecipe = (CatylistRecipe)recipe;
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("type", recipe.type.toString());
            nbt.func_74757_a("override", recipe.shouldOverride);
            nbt.func_74778_a(INPUT_KEY, catylistRecipe.input.getRegistryName().toString());
            nbt.func_74778_a(CATYLIST_KEY, catylistRecipe.catylist.getRegistryName().toString());
            ListNBT items = new ListNBT();
            catylistRecipe.results.forEach(i -> items.add((Object)StringNBT.func_229705_a_((String)i.getRegistryName().toString())));
            nbt.func_218657_a(RESULTS_KEY, (INBT)items);
            return nbt;
        }
        throw new IllegalArgumentException("The recipe passed was not an instanceof " + this.getClass().toString());
    }
}

