/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.passive.CrogreEntity;
import com.legacy.blue_skies.entities.util.MovingEntitySound;
import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EmberbackEntity
extends SkiesMonsterEntity {
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EmberbackEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    public int attackTimer;
    @OnlyIn(value=Dist.CLIENT)
    private ISound flapSound;

    public EmberbackEntity(EntityType<? extends EmberbackEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new AIMoveControl(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, CrogreEntity.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, (double)0.4f, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.4));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        super.func_213315_a(typeIn, this.func_175446_cd() ? Vector3d.field_186680_a : pos);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(FLYING, (Object)false);
    }

    public void setFlying(boolean type) {
        this.func_189654_d(type);
        this.field_70180_af.func_187227_b(FLYING, (Object)type);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateWingRotation();
            if (this.isFlying() || this.attackTimer > 0) {
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
                }
            }
        }
        if (!this.func_175446_cd() && this.func_70089_S() && !this.field_205013_W) {
            if (this.func_70638_az() != null) {
                LivingEntity entitylivingbase = this.func_70638_az();
                if (this.func_70032_d((Entity)entitylivingbase) <= 4.0f) {
                    this.setFlying(false);
                } else if (this.isFlying()) {
                    if (this.field_70122_E || !this.field_70170_p.func_175623_d(this.func_233580_cy_().func_177977_b())) {
                        this.func_213293_j(this.func_213322_ci().func_82615_a(), 0.5, this.func_213322_ci().func_82616_c());
                    }
                    this.func_70661_as().func_75499_g();
                    Vector3d vec3d = entitylivingbase.func_174824_e(1.0f);
                    this.func_70605_aq().func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                    this.func_70671_ap().func_220674_a(vec3d);
                } else if (!this.isFlying()) {
                    this.setFlying(true);
                }
            } else if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null) {
                this.setFlying(false);
            }
        }
    }

    public float getDistance(BlockPos posIn) {
        return EntityUtil.getDistanceToPos((Vector3i)this.func_233580_cy_(), (Vector3i)posIn);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.setFlying(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateWingRotation() {
        if (!this.func_174814_R() && this.field_70170_p.field_72995_K) {
            SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
            if (!soundHandler.func_215294_c(this.flapSound) && this.isFlying()) {
                this.flapSound = new MovingEntitySound((LivingEntity)this, SkiesSounds.ENTITY_EMBERBACK_FLYING);
                soundHandler.func_147682_a(this.flapSound);
            } else if (!this.isFlying()) {
                soundHandler.func_147683_b(this.flapSound);
            }
        }
    }

    public static float minMax(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233826_i_, 10.0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsFlying", this.isFlying());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setFlying(compound.func_74767_n("IsFlying"));
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_EMBERBACK_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_EMBERBACK_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_EMBERBACK_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.3f);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        boolean randomBoolean = this.field_70170_p.func_72896_J() ? true : this.field_70146_Z.nextBoolean();
        return randomBoolean && super.func_213380_a(worldIn, spawnReasonIn);
    }

    @Override
    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.0f;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.5f;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof LivingEntity && (this.field_205013_W || entityIn.func_230279_az_() || ((LivingEntity)entityIn).func_70644_a(Effects.field_76426_n))) {
            LivingEntity target = this.func_70638_az();
            if (this.field_70122_E) {
                Vector3d motion = this.func_213322_ci();
                Vector3d targetDirection = new Vector3d(target.func_226277_ct_() - this.func_226277_ct_(), 0.0, target.func_226281_cx_() - this.func_226281_cx_());
                if (targetDirection.func_189985_c() > 1.0E-7) {
                    targetDirection = targetDirection.func_72432_b().func_186678_a(0.4).func_178787_e(motion.func_186678_a(0.2));
                }
                this.func_213293_j(targetDirection.field_72450_a, 0.3f, targetDirection.field_72449_c);
            }
            return entityIn.func_70097_a(EntityUtil.DamageSources.causeBiteDamage((Entity)this), 3.0f);
        }
        for (LivingEntity living : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(2.0), EntityPredicates.field_233583_f_)) {
            if (living == this || living.func_230279_az_() || !living.func_70097_a(EntityUtil.DamageSources.causeEmberDamage((Entity)this), 3.0f)) continue;
            living.func_70015_d(1 + this.field_70170_p.field_73012_v.nextInt(5));
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        this.attackTimer = 10;
        this.func_184185_a(SkiesSounds.ENTITY_EMBERBACK_SPRAY, this.func_70599_aP(), this.func_70647_i());
        return true;
    }

    public void func_213352_e(Vector3d vec) {
        if (this.isFlying()) {
            if (this.func_70090_H()) {
                this.func_213309_a(0.02f, vec);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.8f));
            } else if (this.func_180799_ab()) {
                this.func_213309_a(0.02f, vec);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
            } else {
                BlockPos ground = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b - 1.0, this.func_226281_cx_());
                float f = 0.91f;
                if (this.field_70122_E) {
                    f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
                }
                float f1 = 0.16277137f / (f * f * f);
                f = 0.91f;
                if (this.field_70122_E) {
                    f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
                }
                this.func_213309_a(this.field_70122_E ? 0.1f * f1 : 0.02f, vec);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213317_d(this.func_213322_ci().func_186678_a((double)f));
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.func_226277_ct_() - this.field_70169_q;
            double d0 = this.func_226281_cx_() - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_213352_e(vec);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                for (int i = 0; i < 30; ++i) {
                    double xSpeed = this.field_70146_Z.nextGaussian() * 0.2;
                    double ySpeed = this.field_70146_Z.nextGaussian() * 0.2;
                    double zSpeed = this.field_70146_Z.nextGaussian() * 0.2;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), xSpeed, ySpeed, zSpeed);
                }
                this.attackTimer = 10;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    class AIMoveControl
    extends MovementController {
        public AIMoveControl(EmberbackEntity bug) {
            super((MobEntity)bug);
        }

        public void func_75641_c() {
            if (EmberbackEntity.this.func_70638_az() != null && EmberbackEntity.this.isFlying()) {
                if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                    this.field_188491_h = MovementController.Action.MOVE_TO;
                }
                Vector3d vec3d = new Vector3d(this.field_75646_b - EmberbackEntity.this.func_226277_ct_(), this.field_75647_c - EmberbackEntity.this.func_226278_cu_(), this.field_75644_d - EmberbackEntity.this.func_226281_cx_());
                double d0 = vec3d.func_72433_c();
                EmberbackEntity.this.func_213317_d(EmberbackEntity.this.func_213322_ci().func_178787_e(vec3d.func_186678_a(this.getSpeed() * 0.05 / d0)));
                double d4 = EmberbackEntity.this.func_70638_az().func_226277_ct_() - EmberbackEntity.this.func_226277_ct_();
                double d5 = EmberbackEntity.this.func_70638_az().func_226281_cx_() - EmberbackEntity.this.func_226281_cx_();
                EmberbackEntity.this.field_70761_aq = EmberbackEntity.this.field_70759_as = (EmberbackEntity.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f);
            } else {
                super.func_75641_c();
            }
        }

        public double getSpeed() {
            return 0.45f;
        }
    }
}

