/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.ai.NonCreatureAttackGoal;
import com.legacy.blue_skies.entities.util.MovingEntitySound;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NyctoflyEntity
extends FlyingEntity
implements IMob {
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    protected int idleTime;
    @OnlyIn(value=Dist.CLIENT)
    private ISound flapSound;

    public NyctoflyEntity(EntityType<? extends NyctoflyEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 5;
        this.func_189654_d(true);
        this.field_70765_h = new AIMoveControl(this);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(3, (Goal)new NonCreatureAttackGoal((MobEntity)this, 1.7f, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new NyctoRandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new NyctoLookAroundGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 40.0);
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        if (this.func_175446_cd()) {
            super.func_213315_a(typeIn, Vector3d.field_186680_a);
        } else {
            super.func_213315_a(typeIn, pos);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.playFlightSound();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.func_70605_aq().func_75642_a(this.func_226277_ct_(), this.func_226278_cu_() + 2.0, this.func_226281_cx_(), 0.3);
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
            if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                this.func_70106_y();
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null) {
            if (!this.func_70638_az().func_70089_S() || this.func_94060_bK() != null && !EntityPredicates.field_233583_f_.test(this.func_94060_bK())) {
                this.func_70624_b(null);
            }
            if (this.func_70638_az() != null) {
                Vector3d targetEyes = this.func_70638_az().func_174824_e(1.0f);
                this.func_70605_aq().func_75642_a(targetEyes.field_72450_a, targetEyes.field_72448_b, targetEyes.field_72449_c, 1.0);
                this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 40.0f, 40.0f);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.idleTime = this.func_213322_ci().field_72450_a <= 1.0 && this.func_213322_ci().field_72449_c <= 1.0 && this.idleTime <= 100 ? ++this.idleTime : 0;
        }
        if (this.field_70122_E) {
            this.field_70122_E = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playFlightSound() {
        if (!this.func_174814_R() && this.field_70170_p.field_72995_K) {
            SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
            if (this.flapSound == null && !soundHandler.func_215294_c(this.flapSound) || this.flapSound != null && !soundHandler.func_215294_c(this.flapSound)) {
                this.flapSound = new MovingEntitySound((LivingEntity)this, SkiesSounds.ENTITY_NYCTOFLY_FLYING);
                soundHandler.func_147682_a(this.flapSound);
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        this.func_184185_a(SkiesSounds.ENTITY_NYCTOFLY_BITE, 0.5f, 1.0f);
        return entityIn.func_70097_a(EntityUtil.DamageSources.causeBiteDamage((Entity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_NYCTOFLY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_NYCTOFLY_DEATH;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        boolean randomBoolean = this.field_70170_p.func_72896_J() ? true : this.field_70146_Z.nextBoolean();
        return randomBoolean && super.func_213380_a(worldIn, spawnReasonIn);
    }

    public int func_70641_bl() {
        return 1;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.5f;
    }

    public boolean isNotColliding(double x, double y, double z, double radius) {
        double d0 = (x - this.func_226277_ct_()) / radius;
        double d1 = (y - this.func_226278_cu_()) / radius;
        double d2 = (z - this.func_226281_cx_()) / radius;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = 1;
        while ((double)i < radius) {
            if (!this.field_70170_p.func_226664_a_(axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    class AIMoveControl
    extends MovementController {
        private NyctoflyEntity nycto;

        public AIMoveControl(NyctoflyEntity bug) {
            super((MobEntity)bug);
            this.nycto = NyctoflyEntity.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d difference = new Vector3d(this.field_75646_b - this.nycto.func_226277_ct_(), this.field_75647_c - this.nycto.func_226278_cu_(), this.field_75644_d - this.nycto.func_226281_cx_());
                double d0 = difference.func_72433_c();
                if (d0 < this.nycto.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.nycto.func_213317_d(this.nycto.func_213322_ci().func_186678_a(0.5));
                } else {
                    if (this.nycto.func_70638_az() != null && this.nycto.func_70638_az().func_208600_a((ITag)FluidTags.field_206959_a)) {
                        return;
                    }
                    this.nycto.func_213317_d(this.nycto.func_213322_ci().func_178787_e(difference.func_186678_a(this.func_75638_b() * 0.05 / d0)));
                    if (this.nycto.func_70638_az() == null) {
                        this.nycto.field_70761_aq = this.nycto.field_70177_z = -((float)MathHelper.func_181159_b((double)this.nycto.func_213322_ci().field_72450_a, (double)this.nycto.func_213322_ci().field_72449_c)) * 57.295776f;
                        if (this.nycto.field_70124_G && this.nycto.field_70173_aa > 100) {
                            this.nycto.func_70605_aq().func_75642_a(difference.field_72450_a, difference.field_72450_a, difference.field_72449_c, 1.0);
                        }
                        if (this.nycto.idleTime >= 300 || !this.nycto.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d0)) {
                            this.field_188491_h = MovementController.Action.WAIT;
                        }
                    } else {
                        double d4 = this.nycto.func_70638_az().func_226277_ct_() - this.nycto.func_226277_ct_();
                        double d5 = this.nycto.func_70638_az().func_226281_cx_() - this.nycto.func_226281_cx_();
                        this.nycto.field_70761_aq = this.nycto.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }

        public double func_75638_b() {
            if (this.nycto.func_70638_az() != null && (double)this.nycto.func_70032_d((Entity)this.nycto.func_70638_az()) < 7.0) {
                return 0.6;
            }
            return 0.8;
        }
    }

    static class NyctoRandomFlyGoal
    extends Goal {
        private final NyctoflyEntity nycto;

        public NyctoRandomFlyGoal(NyctoflyEntity bug) {
            this.nycto = bug;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            if (this.nycto.func_70638_az() != null) {
                return false;
            }
            MovementController movementController = this.nycto.func_70605_aq();
            if (!movementController.func_75640_a() && this.nycto.func_70638_az() == null) {
                return true;
            }
            double d0 = movementController.func_179917_d() - this.nycto.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = movementController.func_179919_e() - this.nycto.func_226278_cu_()) * d1 + (d2 = movementController.func_179918_f() - this.nycto.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            double d2;
            double d1;
            Random random = this.nycto.func_70681_au();
            double d0 = this.nycto.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            if (this.nycto.field_70170_p.func_180495_p(new BlockPos(d0, d1 = this.nycto.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f), d2 = this.nycto.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f))).func_204520_s().func_206886_c() == Fluids.field_204546_a) {
                return;
            }
            if (d1 >= 100.0) {
                d1 = this.nycto.func_226278_cu_() - (this.nycto.func_226278_cu_() - 100.0 - (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f));
            }
            if (random.nextFloat() < 0.02f || !this.nycto.field_70170_p.func_226664_a_(this.nycto.func_174813_aQ().func_186662_g(2.0))) {
                this.nycto.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            }
        }
    }

    static class NyctoLookAroundGoal
    extends Goal {
        private final NyctoflyEntity parentEntity;

        public NyctoLookAroundGoal(NyctoflyEntity bug) {
            this.parentEntity = bug;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                Vector3d Vector3d2 = this.parentEntity.func_213322_ci();
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)Vector3d2.field_72450_a, (double)Vector3d2.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity entitylivingbase = this.parentEntity.func_70638_az();
                if ((double)entitylivingbase.func_70032_d((Entity)this.parentEntity) < 4096.0) {
                    double d1 = entitylivingbase.func_226277_ct_() - this.parentEntity.func_226277_ct_();
                    double d2 = entitylivingbase.func_226281_cx_() - this.parentEntity.func_226281_cx_();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }
}

