/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss.summons.ent;

import com.legacy.blue_skies.data.objects.SkiesEntityTags;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntRootEntity;
import com.legacy.blue_skies.entities.passive.SnowOwlEntity;
import com.legacy.blue_skies.items.tools.SkyAxeItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntWallEntity
extends LivingEntity {
    protected static final DataParameter<Boolean> FACING_Z = EntityDataManager.func_187226_a(EntWallEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private LivingEntity caster;
    private UUID casterUuid;
    public int translateAmount = 0;

    public EntWallEntity(EntityType<? extends EntWallEntity> typeIn, World worldIn) {
        super(typeIn, worldIn);
    }

    public EntWallEntity(World worldIn, double x, double y, double z, LivingEntity casterIn) {
        this(SkiesEntityTypes.ENT_WALL, worldIn);
        this.setCaster(casterIn);
        this.field_70759_as = 0.0f;
        this.field_70126_B = 0.0f;
        this.field_70127_C = 0.0f;
        this.field_70125_A = 0.0f;
        this.field_70759_as = 0.0f;
        this.field_70177_z = 0.0f;
        this.func_70107_b(x + 0.5, y, z + 0.5);
        if (casterIn != null && casterIn instanceof StarlitCrusherEntity) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(30.0 + (double)((StarlitCrusherEntity)casterIn).getExtraPlayers() * 10.0);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FACING_Z, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233820_c_, 100.0);
    }

    public void setCaster(LivingEntity livingIn) {
        this.caster = livingIn;
        this.casterUuid = livingIn == null ? null : livingIn.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setFacingZ(compound.func_74767_n("IsFacingZ"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.casterUuid = compound.func_186857_a("OwnerUUID");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsFacingZ", this.isFacingZ());
        if (this.casterUuid != null) {
            compound.func_186854_a("OwnerUUID", this.casterUuid);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70759_as = 0.0f;
        this.field_70126_B = 0.0f;
        this.field_70127_C = 0.0f;
        this.field_70125_A = 0.0f;
        this.field_70759_as = 0.0f;
        this.field_70177_z = 0.0f;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_184185_a(SoundEvents.field_187929_hc, this.func_70599_aP(), super.func_70647_i());
            if (this.field_70170_p instanceof ServerWorld) {
                for (int i = 0; i < 6; ++i) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.starlit_log.func_176223_P()), this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() / 1.5, this.func_226281_cx_(), 20, this.func_174813_aQ().func_216364_b() / 4.0, this.func_174813_aQ().func_216360_c() / 4.0, this.func_174813_aQ().func_216362_d() / 4.0, 0.05);
                }
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        if (source.func_76364_f() instanceof LivingEntity) {
            ItemStack stack = ((LivingEntity)source.func_76364_f()).func_184614_ca();
            if (stack.func_77973_b() instanceof SkyAxeItem) {
                this.playDamageEffect();
                return super.func_70097_a(source, amount);
            }
            if (source.func_76364_f() instanceof PlayerEntity) {
                ((PlayerEntity)source.func_76364_f()).func_146105_b((ITextComponent)new TranslationTextComponent("gui.blue_skies.tooltip.invalid_ent_weapon"), true);
            }
        }
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(entityIn instanceof SnowOwlEntity)) {
            super.func_82167_n(entityIn);
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn instanceof EntRootEntity) {
            return this.func_184191_r((Entity)((EntRootEntity)entityIn).getCaster());
        }
        if (entityIn.func_200600_R().func_220341_a(SkiesEntityTags.NATURE_ALLIES)) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return super.func_184191_r(entityIn) && entityIn != null && entityIn != this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187881_gQ, this.func_184176_by(), this.func_70599_aP(), 0.8f, false);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public void playDamageEffect() {
        if (this.field_70170_p instanceof ServerWorld) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.starlit_log.func_176223_P()), this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() / 1.5, this.func_226281_cx_(), 20, this.func_174813_aQ().func_216364_b() / 4.0, this.func_174813_aQ().func_216360_c() / 4.0, this.func_174813_aQ().func_216362_d() / 4.0, 0.05);
            }
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected float func_70599_aP() {
        return 2.0f;
    }

    public boolean func_241845_aY() {
        return true;
    }

    public AxisAlignedBB func_174813_aQ() {
        boolean isx = !this.isFacingZ();
        float x = isx ? 0.25f : 1.5f;
        float z = isx ? 1.5f : 0.25f;
        AxisAlignedBB boundingBox = new AxisAlignedBB(this.func_226277_ct_() - (double)x, this.func_226278_cu_(), this.func_226281_cx_() - (double)z, this.func_226277_ct_() + (double)x, this.func_226278_cu_() + 3.0, this.func_226281_cx_() + (double)z);
        return boundingBox;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean isFacingZ() {
        return (Boolean)this.field_70180_af.func_187225_a(FACING_Z);
    }

    public void setFacingZ(boolean facingz) {
        this.field_70180_af.func_187227_b(FACING_Z, (Object)facingz);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }
}

