/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.entities.ai.FollowDirectlyTemptGoal;
import com.legacy.blue_skies.entities.util.base.SkiesAnimalEntity;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class AzulfoEntity
extends SkiesAnimalEntity {
    private AzulfoEntity herdLeader;
    private int herdSize = 1;
    public int attackTimer = 11;

    public AzulfoEntity(EntityType<? extends AzulfoEntity> type, World world) {
        super(type, world);
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.7f, false){

            public boolean func_75250_a() {
                return !AzulfoEntity.this.func_70631_g_() && super.func_75250_a();
            }

            protected double func_179512_a(LivingEntity attackTarget) {
                return super.func_179512_a(attackTarget) * (double)0.6f;
            }
        });
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowDirectlyTemptGoal((CreatureEntity)this, 1.4, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{SkiesItems.pine_fruit})));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowHerdLeaderGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.3));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.25, 0.01f){

            public boolean func_75250_a() {
                return (!AzulfoEntity.this.hasHerdLeader() || AzulfoEntity.this.isHerdLeader()) && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, (double)0.15f).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (!this.func_70631_g_()) {
            if (spawnDataIn == null) {
                spawnDataIn = new HerdData(this);
            } else {
                this.joinHerd(((HerdData)spawnDataIn).herdLeader);
            }
        }
        return spawnDataIn;
    }

    public void func_70636_d() {
        List list;
        super.func_70636_d();
        if (this.attackTimer < 11) {
            ++this.attackTimer;
        }
        if (this.isHerdLeader() && this.field_70170_p.field_73012_v.nextInt(200) == 1 && (list = this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0))).size() <= 1) {
            this.herdSize = 1;
        }
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_AZULFO_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_AZULFO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_AZULFO_DEATH;
    }

    @Override
    public Item getMainBreedingItem() {
        return SkiesItems.pine_fruit;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public AzulfoEntity createChild(AgeableEntity ageable) {
        return (AzulfoEntity)SkiesEntityTypes.AZULFO.func_200721_a(this.field_70170_p);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return this.func_70631_g_() ? 0.8f : 1.8f;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.attackTimer >= 11) {
            this.attackTimer = 0;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        }
        return entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 3.0f);
    }

    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public AzulfoEntity joinHerd(AzulfoEntity herdLeaderIn) {
        this.herdLeader = herdLeaderIn;
        herdLeaderIn.increaseHerdSize();
        return herdLeaderIn;
    }

    public void leaveHerd() {
        this.herdLeader.decreaseHerdSize();
        this.herdLeader = null;
    }

    private void increaseHerdSize() {
        ++this.herdSize;
    }

    private void decreaseHerdSize() {
        --this.herdSize;
    }

    public boolean canHerdGrow() {
        return this.isHerdLeader() && this.herdSize < this.getMaxHerdSize();
    }

    public int getMaxSpawnedInChunk() {
        return this.getMaxHerdSize();
    }

    public int getMaxHerdSize() {
        return super.func_70641_bl();
    }

    public boolean isHerdLeader() {
        return this.herdSize > 1;
    }

    public boolean inRangeOfHerdLeader() {
        return (double)this.func_70032_d((Entity)this.herdLeader) <= 20.0;
    }

    public void moveToHerdLeader() {
        if (this.isPosTooFarFromLeader(this.func_233580_cy_())) {
            this.func_70661_as().func_75497_a((Entity)this.herdLeader, 1.45);
        }
    }

    public boolean hasHerdLeader() {
        return this.herdLeader != null && this.herdLeader.func_70089_S();
    }

    public boolean isPosTooFarFromLeader(BlockPos pos) {
        return this.hasHerdLeader() && (double)EntityUtil.getDistanceToPos((Vector3i)pos, (Vector3i)this.herdLeader.func_233580_cy_()) > 12.0;
    }

    public void getHerdMembers(Stream<AzulfoEntity> membersIn) {
        membersIn.limit(this.getMaxHerdSize() - this.herdSize).filter(p_212801_1_ -> p_212801_1_ != this).forEach(member -> {
            if (!member.func_70631_g_()) {
                member.joinHerd(this);
            }
        });
    }

    public class FollowHerdLeaderGoal
    extends Goal {
        private final AzulfoEntity taskOwner;
        private int navigateTimer;
        private int cooldown;

        public FollowHerdLeaderGoal(AzulfoEntity taskOwnerIn) {
            this.taskOwner = taskOwnerIn;
            this.cooldown = this.getNewCooldown(taskOwnerIn);
        }

        protected int getNewCooldown(AzulfoEntity taskOwnerIn) {
            return 200 + taskOwnerIn.func_70681_au().nextInt(200) % 20;
        }

        public boolean func_75250_a() {
            if (this.taskOwner.isHerdLeader() || this.taskOwner.func_70631_g_()) {
                return false;
            }
            if (this.taskOwner.hasHerdLeader()) {
                return true;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.cooldown = this.getNewCooldown(this.taskOwner);
            Predicate<AzulfoEntity> canJoinHerd = azulfo -> azulfo.canHerdGrow() || !azulfo.hasHerdLeader();
            List list = this.taskOwner.field_70170_p.func_175647_a(((Object)((Object)this.taskOwner)).getClass(), this.taskOwner.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0), canJoinHerd);
            AzulfoEntity azulfos = list.stream().filter(AzulfoEntity::canHerdGrow).findAny().orElse(this.taskOwner);
            azulfos.getHerdMembers(list.stream().filter(azulfo -> !azulfo.hasHerdLeader()));
            return this.taskOwner.hasHerdLeader();
        }

        public boolean func_75253_b() {
            return this.taskOwner.hasHerdLeader() && this.taskOwner.inRangeOfHerdLeader();
        }

        public void func_75249_e() {
            this.navigateTimer = 0;
        }

        public void func_75251_c() {
            this.taskOwner.leaveHerd();
        }

        public void func_75246_d() {
            if (--this.navigateTimer <= 0) {
                this.navigateTimer = 10;
                this.taskOwner.moveToHerdLeader();
            }
        }
    }

    public static class HerdData
    extends AgeableEntity.AgeableData
    implements ILivingEntityData {
        public final AzulfoEntity herdLeader;

        public HerdData(AzulfoEntity herdLeaderIn) {
            super(true);
            this.herdLeader = herdLeaderIn;
        }
    }
}

