/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.items.util.IRarityItem;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;

public class BossLootBagItem
extends LootBagItem {
    private final Supplier<EntityType<?>> boss;

    public BossLootBagItem(Item.Properties properties, Supplier<EntityType<?>> boss) {
        super(properties);
        this.boss = boss;
    }

    @Override
    public <T extends Item> void fillItemCategoryWithRarity(ItemGroup group, NonNullList<ItemStack> stacks, T item) {
        String bossName = this.boss.get().getRegistryName().func_110623_a();
        for (IRarityItem.SkiesRarity rarity : IRarityItem.SkiesRarity.values()) {
            ItemStack stack = new ItemStack(item);
            ((IRarityItem)item).setRarityTag(stack, rarity);
            this.setLootTable(stack, BlueSkies.locate("loot_bags/" + bossName + "/" + (Object)((Object)rarity)));
            stacks.add((Object)stack);
        }
    }

    @Override
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (group == ItemGroup.field_78027_g) {
            this.fillItemCategoryWithRarity(group, stacks, this);
        } else if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            String bossName = this.boss.get().getRegistryName().func_110623_a();
            this.setRarityTag(stack, IRarityItem.SkiesRarity.COMMON);
            this.setLootTable(stack, BlueSkies.locate("loot_bags/" + bossName + "/" + (Object)((Object)IRarityItem.SkiesRarity.COMMON)));
            stacks.add((Object)stack);
        }
    }
}

