/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.buckets;

import com.legacy.blue_skies.entities.passive.fish.JellyDrifterEntity;
import com.legacy.blue_skies.entities.util.interfaces.IVentiumCatchable;
import com.legacy.blue_skies.items.buckets.VentiumBucketItem;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.util.StringUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VentiumFishBucketItem
extends VentiumBucketItem {
    private final Supplier<? extends EntityType<?>> fishType;

    public VentiumFishBucketItem(Supplier<? extends EntityType<? extends LivingEntity>> fishTypeIn, Supplier<? extends Fluid> fluidIn, Item.Properties builder) {
        super(fluidIn, builder);
        this.fishType = fishTypeIn;
    }

    public void func_203792_a(World worldIn, ItemStack stack, BlockPos pos) {
        Entity entity;
        if (!worldIn.field_72995_K && worldIn instanceof ServerWorld && (entity = this.getFishType().func_220331_a((ServerWorld)worldIn, stack, (PlayerEntity)null, pos, SpawnReason.BUCKET, true, false)) != null && entity instanceof IVentiumCatchable) {
            ((IVentiumCatchable)entity).setFromVentiumBucket(true);
        }
    }

    protected void func_203791_b(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_203819_X, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT compoundnbt;
        if (this.getFishType() == SkiesEntityTypes.JELLY_DRIFTER && (compoundnbt = stack.func_77978_p()) != null && compoundnbt.func_150297_b("Color", 99)) {
            byte i = compoundnbt.func_74771_c("Color");
            TextFormatting[] formatting = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
            tooltip.add((ITextComponent)new TranslationTextComponent("entity.blue_skies.jelly_drifter.color." + StringUtil.toLower(JellyDrifterEntity.Colors.byId(i).name())).func_240701_a_(formatting));
        }
    }

    protected EntityType<?> getFishType() {
        return this.fishType.get();
    }
}

