/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools.weapons;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.legacy.blue_skies.items.tools.weapons.SkySwordItem;
import com.legacy.blue_skies.items.util.ToolUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InfusedArcSwordItem
extends SkySwordItem {
    protected AttributeModifier INFUSED_DAMAGE = new AttributeModifier(field_111210_e, "Infused damage modifier", (double)(this.func_200894_d() * 0.7f), AttributeModifier.Operation.ADDITION);
    private byte maxInfusedHits = (byte)30;

    public InfusedArcSwordItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
    }

    public static byte getInfusedHits(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt.func_74771_c("InfusedHits");
    }

    public static void setInfusedHits(ItemStack stack, byte hitsIn) {
        CompoundNBT compoundnbt = stack.func_196082_o();
        compoundnbt.func_74774_a("InfusedHits", hitsIn);
    }

    public static int getInfusedCooldown(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt.func_74762_e("InfusedCooldown");
    }

    public static void setInfusedCooldown(ItemStack stack, int cooldownIn) {
        CompoundNBT compoundnbt = stack.func_196082_o();
        compoundnbt.func_74768_a("InfusedCooldown", cooldownIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entity, int itemSlot, boolean isSelected) {
        if (InfusedArcSwordItem.getInfusedCooldown(stack) > 0 && entity.field_70173_aa % 20 == 0) {
            InfusedArcSwordItem.setInfusedCooldown(stack, InfusedArcSwordItem.getInfusedCooldown(stack) - 1);
            if (InfusedArcSwordItem.getInfusedCooldown(stack) == 0) {
                entity.field_70170_p.func_217384_a((PlayerEntity)null, entity, SoundEvents.field_206938_K, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof PlayerEntity) {
            if (InfusedArcSwordItem.getInfusedCooldown(stack) > 0) {
                return false;
            }
            if (InfusedArcSwordItem.getInfusedHits(stack) < this.maxInfusedHits) {
                InfusedArcSwordItem.setInfusedHits(stack, (byte)(InfusedArcSwordItem.getInfusedHits(stack) + 1));
            } else {
                attacker.field_70170_p.func_217384_a(null, (Entity)attacker, SoundEvents.field_206940_M, SoundCategory.PLAYERS, 1.0f, 1.0f);
                InfusedArcSwordItem.setInfusedCooldown(stack, this.maxInfusedHits * 2);
                InfusedArcSwordItem.setInfusedHits(stack, (byte)0);
            }
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            if (InfusedArcSwordItem.getInfusedCooldown(stack) > 0) {
                multimap.put((Object)Attributes.field_233823_f_, (Object)this.INFUSED_DAMAGE);
            } else {
                multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.func_200894_d(), AttributeModifier.Operation.ADDITION));
            }
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)ToolUtils.getAttackSpeed(this.attackSpeed, stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> lore, ITooltipFlag flagIn) {
        if (InfusedArcSwordItem.getInfusedCooldown(stack) <= 0) {
            lore.add((ITextComponent)new TranslationTextComponent(TextFormatting.GRAY + "Charged Hits Remaining: " + (this.maxInfusedHits + 1 - InfusedArcSwordItem.getInfusedHits(stack))));
        } else {
            lore.add((ITextComponent)new TranslationTextComponent(TextFormatting.AQUA + "Time Remaining: " + InfusedArcSwordItem.getInfusedCooldown(stack)));
        }
    }
}

