/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools.weapons;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.legacy.blue_skies.entities.projectile.SpearEntity;
import com.legacy.blue_skies.items.util.IFalsiteItem;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.StringUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.enchantment.LoyaltyEnchantment;
import net.minecraft.enchantment.PiercingEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpearItem
extends Item
implements IVanishable,
IFalsiteItem {
    private final Supplier<Item> stick;

    public SpearItem(Item.Properties builder, Supplier<Item> stick) {
        super(builder);
        this.stick = stick;
    }

    public Item getStick() {
        return this.stick.get();
    }

    public boolean func_195938_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    @Override
    public boolean isFalsiteCompatible(ItemStack stack) {
        return true;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.SPEAR;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            int i = this.func_77626_a(stack) - timeLeft;
            if (i >= 10) {
                if (!world.field_72995_K) {
                    stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(entityLiving.func_184600_cs()));
                    SpearEntity spearEntity = new SpearEntity(world, (LivingEntity)player, stack);
                    int piercingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)stack);
                    if (piercingLevel > 0) {
                        spearEntity.func_213872_b((byte)piercingLevel);
                    }
                    spearEntity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.5f, 1.0f);
                    if (player.func_184812_l_()) {
                        spearEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                    }
                    world.func_217376_c((Entity)spearEntity);
                    world.func_217384_a((PlayerEntity)null, (Entity)spearEntity, player.func_208600_a((ITag)FluidTags.field_206959_a) ? SkiesSounds.ITEM_SPEAR_THROW_UNDERWATER : SkiesSounds.ITEM_SPEAR_THROW, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    if (!player.func_184812_l_()) {
                        player.field_71071_by.func_184437_d(stack);
                    }
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() >= stack.func_77958_k()) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)stack);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.func_185887_b((IBlockReader)worldIn, pos) != 0.0) {
            stack.func_222118_a(2, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolUtils.getMaxDurability(super.getMaxDamage(stack), this.getStick());
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        HashMultimap attributeMap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", 3.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)ToolUtils.getAttackSpeed(-2.9f, this.getStick()), AttributeModifier.Operation.ADDITION));
            attributeMap = builder.build();
        }
        return attributeMap;
    }

    public int func_77619_b() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> lore, ITooltipFlag flag) {
        if (this == SkiesItems.soulbound_spear) {
            lore.add((ITextComponent)new StringTextComponent(StringUtil.getAbilityText("gui.blue_skies.item.ability.soulbound")));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment instanceof LoyaltyEnchantment || enchantment instanceof PiercingEnchantment) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

