/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.mod_compat.jei;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.gui.container.AlchemyTableContainer;
import com.legacy.blue_skies.client.gui.container.HorizoniteForgeContainer;
import com.legacy.blue_skies.client.gui.container.SnowcapOvenContainer;
import com.legacy.blue_skies.client.gui.screen.ArcsScreen;
import com.legacy.blue_skies.client.gui.screen.HorizoniteForgeScreen;
import com.legacy.blue_skies.client.gui.screen.SnowcapOvenScreen;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.mod_compat.jei.JEIOverlayWrapper;
import com.legacy.blue_skies.mod_compat.jei.category.AlchemyCategory;
import com.legacy.blue_skies.mod_compat.jei.category.HorizoniteForgeFuelCategory;
import com.legacy.blue_skies.mod_compat.jei.category.SnowcapMushroomFreezingCategory;
import com.legacy.blue_skies.mod_compat.jei.category.SnowcapOvenFreezingCategory;
import com.legacy.blue_skies.mod_compat.jei.helpers.BlockIngredientHelper;
import com.legacy.blue_skies.mod_compat.jei.renderers.BlockIngredientRenderer;
import com.legacy.blue_skies.registries.SkiesBlocks;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class SkiesJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = BlueSkies.locate("jei_plugin");
    public static final IIngredientType<BlockState> BLOCKSTATE = () -> BlockState.class;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addGuiContainerHandler(InventoryScreen.class, new JEIOverlayWrapper());
        reg.addGuiContainerHandler(ArcsScreen.class, new JEIOverlayWrapper());
        reg.addGuiContainerHandler(CreativeScreen.class, new JEIOverlayWrapper());
        reg.addRecipeClickArea(HorizoniteForgeScreen.class, 78, 32, 28, 23, new ResourceLocation[]{HorizoniteForgeFuelCategory.ID, VanillaRecipeCategoryUid.FURNACE});
        reg.addRecipeClickArea(SnowcapOvenScreen.class, 78, 16, 28, 49, new ResourceLocation[]{SnowcapOvenFreezingCategory.ID, VanillaRecipeCategoryUid.FURNACE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration reg) {
        reg.addRecipeTransferHandler(HorizoniteForgeContainer.class, VanillaRecipeCategoryUid.FURNACE, 0, 1, 3, 36);
        reg.addRecipeTransferHandler(HorizoniteForgeContainer.class, HorizoniteForgeFuelCategory.ID, 1, 1, 3, 36);
        reg.addRecipeTransferHandler(SnowcapOvenContainer.class, VanillaRecipeCategoryUid.FURNACE, 0, 1, 3, 36);
        reg.addRecipeTransferHandler(SnowcapOvenContainer.class, SnowcapOvenFreezingCategory.ID, 1, 1, 3, 36);
        reg.addRecipeTransferHandler(AlchemyTableContainer.class, AlchemyCategory.ID, 0, 2, 3, 36);
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new SnowcapMushroomFreezingCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new HorizoniteForgeFuelCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new SnowcapOvenFreezingCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new AlchemyCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        reg.addRecipes(SnowcapMushroomFreezingCategory.getAllRecipes(), SnowcapMushroomFreezingCategory.ID);
        reg.addRecipes(BlueSkiesData.HORIZONITE_FORGE_FUEL.getData().values(), HorizoniteForgeFuelCategory.ID);
        reg.addRecipes(BlueSkiesData.SNOWCAP_OVEN_FREEZING.getData().values(), SnowcapOvenFreezingCategory.ID);
        reg.addRecipes(BlueSkiesData.ALCHEMY_RECIPES.getData().values(), AlchemyCategory.ID);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SkiesBlocks.snowcap_mushroom), new ResourceLocation[]{SnowcapMushroomFreezingCategory.ID});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SkiesBlocks.horizonite_forge), new ResourceLocation[]{HorizoniteForgeFuelCategory.ID});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SkiesBlocks.snowcap_oven), new ResourceLocation[]{SnowcapOvenFreezingCategory.ID});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SkiesBlocks.alchemy_table), new ResourceLocation[]{AlchemyCategory.ID});
    }

    public void registerIngredients(IModIngredientRegistration reg) {
        List blocks = ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b instanceof AbstractFireBlock).map(Block::func_176223_P).collect(Collectors.toList());
        BlockIngredientRenderer blockIngredientRenderer = new BlockIngredientRenderer();
        BlockIngredientHelper blockIngredientHelper = new BlockIngredientHelper();
        reg.register(BLOCKSTATE, blocks, (IIngredientHelper)blockIngredientHelper, (IIngredientRenderer)blockIngredientRenderer);
    }
}

