/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.c_to_s;

import com.legacy.blue_skies.capability.SkiesPlayer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpawnSupporterPetPacket {
    private byte petID;
    private boolean petEnabled;
    private boolean petAudible;
    private String petName;
    private byte styleID;

    public SpawnSupporterPetPacket(byte petIdIn, boolean petEnabledIn, boolean petAudibleIn, String petNameIn, byte styleIdIn) {
        this.petID = petIdIn;
        this.petEnabled = petEnabledIn;
        this.petAudible = petAudibleIn;
        this.petName = petNameIn;
        this.styleID = styleIdIn;
    }

    public static void encoder(SpawnSupporterPetPacket packet, PacketBuffer buff) {
        buff.writeByte((int)packet.petID);
        buff.writeBoolean(packet.petEnabled);
        buff.writeBoolean(packet.petAudible);
        buff.func_180714_a(packet.petName);
        buff.writeByte((int)packet.styleID);
    }

    public static SpawnSupporterPetPacket decoder(PacketBuffer buff) {
        return new SpawnSupporterPetPacket(buff.readByte(), buff.readBoolean(), buff.readBoolean(), buff.func_150789_c(16), buff.readByte());
    }

    public static void handler(SpawnSupporterPetPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> SpawnSupporterPetPacket.handlePacket(packet, (PlayerEntity)((NetworkEvent.Context)context.get()).getSender()));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(SpawnSupporterPetPacket packet, PlayerEntity player) {
        SkiesPlayer.ifPresent(player, skyPlayer -> {
            skyPlayer.setSupporterPetID(packet.petID);
            skyPlayer.setSupporterPetEnabled(packet.petEnabled);
            skyPlayer.setSupporterPetAudible(packet.petAudible);
            skyPlayer.setSupporterPetName(packet.petName);
            skyPlayer.setSupporterStyleID(packet.styleID);
        });
    }
}

