/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.capability.SkiesPlayer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetInvisiblePacket {
    private boolean value;
    private byte mode;
    private UUID uuid;

    public SetInvisiblePacket(boolean valueIn, byte mode, UUID uuid) {
        this.value = valueIn;
        this.mode = mode;
        this.uuid = uuid;
    }

    public static void encoder(SetInvisiblePacket packet, PacketBuffer buff) {
        buff.writeBoolean(packet.value);
        buff.writeByte((int)packet.mode);
        buff.func_179252_a(packet.uuid);
    }

    public static SetInvisiblePacket decoder(PacketBuffer buff) {
        return new SetInvisiblePacket(buff.readBoolean(), buff.readByte(), buff.func_179253_g());
    }

    public static void handler(SetInvisiblePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SetInvisiblePacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SetInvisiblePacket packet) {
        PlayerEntity player = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_217371_b(packet.uuid);
        if (packet.mode == 0) {
            if (player != null) {
                player.func_82142_c(packet.value);
            }
        } else if (packet.mode == 1) {
            SkiesPlayer.ifPresent(player, skiesPlayer -> skiesPlayer.setFullDuskInvis(packet.value));
        }
    }
}

