/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.util.LogicUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpawnParticlePacket {
    private final byte id;
    private final float x;
    private final float y;
    private final float z;

    public SpawnParticlePacket(byte id, BlockPos pos) {
        this.id = id;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public SpawnParticlePacket(byte id, Vector3d vec) {
        this.id = id;
        this.x = (float)vec.field_72450_a;
        this.y = (float)vec.field_72448_b;
        this.z = (float)vec.field_72449_c;
    }

    public static void encoder(SpawnParticlePacket packet, PacketBuffer buff) {
        buff.writeByte((int)packet.id);
        buff.writeFloat(packet.x);
        buff.writeFloat(packet.y);
        buff.writeFloat(packet.z);
    }

    public static SpawnParticlePacket decoder(PacketBuffer buff) {
        return new SpawnParticlePacket(buff.readByte(), new Vector3d((double)buff.readFloat(), (double)buff.readFloat(), (double)buff.readFloat()));
    }

    public static void handler(SpawnParticlePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SpawnParticlePacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SpawnParticlePacket packet) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        switch (packet.id) {
            case 0: {
                double spread = 0.3f;
                double speed = 0.02f;
                for (int i = 0; i < 6; ++i) {
                    double x = LogicUtil.plusOrMinus((double)(packet.x + 0.5f), spread, world.field_73012_v);
                    double y = LogicUtil.plusOrMinus((double)(packet.y + 0.5f), spread, world.field_73012_v);
                    double z = LogicUtil.plusOrMinus((double)(packet.z + 0.5f), spread, world.field_73012_v);
                    double dx = LogicUtil.plusOrMinus(speed, world.field_73012_v);
                    double dy = LogicUtil.plusOrMinus(speed, world.field_73012_v);
                    double dz = LogicUtil.plusOrMinus(speed, world.field_73012_v);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x, y, z, dx, dy, dz);
                }
                break;
            }
            case 1: {
                double speed = 0.02f;
                for (int i = 0; i < 1; ++i) {
                    double x = LogicUtil.plusOrMinus(packet.x, 0.3f, world.field_73012_v);
                    double y = LogicUtil.plusOrMinus(packet.y + 0.25f, 0.5f, world.field_73012_v);
                    double z = LogicUtil.plusOrMinus(packet.z, 0.3f, world.field_73012_v);
                    double dx = LogicUtil.plusOrMinus(speed, world.field_73012_v);
                    double dy = LogicUtil.plusOrMinus(speed, world.field_73012_v);
                    double dz = LogicUtil.plusOrMinus(speed, world.field_73012_v);
                    world.func_195594_a((IParticleData)SkiesParticles.DUSK_SMOKE, x, y, z, dx, dy, dz);
                }
                break;
            }
            default: {
                BlueSkies.LOGGER.warn("Trying to spawn particle with unknown id: " + packet.id);
            }
        }
    }
}

