/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.capability.SkiesPlayer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateBlueLorePacket {
    private boolean usedLore;

    public UpdateBlueLorePacket(boolean usedLore) {
        this.usedLore = usedLore;
    }

    public static void encoder(UpdateBlueLorePacket packet, PacketBuffer buff) {
        buff.writeBoolean(packet.usedLore);
    }

    public static UpdateBlueLorePacket decoder(PacketBuffer buff) {
        return new UpdateBlueLorePacket(buff.readBoolean());
    }

    public static void handler(UpdateBlueLorePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UpdateBlueLorePacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(UpdateBlueLorePacket packet) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        SkiesPlayer.ifPresent(player, skiesPlayer -> skiesPlayer.setUsedBlueLore(packet.usedLore));
    }
}

