/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.Sets;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.providers.SkiesBiomeProv;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesRegistry;
import com.legacy.blue_skies.world.everbright.biome.provider.EverbrightBiomeProvider;
import com.legacy.blue_skies.world.everbright.biome.surface_builder.CoarseDirtMixSurfaceBuilder;
import com.legacy.blue_skies.world.everdawn.biome.provider.EverdawnBiomeProvider;
import com.legacy.blue_skies.world.everdawn.biome.surface_builder.CrystalRoughsSurfaceBuilder;
import com.legacy.blue_skies.world.everdawn.biome.surface_builder.MoonlitReservoirSurfaceBuilder;
import com.legacy.structure_gel.registrars.BiomeRegistrar;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class SkiesBiomes {
    public static final BiomeRegistrar CALMING_SKIES = new BiomeRegistrar(BlueSkies.locate("calming_skies"), SkiesBiomeProv.Makers::calmingSkies).handle();
    public static final BiomeRegistrar BRIGHTLANDS = new BiomeRegistrar(BlueSkies.locate("brightlands"), SkiesBiomeProv.Makers::brightlands).handle();
    public static final BiomeRegistrar SLUSHLANDS = new BiomeRegistrar(BlueSkies.locate("slushlands"), SkiesBiomeProv.Makers::slushlands).handle();
    public static final BiomeRegistrar FROSTBITTEN_FOREST = new BiomeRegistrar(BlueSkies.locate("frostbitten_forest"), () -> SkiesBiomeProv.Makers.frostbittenForest(false)).handle();
    public static final BiomeRegistrar FROSTBITTEN_FOREST_CLEARING = new BiomeRegistrar(BlueSkies.locate("frostbitten_forest_clearing"), () -> SkiesBiomeProv.Makers.frostbittenForest(true)).handle();
    public static final BiomeRegistrar PEEKING_OCEAN = new BiomeRegistrar(BlueSkies.locate("peeking_ocean"), () -> SkiesBiomeProv.Makers.peekingOcean(false, false)).handle();
    public static final BiomeRegistrar DEEP_PEEKING_OCEAN = new BiomeRegistrar(BlueSkies.locate("deep_peeking_ocean"), () -> SkiesBiomeProv.Makers.peekingOcean(true, false)).handle();
    public static final BiomeRegistrar BRUMBLE_FOREST = new BiomeRegistrar(BlueSkies.locate("brumble_forest"), () -> SkiesBiomeProv.Makers.peekingOcean(true, true)).handle();
    public static final BiomeRegistrar MIDDAY_SHORE = new BiomeRegistrar(BlueSkies.locate("midday_shore"), SkiesBiomeProv.Makers::middayShore).handle();
    public static final BiomeRegistrar SNOW_COVERED_PINES = new BiomeRegistrar(BlueSkies.locate("snow_covered_pines"), SkiesBiomeProv.Makers::snowCoveredPines).handle();
    public static final BiomeRegistrar BRISK_MEADOW = new BiomeRegistrar(BlueSkies.locate("brisk_meadow"), SkiesBiomeProv.Makers::briskMeadow).handle();
    public static final BiomeRegistrar POLAR_HIGHLAND = new BiomeRegistrar(BlueSkies.locate("polar_highland"), SkiesBiomeProv.Makers::polarHighland).handle();
    public static final BiomeRegistrar UNORTHODOX_VALLEY = new BiomeRegistrar(BlueSkies.locate("unorthodox_valley"), SkiesBiomeProv.Makers::unorthodoxValley).handle();
    public static final BiomeRegistrar SHADED_WOODLANDS = new BiomeRegistrar(BlueSkies.locate("shaded_woodlands"), SkiesBiomeProv.Makers::shadedWoodlands).handle();
    public static final BiomeRegistrar CRYSTAL_DUNES = new BiomeRegistrar(BlueSkies.locate("crystal_dunes"), () -> SkiesBiomeProv.Makers.crystalDunes(false)).handle();
    public static final BiomeRegistrar CRYSTAL_DUNES_SPIKES = new BiomeRegistrar(BlueSkies.locate("crystal_dunes_spikes"), () -> SkiesBiomeProv.Makers.crystalDunes(true)).handle();
    public static final BiomeRegistrar SUNSET_MAPLE_FOREST = new BiomeRegistrar(BlueSkies.locate("sunset_maple_forest"), SkiesBiomeProv.Makers::sunsetMapleForest).handle();
    public static final BiomeRegistrar RISING_CREEK = new BiomeRegistrar(BlueSkies.locate("rising_creek"), SkiesBiomeProv.Makers::risingCreek).handle();
    public static final BiomeRegistrar MOONLIT_RESERVOIR = new BiomeRegistrar(BlueSkies.locate("moonlit_reservoir"), SkiesBiomeProv.Makers::moonlitReservoir).handle();
    public static final BiomeRegistrar CRYSTAL_ROUGHS = new BiomeRegistrar(BlueSkies.locate("crystal_roughs"), SkiesBiomeProv.Makers::crystalRoughs).handle();
    public static final BiomeRegistrar SEARING_GRASSLAND = new BiomeRegistrar(BlueSkies.locate("searing_grassland"), SkiesBiomeProv.Makers::searingGrassland).handle();
    public static final BiomeRegistrar CRESCENT_ORCHARD = new BiomeRegistrar(BlueSkies.locate("crescent_orchard"), () -> SkiesBiomeProv.Makers.crescentOrchard(false)).handle();
    public static final BiomeRegistrar CRESCENT_ORCHARD_LAKE = new BiomeRegistrar(BlueSkies.locate("crescent_orchard_lake"), () -> SkiesBiomeProv.Makers.crescentOrchard(true)).handle();
    public static final Set<Biome> EVERBRIGHT_BIOMES = Sets.newHashSet();
    public static final Set<Biome> EVERDAWN_BIOMES = Sets.newHashSet();
    public static final Set<RegistryKey<Biome>> EVERBRIGHT_KEYS = Sets.newHashSet();
    public static final Set<RegistryKey<Biome>> EVERDAWN_KEYS = Sets.newHashSet();
    public static final Set<ResourceLocation> EVERBRIGHT_LOCATIONS = Sets.newHashSet();
    public static final Set<ResourceLocation> EVERDAWN_LOCATIONS = Sets.newHashSet();
    public static final Set<RegistryKey<Biome>> SANDSTORM_APPLICABLE = Sets.newHashSet();

    public static void init(RegistryEvent.Register<Biome> event) {
        IForgeRegistry registry = event.getRegistry();
        SkiesBiomes.register((IForgeRegistry<Biome>)registry, Arrays.asList(CALMING_SKIES, BRIGHTLANDS, SLUSHLANDS, FROSTBITTEN_FOREST, PEEKING_OCEAN, MIDDAY_SHORE), true);
        SkiesBiomes.register((IForgeRegistry<Biome>)registry, Arrays.asList(UNORTHODOX_VALLEY, SHADED_WOODLANDS, CRYSTAL_DUNES, SUNSET_MAPLE_FOREST, RISING_CREEK), false);
        SkiesBiomes.register((IForgeRegistry<Biome>)registry, Arrays.asList(SNOW_COVERED_PINES, DEEP_PEEKING_OCEAN, BRISK_MEADOW, POLAR_HIGHLAND, FROSTBITTEN_FOREST_CLEARING, BRUMBLE_FOREST), true);
        SkiesBiomes.register((IForgeRegistry<Biome>)registry, Arrays.asList(MOONLIT_RESERVOIR, CRYSTAL_ROUGHS, SEARING_GRASSLAND, CRESCENT_ORCHARD, CRESCENT_ORCHARD_LAKE, CRYSTAL_DUNES_SPIKES), false);
        Registry.func_218325_a((Registry)Registry.field_239689_aA_, (String)"everbright", EverbrightBiomeProvider.CODEC);
        Registry.func_218325_a((Registry)Registry.field_239689_aA_, (String)"everdawn", EverdawnBiomeProvider.CODEC);
        SANDSTORM_APPLICABLE.add((RegistryKey<Biome>)CRYSTAL_DUNES.getKey());
        SANDSTORM_APPLICABLE.add((RegistryKey<Biome>)CRYSTAL_DUNES_SPIKES.getKey());
    }

    public static void register(IForgeRegistry<Biome> registry, List<BiomeRegistrar> biome, boolean inEverbright) {
        biome.forEach(b -> {
            b.handleForge(registry);
            if (inEverbright) {
                EVERBRIGHT_BIOMES.add(b.getBiome());
                EVERBRIGHT_KEYS.add((RegistryKey<Biome>)b.getKey());
                EVERBRIGHT_LOCATIONS.add(b.getName());
            } else {
                EVERDAWN_BIOMES.add(b.getBiome());
                EVERDAWN_KEYS.add((RegistryKey<Biome>)b.getKey());
                EVERDAWN_LOCATIONS.add(b.getName());
            }
        });
    }

    public static class SurfaceBuilders {
        public static final CrystalRoughsSurfaceBuilder ROUGHS = new CrystalRoughsSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_);
        public static final CoarseDirtMixSurfaceBuilder TURQUOISE_COARSE_MIX = new CoarseDirtMixSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_);
        public static final MoonlitReservoirSurfaceBuilder RESERVOIR = new MoonlitReservoirSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_);
        public static final SurfaceBuilderConfig TURQUOISE_GRASS_DIRT_SAND_CONFIG = new SurfaceBuilderConfig(SkiesBlocks.turquoise_grass_block.func_176223_P(), SkiesBlocks.turquoise_dirt.func_176223_P(), SkiesBlocks.midnight_sand.func_176223_P());
        public static final SurfaceBuilderConfig LUNAR_GRASS_DIRT_SAND_CONFIG = new SurfaceBuilderConfig(SkiesBlocks.lunar_grass_block.func_176223_P(), SkiesBlocks.lunar_dirt.func_176223_P(), SkiesBlocks.crystal_sand.func_176223_P());
        public static final SurfaceBuilderConfig MIDNIGHT_SAND_SANDSTONE_SAND_CONFIG = new SurfaceBuilderConfig(SkiesBlocks.midnight_sand.func_176223_P(), SkiesBlocks.midnight_sandstone.func_176223_P(), SkiesBlocks.midnight_sand.func_176223_P());
        public static final SurfaceBuilderConfig CRYSTAL_SAND_SANDSTONE_DIRT_CONFIG = new SurfaceBuilderConfig(SkiesBlocks.crystal_sand.func_176223_P(), SkiesBlocks.crystal_sandstone.func_176223_P(), SkiesBlocks.lunar_dirt.func_176223_P());
        public static final SurfaceBuilderConfig TURQUOISE_COARSE_DIRT_SAND_CONFIG = new SurfaceBuilderConfig(SkiesBlocks.coarse_turquoise_dirt.func_176223_P(), SkiesBlocks.turquoise_dirt.func_176223_P(), SkiesBlocks.midnight_sand.func_176223_P());
        public static final SurfaceBuilderConfig LUNAR_COARSE_DIRT_SAND_CONFIG = new SurfaceBuilderConfig(SkiesBlocks.coarse_lunar_dirt.func_176223_P(), SkiesBlocks.lunar_dirt.func_176223_P(), SkiesBlocks.crystal_sand.func_176223_P());
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> TURQUOISE_GRASS_SURFACE_BUILDER = SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)TURQUOISE_GRASS_DIRT_SAND_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> LUNAR_GRASS_SURFACE_BUILDER = SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)LUNAR_GRASS_DIRT_SAND_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> MIDNIGHT_SAND_SURFACE_BUILDER = SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)MIDNIGHT_SAND_SANDSTONE_SAND_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> CRYSTAL_SAND_SURFACE_BUILDER = SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)CRYSTAL_SAND_SANDSTONE_DIRT_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> CRYSTAL_ROUGHS_SURFACE_BUILDER = ROUGHS.func_242929_a((ISurfaceBuilderConfig)LUNAR_GRASS_DIRT_SAND_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> COARSE_TURQUOISE_SURFACE_BUILDER = TURQUOISE_COARSE_MIX.func_242929_a((ISurfaceBuilderConfig)TURQUOISE_COARSE_DIRT_SAND_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> COARSE_LUNAR_SURFACE_BUILDER = SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)LUNAR_COARSE_DIRT_SAND_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> MOONLIT_RESERVOIR_SURFACE_BUILDER = RESERVOIR.func_242929_a((ISurfaceBuilderConfig)LUNAR_GRASS_DIRT_SAND_CONFIG);

        public static void init(RegistryEvent.Register<SurfaceBuilder<?>> event) {
            SkiesRegistry.register(event.getRegistry(), "roughs", ROUGHS);
            SkiesRegistry.register(event.getRegistry(), "turquoise_coarse_mix", TURQUOISE_COARSE_MIX);
            SkiesRegistry.register(event.getRegistry(), "reservoir", RESERVOIR);
        }
    }
}

