/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;

public class FrostbrightTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.frostbright_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.frostbright_leaves.func_176223_P();
    private static final BlockState SNOW = Blocks.field_150433_aE.func_176223_P();

    public FrostbrightTreeFeature(Codec<BaseTreeFeatureConfig> config, boolean natural) {
        super(config, natural);
    }

    @Override
    public boolean place(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox bounds) {
        int z1;
        int x1;
        int z;
        int x;
        int height;
        int n = height = (double)rand.nextInt(7) + Math.random() < 0.1 ? 30 : 20;
        if (!this.isAreaOk(world, pos, height, 2, height - 2, 11)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            for (int x2 = 0; x2 < 2; ++x2) {
                for (int z2 = 0; z2 < 2; ++z2) {
                    if (y >= height - 1 && (x2 != 0 || z2 != 0)) continue;
                    this.setBlockIfOk(changedLogs, world, pos.func_177982_a(x2, y, z2), LOG, bounds);
                }
            }
        }
        for (x = -6; x <= 6; ++x) {
            for (z = -6; z <= 6; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                BlockPos leafPos = pos.func_177982_a(x > 0 ? x - 1 : x, height - 2, z > 0 ? z - 1 : z).func_177982_a(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (!(z1 < 3 || z1 < 5 && x1 < 6 || z1 == 5 && x1 < 5) && (z1 != 6 || x1 >= 3)) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos, LEAF, bounds);
                if (!this.natural) continue;
                this.setBlockIfOk(null, world, leafPos.func_177984_a(), SNOW, bounds);
            }
        }
        for (x = -5; x <= 5; ++x) {
            for (z = -5; z <= 5; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                BlockPos leafPos = pos.func_177982_a(x > 0 ? x - 1 : x, height - 1, z > 0 ? z - 1 : z).func_177982_a(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (z1 >= 3 && (z1 >= 5 || x1 >= 5) && (z1 != 5 || x1 >= 3)) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos, LEAF, bounds);
                if (!this.natural) continue;
                this.setBlockIfOk(null, world, leafPos.func_177984_a(), SNOW, bounds);
            }
        }
        for (x = -3; x <= 3; ++x) {
            for (z = -3; z <= 3; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                BlockPos leafPos = pos.func_177982_a(x > 0 ? x - 1 : x, height, z > 0 ? z - 1 : z).func_177982_a(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (z1 + x1 > 4) continue;
                this.setBlockIfOk(changedLeaves, world, leafPos, LEAF, bounds);
                if (!this.natural || !world.func_175623_d(leafPos.func_177984_a())) continue;
                this.setBlockIfOk(null, world, leafPos.func_177984_a(), SNOW, bounds);
            }
        }
        this.setLowerBranch(changedLogs, changedLeaves, world, pos.func_177982_a(rand.nextInt(2), rand.nextInt(height - 9) + 3, -1), bounds);
        this.setLowerBranch(changedLogs, changedLeaves, world, pos.func_177982_a(2, rand.nextInt(height - 9) + 3, rand.nextInt(2)), bounds);
        this.setLowerBranch(changedLogs, changedLeaves, world, pos.func_177982_a(rand.nextInt(2), rand.nextInt(height - 9) + 3, 2), bounds);
        this.setLowerBranch(changedLogs, changedLeaves, world, pos.func_177982_a(-1, rand.nextInt(height - 9) + 3, rand.nextInt(2)), bounds);
        for (int branch = 0; branch < 4; ++branch) {
            int l;
            int y = height - 5 - rand.nextInt(2);
            int xz = rand.nextInt(2);
            int length = rand.nextInt(2) + 1;
            for (l = y; l < height - 2; ++l) {
                if (branch == 0) {
                    this.setBlockIfOk(changedLogs, world, pos.func_177982_a(2 + length, l + 1, xz), LOG, bounds);
                }
                if (branch == 1) {
                    this.setBlockIfOk(changedLogs, world, pos.func_177982_a(xz, l + 1, 2 + length), LOG, bounds);
                }
                if (branch == 2) {
                    this.setBlockIfOk(changedLogs, world, pos.func_177982_a(-1 - length, l + 1, xz), LOG, bounds);
                }
                if (branch != 3) continue;
                this.setBlockIfOk(changedLogs, world, pos.func_177982_a(xz, l + 1, -1 - length), LOG, bounds);
            }
            for (l = 0; l < length + 1; ++l) {
                if (branch == 0) {
                    this.setBlockIfOk(changedLogs, world, pos.func_177982_a(2 + l, y, xz), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X), bounds);
                }
                if (branch == 1) {
                    this.setBlockIfOk(changedLogs, world, pos.func_177982_a(xz, y, 2 + l), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z), bounds);
                }
                if (branch == 2) {
                    this.setBlockIfOk(changedLogs, world, pos.func_177982_a(-1 - l, y, xz), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X), bounds);
                }
                if (branch != 3) continue;
                this.setBlockIfOk(changedLogs, world, pos.func_177982_a(xz, y, -1 - l), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z), bounds);
            }
        }
        for (x = -1; x <= 2; ++x) {
            for (z = -1; z <= 2; ++z) {
                if (!((x == -1 || x == 2) ^ (z == -1 || z == 2))) continue;
                this.setBlockIfOk(changedLogs, world, pos.func_177982_a(x, 0, z), LOG, bounds);
                this.setBlockIfOk(changedLogs, world, pos.func_177982_a(x, 1, z), LOG, bounds);
                if (!rand.nextBoolean()) continue;
                this.setBlockIfOk(changedLogs, world, pos.func_177982_a(x, 2, z), LOG, bounds);
            }
        }
        if (this.natural) {
            this.placeSnowCircle(changedLogs, world, rand, pos, bounds);
        }
        return true;
    }

    protected void setLowerBranch(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, ISeedReader world, BlockPos pos, MutableBoundingBox boundingBox) {
        this.setBlockIfOk(changedLogs, world, pos, LOG, boundingBox);
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 0; y < 2; ++y) {
                    if (y == 1 && Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                    this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, y, z), LEAF, boundingBox);
                }
            }
        }
    }

    protected void placeSnowCircle(Set<BlockPos> changedBlocks, ISeedReader world, Random rand, BlockPos centerPos, MutableBoundingBox bounds) {
        for (int x = -5; x <= 6; ++x) {
            for (int z = -5; z <= 6; ++z) {
                BlockState snow;
                BlockPos offsetPos;
                if (!rand.nextBoolean()) continue;
                for (int y = 2; y >= -3 && !this.setBlockIfOk(null, world, offsetPos = centerPos.func_177982_a(x, y, z), snow = (BlockState)SNOW.func_206870_a((Property)SnowBlock.field_176315_a, (Comparable)Integer.valueOf((double)rand.nextFloat() > 0.8 ? 2 : 1)), bounds) && (world.func_175623_d(offsetPos) || y >= 0); --y) {
                }
            }
        }
    }
}

