/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;

public class StarlitTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.starlit_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.starlit_leaves.func_176223_P();

    public StarlitTreeFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config, true);
    }

    @Override
    public boolean place(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox bounds) {
        int y;
        int height = rand.nextInt(3) + 7;
        if (!this.isAreaOk(world, pos, height, 1, 2, 0)) {
            return false;
        }
        for (y = 0; y < height; ++y) {
            this.setBlockIfOk(changedLogs, world, pos.func_177981_b(y), LOG, bounds);
        }
        this.setBlockIfOk(changedLeaves, world, pos.func_177981_b(height), LEAF, bounds);
        this.setBlockIfOk(changedLeaves, world, pos.func_177981_b(height + 1), LEAF, bounds);
        this.setBlockIfOk(changedLeaves, world, pos.func_177981_b(height + 2), LEAF, bounds);
        for (y = height - 5; y <= height; ++y) {
            int z;
            for (Direction dir : DirectionUtil.HORIZONTAL) {
                this.setBlockIfOk(changedLeaves, world, pos.func_177972_a(dir).func_177981_b(y), LEAF, bounds);
            }
            if (y == height - 4 || y == height - 2) {
                int x = -2;
                z = 0;
                while (x <= 0) {
                    this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, y, z), LEAF, bounds);
                    this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x + 1, y, z - 1), LEAF, bounds);
                    this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x + 2, y, z - 2), LEAF, bounds);
                    ++x;
                    ++z;
                }
            }
            if (y != height - 3 && y != height - 1) continue;
            int x = 1;
            z = 1;
            for (int j = 0; j <= 1; ++j) {
                for (int k = 0; k <= 1; ++k) {
                    if (rand.nextBoolean()) {
                        this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, y, z), LEAF, bounds);
                    }
                    z = Math.negateExact(z);
                }
                x = Math.negateExact(x);
            }
        }
        return true;
    }
}

