/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonPieces;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonStructure;
import com.legacy.blue_skies.world.general_features.structures.BlindingDungeonStructure;
import com.legacy.structure_gel.worldgen.structure.GelStructureStart;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class EverbrightBlindingDungeonStructure
extends BlindingDungeonStructure {
    public EverbrightBlindingDungeonStructure(Codec<NoFeatureConfig> config) {
        super(config);
    }

    @Override
    protected boolean isFeatureChunk(ChunkGenerator chunkGen, BiomeProvider biomeProvider, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ, Biome biomeIn, ChunkPos chunkPos, NoFeatureConfig config) {
        return super.isFeatureChunk(chunkGen, biomeProvider, seed, sharedSeedRand, chunkPosX, chunkPosZ, biomeIn, chunkPos, config) && !this.isDungeonClose(chunkGen, seed, sharedSeedRand, chunkPosX, chunkPosZ);
    }

    private boolean isDungeonClose(ChunkGenerator chunkGen, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ) {
        int range = 10;
        for (int x = chunkPosX - range; x <= chunkPosX + range; ++x) {
            for (int z = chunkPosZ - range; z <= chunkPosZ + range; ++z) {
                ChunkPos chunkpos = ((NatureDungeonStructure)SkiesStructures.NATURE_DUNGEON.getStructure()).func_236392_a_(null, seed, sharedSeedRand, x, z);
                if (x != chunkpos.field_77276_a || z != chunkpos.field_77275_b) continue;
                return true;
            }
        }
        return false;
    }

    public double getProbability() {
        return 1.0;
    }

    public int getSpacing() {
        return 20;
    }

    public int getOffset() {
        return this.getSpacing() / 3;
    }

    public Set<ResourceLocation> getValidDimensions() {
        return ImmutableSet.of((Object)SkiesDimensions.EVERBRIGHT_ID);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends GelStructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkX, int chunkZ, MutableBoundingBox boundingBox, int referenceIn, long seed) {
            super(structure, chunkX, chunkZ, boundingBox, referenceIn, seed);
        }

        public void generatePieces(DynamicRegistries registry, ChunkGenerator chunkGen, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig configIn) {
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            int y = BlindingDungeonStructure.getHighestY(chunkGen, chunkX, chunkZ);
            if (y >= 60) {
                BlockPos blockpos = new BlockPos(chunkX * 16 + 8, y, chunkZ * 16 + 8);
                EverbrightBlindingDungeonPieces.assemble(templateManagerIn, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
                this.func_202500_a();
            }
        }
    }
}

