/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.dungeon.PoisonKeystoneBlock;
import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.tile_entity.KeystoneTileEntity;
import com.legacy.blue_skies.util.GeometryHelper;
import com.legacy.blue_skies.util.StringUtil;
import com.legacy.blue_skies.world.util.structure_processors.VinesProcessor;
import com.legacy.structure_gel.worldgen.GelPlacementSettings;
import com.legacy.structure_gel.worldgen.processors.RandomBlockSwapProcessor;
import com.legacy.structure_gel.worldgen.processors.RemoveGelStructureProcessor;
import com.legacy.structure_gel.worldgen.structure.GelTemplateStructurePiece;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.registries.ForgeRegistries;

public class NatureDungeonPieces {
    private static final ResourceLocation HALL_6 = NatureDungeonPieces.locatePiece("hallways/hallway_6");
    private static final ResourceLocation HALL_7 = NatureDungeonPieces.locatePiece("hallways/hallway_7");
    private static final ResourceLocation HALL_8 = NatureDungeonPieces.locatePiece("hallways/hallway_8");
    private static final ResourceLocation HALL_9 = NatureDungeonPieces.locatePiece("hallways/hallway_9");
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor1Map = NatureDungeonPieces.makeFloorMap(1, 20, 3);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor1EntryMap = NatureDungeonPieces.makeEntryMap(1, 1);
    private static final List<ResourceLocation> floor1Layers = NatureDungeonPieces.makeFloorLayer(1, 12);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor2Map = NatureDungeonPieces.makeFloorMap(2, 20, 4);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor2EntryMap = NatureDungeonPieces.makeEntryMap(2, 1);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor3Map = NatureDungeonPieces.makeFloorMap(3, 18, 4);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor3EntryMap = NatureDungeonPieces.makeEntryMap(3, 1);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor4Map = NatureDungeonPieces.makeFloorMap(4, 18, 4);
    private static final Map<Room.ConnectionType, List<ResourceLocation>> floor4EntryMap = NatureDungeonPieces.makeEntryMap(4, 1);
    private static final ResourceLocation BOSS_HALL = NatureDungeonPieces.locatePiece("boss/hallway");
    private static final ResourceLocation BOSS_ROOM = NatureDungeonPieces.locatePiece("boss/boss_room");
    private static final ResourceLocation WALL_ENTRY = NatureDungeonPieces.locatePiece("wall/floor_1_entry");
    private static final Wall WALL_1 = new Wall(1);
    private static final Wall WALL_2 = new Wall(2);
    private static final Wall WALL_3 = new Wall(3);
    private static final Wall WALL_4 = new Wall(4);
    private static final ResourceLocation STAIRS = NatureDungeonPieces.locatePiece("entry_stairs");

    private static Map<Room.ConnectionType, List<ResourceLocation>> makeFloorMap(int floor, int width, int variations) {
        HashMap<Room.ConnectionType, List<ResourceLocation>> map = new HashMap<Room.ConnectionType, List<ResourceLocation>>();
        for (Room.ConnectionType type : Room.ConnectionType.values()) {
            ArrayList<ResourceLocation> pieces = new ArrayList<ResourceLocation>();
            switch (type) {
                case EXIT: {
                    pieces.add(NatureDungeonPieces.locatePiece(String.format("exits/floor_%d/exit_%d_0", floor, width)));
                    break;
                }
                default: {
                    for (int i = 0; i < variations; ++i) {
                        pieces.add(NatureDungeonPieces.locatePiece(String.format("rooms/floor_%d/room_%d_%s_%d", floor, width, type.toString(), i)));
                    }
                }
            }
            map.put(type, pieces);
        }
        return map;
    }

    private static Map<Room.ConnectionType, List<ResourceLocation>> makeEntryMap(int floor, int variations) {
        HashMap<Room.ConnectionType, List<ResourceLocation>> map = new HashMap<Room.ConnectionType, List<ResourceLocation>>();
        for (Room.ConnectionType type : new Room.ConnectionType[]{Room.ConnectionType.CROSS, Room.ConnectionType.T, Room.ConnectionType.L, Room.ConnectionType.I, Room.ConnectionType.END}) {
            ArrayList<ResourceLocation> pieces = new ArrayList<ResourceLocation>();
            for (int i = 0; i < variations; ++i) {
                pieces.add(NatureDungeonPieces.locatePiece(String.format("entry/floor_%d/entry_%s_%d", floor, type.toString(), i)));
            }
            map.put(type, pieces);
        }
        return map;
    }

    private static List<ResourceLocation> makeFloorLayer(int floor, int rooms) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < rooms; ++i) {
            list.add(NatureDungeonPieces.locatePiece(String.format("rooms/floor_%d/inside_%d", floor, i)));
        }
        return list;
    }

    public static ResourceLocation locatePiece(String path) {
        return BlueSkies.locate("dungeons/everbright/nature/" + path);
    }

    public static void assemble(TemplateManager templateManager, BlockPos worldPos, Rotation rotation, List<StructurePiece> components, Random rand, ChunkGenerator chunkGen) {
        int f1Room = 20;
        int f1Hall = 9;
        int f2Room = 20;
        int f2Hall = 7;
        int f3Room = 18;
        int f3Hall = 8;
        int f4Room = 18;
        int f4Hall = 6;
        worldPos = worldPos.func_177982_a(-67, 0, -67);
        FirstFloor floor1 = new FirstFloor(1, f1Room, f1Hall, Floor.potentialExits.get(rand.nextInt(Floor.potentialExits.size())), worldPos, rand, HALL_9, floor1Map, floor1EntryMap, floor1Layers, WALL_1);
        Floor floor2 = new Floor(2, f2Room, f2Hall, (Pair<Integer, Integer>)floor1.exitPos, worldPos.func_177982_a(4, 15, 4), rand, HALL_7, floor2Map, floor2EntryMap, WALL_2);
        Floor floor3 = new Floor(3, f3Room, f3Hall, floor2.exitPos, worldPos.func_177982_a(7, 30, 7), rand, HALL_8, floor3Map, floor3EntryMap, WALL_3);
        Floor floor4 = new Floor(4, f4Room, f4Hall, floor3.exitPos, worldPos.func_177982_a(11, 45, 11), rand, HALL_6, floor4Map, floor4EntryMap, WALL_4);
        BossFloor bossFloor = new BossFloor(floor4.exitPos, worldPos.func_177982_a(52, 60, 52), rand);
        int fillHeight = 14;
        int f1Stone = f1Room * 5 + f1Hall * 4;
        int f2Stone = f2Room * 5 + f2Hall * 4;
        int f3Stone = f3Room * 5 + f3Hall * 4;
        int f4Stone = f4Room * 5 + f4Hall * 4;
        components.add(new AirBubblePiece(worldPos.func_177982_a(f1Stone / 2, 33, f1Stone / 2).func_177967_a(floor1.getEntryDir(), f1Stone / 2 + 5)));
        components.add(new StoneFillPiece(worldPos, new BlockPos(f1Stone, fillHeight, f1Stone), 0));
        components.add(new StoneFillPiece(worldPos.func_177982_a(4, 15, 4), new BlockPos(f2Stone, fillHeight, f2Stone), 0));
        components.add(new StoneFillPiece(worldPos.func_177982_a(7, 30, 7), new BlockPos(f3Stone, fillHeight, f3Stone), 0));
        components.add(new StoneFillPiece(worldPos.func_177982_a(11, 45, 11), new BlockPos(f4Stone, fillHeight - 3, f4Stone), 0));
        components.add(new StoneFillPiece(worldPos.func_177982_a(-5, -1, -5), new BlockPos(f1Stone + 9, 0, f1Stone + 9), 1));
        components.add(new GardenPiece(worldPos.func_177982_a(11, 56, 11)));
        bossFloor.addPieces(components, templateManager);
        floor4.addPieces(components, templateManager);
        floor3.addPieces(components, templateManager);
        floor2.addPieces(components, templateManager);
        floor1.addPieces(components, templateManager);
        floor1.addWalls(components, templateManager, chunkGen);
        floor2.addWalls(components, templateManager, chunkGen);
        floor3.addWalls(components, templateManager, chunkGen);
        floor4.addWalls(components, templateManager, chunkGen);
    }

    public static class AirBubblePiece
    extends StructurePiece {
        protected AirBubblePiece(BlockPos pos) {
            super(SkiesStructures.NATURE_DUNGEON.getPieceType("air_bubble"), 0);
            int width = 15;
            int height = 25;
            this.field_74887_e = new MutableBoundingBox((Vector3i)pos.func_177982_a(-width, -height, -width), (Vector3i)pos.func_177982_a(width, height, width));
        }

        public AirBubblePiece(TemplateManager templateManager, CompoundNBT nbt) {
            super(SkiesStructures.NATURE_DUNGEON.getPieceType("air_bubble"), nbt);
        }

        protected void func_143011_b(CompoundNBT nbt) {
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGen, Random rand, MutableBoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
            int width = 15;
            int height = 25;
            for (int x = -width; x < width; ++x) {
                for (int z = -width; z < width; ++z) {
                    for (int y = -height; y < height; ++y) {
                        BlockPos placePos;
                        if (!GeometryHelper.isInEllipsoid(width, height, width, x, y, z) || !bounds.func_175898_b((Vector3i)(placePos = pos.func_177982_a(x, y, z)))) continue;
                        world.func_180501_a(placePos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            }
            return true;
        }
    }

    public static class StoneFillPiece
    extends StructurePiece {
        protected StoneFillPiece(BlockPos pos, BlockPos size, int componentType) {
            super(SkiesStructures.NATURE_DUNGEON.getPieceType("stone_fill"), componentType);
            this.field_74887_e = new MutableBoundingBox((Vector3i)pos, (Vector3i)pos.func_177971_a((Vector3i)size));
        }

        public StoneFillPiece(TemplateManager templateManager, CompoundNBT nbt) {
            super(SkiesStructures.NATURE_DUNGEON.getPieceType("stone_fill"), nbt);
        }

        protected void func_143011_b(CompoundNBT nbt) {
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGen, Random rand, MutableBoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
            if (this.field_74886_g == 0) {
                this.func_175804_a(world, bounds, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, SkiesBlocks.nature_stone.func_176223_P(), SkiesBlocks.nature_stone.func_176223_P(), false);
            } else if (this.field_74886_g == 1) {
                for (int x = this.field_74887_e.field_78897_a; x <= this.field_74887_e.field_78893_d; ++x) {
                    for (int z = this.field_74887_e.field_78896_c; z <= this.field_74887_e.field_78892_f; ++z) {
                        this.func_175808_b(world, SkiesBlocks.nature_stone.func_176223_P(), x, this.field_74887_e.field_78894_e, z, bounds);
                    }
                }
            }
            return true;
        }
    }

    public static class GardenPiece
    extends StructurePiece {
        private static int size = 114;

        protected GardenPiece(BlockPos pos) {
            super(SkiesStructures.NATURE_DUNGEON.getPieceType("garden"), 0);
            this.field_74887_e = new MutableBoundingBox((Vector3i)pos, (Vector3i)pos.func_177982_a(size - 1, 21, size - 1));
        }

        public GardenPiece(TemplateManager templateManager, CompoundNBT nbt) {
            super(SkiesStructures.NATURE_DUNGEON.getPieceType("garden"), nbt);
        }

        protected void func_143011_b(CompoundNBT nbt) {
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGen, Random rand, MutableBoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
            this.func_175804_a(world, bounds, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 2, this.field_74887_e.field_78892_f, SkiesBlocks.turquoise_dirt.func_176223_P(), SkiesBlocks.turquoise_dirt.func_176223_P(), false);
            SimplexNoiseGenerator noise = new SimplexNoiseGenerator(new Random(1337L));
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    double h = (noise.func_151605_a((double)(this.field_74887_e.field_78897_a + x) / 50.0, (double)(this.field_74887_e.field_78896_c + z) / 50.0) + 1.0) / 2.0 * 3.0;
                    int border2 = 2;
                    if ((x < border2 - 1 || z < border2 - 1 || x > size - border2 || z > size - border2) && h > 2.0) {
                        h = 1.0;
                    }
                    int y = 0;
                    while ((double)y < h - 1.0) {
                        this.func_175811_a(world, SkiesBlocks.turquoise_dirt.func_176223_P(), this.field_74887_e.field_78897_a + x, this.field_74887_e.field_78895_b + 3 + y, this.field_74887_e.field_78896_c + z, bounds);
                        ++y;
                    }
                    this.func_175811_a(world, SkiesBlocks.turquoise_cherry_grass_block.func_176223_P(), this.field_74887_e.field_78897_a + x, this.field_74887_e.field_78895_b + 3 + (int)h, this.field_74887_e.field_78896_c + z, bounds);
                    if (!((double)rand.nextFloat() < 0.33)) continue;
                    this.func_175811_a(world, ((double)rand.nextFloat() < 0.07 ? SkiesBlocks.blush_blossom : SkiesBlocks.cherry_grass).func_176223_P(), this.field_74887_e.field_78897_a + x, this.field_74887_e.field_78895_b + 4 + (int)h, this.field_74887_e.field_78896_c + z, bounds);
                }
            }
            return true;
        }
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        private final int floor;
        private final boolean hasKey;
        private final boolean hasChests;
        private final int wallFlags;

        public Piece(TemplateManager templateManager, BlockPos pos, Room room, int floor, Random rand) {
            super(SkiesStructures.NATURE_DUNGEON.getPieceType("main"), room.getRandom(rand), 0);
            this.field_186169_c = room.rotation;
            this.floor = floor;
            this.field_186178_c = pos;
            this.hasKey = room.hasKey;
            this.hasChests = room.hasKey || rand.nextFloat() < 0.5f;
            this.wallFlags = 0;
            this.setupTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, BlockPos pos, Room room, int floor, Random rand, ResourceLocation layer) {
            super(SkiesStructures.NATURE_DUNGEON.getPieceType("main"), layer, 0);
            this.field_186169_c = room.rotation;
            this.floor = floor;
            this.field_186178_c = pos;
            this.hasKey = room.hasKey;
            this.hasChests = room.hasKey || rand.nextFloat() < 0.5f;
            this.wallFlags = 0;
            this.setupTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, BlockPos pos, ResourceLocation name, int floor, Random rand, Rotation rotation) {
            this(templateManager, pos, name, floor, rand, rotation, 0);
        }

        public Piece(TemplateManager templateManager, BlockPos pos, ResourceLocation name, int floor, Random rand, Rotation rotation, int componentType) {
            super(SkiesStructures.NATURE_DUNGEON.getPieceType("main"), name, componentType);
            this.field_186169_c = rotation;
            this.floor = floor;
            this.field_186178_c = pos;
            this.hasKey = false;
            this.hasChests = false;
            this.wallFlags = componentType == 1 ? rand.nextInt(10) : 0;
            this.setupTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbt) {
            super(SkiesStructures.NATURE_DUNGEON.getPieceType("main"), nbt);
            this.floor = nbt.func_74771_c("Floor");
            this.hasKey = nbt.func_74767_n("HasKey");
            this.hasChests = nbt.func_74767_n("HasChests");
            this.wallFlags = nbt.func_74771_c("WallFlags");
            this.setupTemplate(templateManager);
        }

        protected void func_143011_b(CompoundNBT nbt) {
            super.func_143011_b(nbt);
            nbt.func_74774_a("Floor", (byte)this.floor);
            nbt.func_74757_a("HasKey", this.hasKey);
            nbt.func_74757_a("HasChests", this.hasChests);
            nbt.func_74774_a("WallFlags", (byte)this.wallFlags);
        }

        public void setupTemplate(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.name);
            BlockPos sizePos = templateManager.func_200219_b(this.name).func_186259_a();
            BlockPos centerPos = new BlockPos(sizePos.func_177958_n() / 2, 0, sizePos.func_177952_p() / 2);
            GelPlacementSettings settings = (GelPlacementSettings)new GelPlacementSettings().setMaintainWater(false).func_186220_a(this.field_186169_c);
            if (this.field_74886_g == 0) {
                settings.func_207665_a(centerPos);
            }
            settings.func_215222_a((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            settings.func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            if (this.field_74886_g == 0) {
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.cherry_grass, 0.5f, Blocks.field_150350_a));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.turquoise_grass, 0.5f, Blocks.field_150350_a));
                settings.func_215222_a((StructureProcessor)new VinesProcessor());
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.nature_stonebrick, 0.1f, SkiesBlocks.glowing_nature_stonebrick));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_150339_S, SkiesBlocks.nature_stonebrick));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196559_aO, 0.5f, SkiesBlocks.nature_stone));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196559_aO, SkiesBlocks.starlit_planks));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196561_aQ, 0.5f, SkiesBlocks.nature_stone));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196561_aQ, SkiesBlocks.nature_stonebrick));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196569_aY, 0.5f, SkiesBlocks.nature_stone));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196569_aY, SkiesBlocks.carved_nature_stonebrick));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196562_aR, 0.5f, SkiesBlocks.nature_stone_slab));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196562_aR, Blocks.field_150350_a));
                if (this.floor == 1 || this.floor == 2) {
                    settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.nature_stone, 0.03f, SkiesBlocks.glowing_nature_stone));
                } else if (this.floor == 5) {
                    settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.nature_stone, 0.1f, SkiesBlocks.glowing_nature_stone));
                }
            } else if (this.field_74886_g == 1) {
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.turquoise_grass, 0.5f, Blocks.field_150350_a));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.nature_stone, 0.05f, SkiesBlocks.glowing_nature_stone));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.nature_stonebrick, 0.07f, SkiesBlocks.nature_stone));
                settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.nature_stonebrick, 0.1f, SkiesBlocks.glowing_nature_stonebrick));
                if (this.wallFlags < 2) {
                    settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196569_aY, SkiesBlocks.nature_stone));
                } else if (this.wallFlags < 4) {
                    settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196570_aZ, SkiesBlocks.nature_stonebrick));
                } else if (this.wallFlags < 6) {
                    settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196567_aW, SkiesBlocks.nature_stone));
                } else if (this.wallFlags < 8) {
                    settings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196562_aR, SkiesBlocks.nature_stonebrick));
                }
            }
            this.func_186173_a(template, this.field_186178_c, (PlacementSettings)settings);
        }

        @Nullable
        public BlockState modifyState(IServerWorld world, Random rand, BlockPos pos, BlockState originalState) {
            Block block = originalState.func_177230_c();
            if (this.field_74886_g == 0) {
                if (block == Blocks.field_196617_K) {
                    if (rand.nextFloat() < 0.5f && originalState.func_235901_b_((Property)RotatedPillarBlock.field_176298_M)) {
                        return (BlockState)SkiesBlocks.nature_stone_pillar.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, originalState.func_177229_b((Property)RotatedPillarBlock.field_176298_M));
                    }
                    return SkiesBlocks.nature_stone.func_176223_P();
                }
                if (block instanceof LeavesBlock && originalState.func_235901_b_((Property)LeavesBlock.field_208495_b)) {
                    return (BlockState)originalState.func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(false));
                }
            } else if (this.field_74886_g == 1) {
                if (block == Blocks.field_222401_hJ) {
                    if (rand.nextFloat() < 0.5f) {
                        return null;
                    }
                    return SkiesBlocks.nature_stone_slab.func_176223_P();
                }
                if (block == Blocks.field_196570_aZ || block == Blocks.field_196562_aR) {
                    return SkiesBlocks.nature_stone.func_176223_P();
                }
                if (block == Blocks.field_196567_aW || block == Blocks.field_196569_aY) {
                    return SkiesBlocks.nature_stonebrick.func_176223_P();
                }
            }
            return originalState;
        }

        protected void func_186175_a(String key, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (key.startsWith("spawner")) {
                if (this.hasChests || (float)rand.nextInt() < 0.7f) {
                    worldIn.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 3);
                    if (worldIn.func_175625_s(pos) instanceof MobSpawnerTileEntity) {
                        MobSpawnerTileEntity tile = (MobSpawnerTileEntity)worldIn.func_175625_s(pos);
                        tile.func_145881_a().func_200876_a(SkiesEntityTypes.STONELET);
                    }
                } else {
                    String[] split = key.split("-");
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[1]));
                    if (block != null) {
                        worldIn.func_180501_a(pos, block.func_176223_P(), 3);
                    }
                }
            }
            if (key.startsWith("chest")) {
                if (this.hasChests) {
                    if (key.endsWith("extra")) {
                        LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)SkiesLootProv.NATURE_CHEST);
                    } else {
                        LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)(this.hasKey ? SkiesLootProv.NATURE_CHEST_KEY : SkiesLootProv.NATURE_CHEST));
                    }
                } else {
                    worldIn.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 3);
                }
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if ("keystone".equals(key)) {
                worldIn.func_180501_a(pos, SkiesBlocks.starlit_planks.func_176223_P(), 3);
                TileEntity tileEntity = worldIn.func_175625_s(pos.func_177981_b(2));
                if (tileEntity instanceof KeystoneTileEntity.NatureKeystoneTileEntity) {
                    KeystoneTileEntity.NatureKeystoneTileEntity keystone = (KeystoneTileEntity.NatureKeystoneTileEntity)tileEntity;
                    keystone.setTeleportOffset(new BlockPos(0, -1, 0).func_177967_a((Direction)worldIn.func_180495_p(pos.func_177981_b(2)).func_177229_b((Property)PoisonKeystoneBlock.FACING), -3));
                    keystone.setSpawnOffset(new BlockPos(0, -1, 0).func_177967_a((Direction)worldIn.func_180495_p(pos.func_177981_b(2)).func_177229_b((Property)PoisonKeystoneBlock.FACING), -15));
                }
            }
        }
    }

    protected static class Room {
        protected boolean north = false;
        protected boolean south = false;
        protected boolean east = false;
        protected boolean west = false;
        protected boolean mainPath = false;
        protected boolean isConnectedToMain = false;
        protected boolean hasKey = false;
        protected Rotation rotation = Rotation.NONE;
        private List<ResourceLocation> structures = new ArrayList<ResourceLocation>();

        public void setPieces(List<ResourceLocation> structures) {
            this.structures.clear();
            this.structures.addAll(structures);
        }

        public ResourceLocation getRandom(Random rand) {
            return this.structures.get(rand.nextInt(this.structures.size()));
        }

        public boolean isConnected(Direction direction) {
            switch (direction) {
                case NORTH: {
                    return this.north;
                }
                case SOUTH: {
                    return this.south;
                }
                case EAST: {
                    return this.east;
                }
                case WEST: {
                    return this.west;
                }
            }
            return false;
        }

        protected static enum ConnectionType {
            CROSS,
            T,
            L,
            I,
            END,
            EXIT;


            public String toString() {
                return StringUtil.toLower(this.name());
            }
        }
    }

    protected static class BossFloor {
        private final Pair<Integer, Integer> entry;
        private final BlockPos worldPos;
        private final Random rand;

        public BossFloor(Pair<Integer, Integer> entry, BlockPos worldPos, Random rand) {
            this.entry = entry;
            this.worldPos = worldPos;
            this.rand = rand;
        }

        public void addPieces(List<StructurePiece> components, TemplateManager templateManager) {
            BlockPos hallOffset;
            Rotation rot = this.entry.equals(Floor.potentialExits.get(0)) ? Rotation.COUNTERCLOCKWISE_90 : (this.entry.equals(Floor.potentialExits.get(1)) ? Rotation.CLOCKWISE_90 : (this.entry.equals(Floor.potentialExits.get(2)) ? Rotation.NONE : Rotation.CLOCKWISE_180));
            switch (rot) {
                case COUNTERCLOCKWISE_90: {
                    hallOffset = new BlockPos(-29, 0, -4);
                    break;
                }
                case CLOCKWISE_90: {
                    hallOffset = new BlockPos(41, 0, -4);
                    break;
                }
                case NONE: {
                    hallOffset = new BlockPos(6, 0, -39);
                    break;
                }
                default: {
                    hallOffset = new BlockPos(6, 0, 31);
                }
            }
            components.add((StructurePiece)new Piece(templateManager, this.worldPos.func_177971_a((Vector3i)hallOffset), BOSS_HALL, 5, this.rand, rot));
            Direction.NORTH.func_176746_e();
            components.add((StructurePiece)new Piece(templateManager, this.worldPos, BOSS_ROOM, 5, this.rand, rot));
        }
    }

    protected static class FirstFloor
    extends Floor {
        private final List<ResourceLocation> layers;

        public FirstFloor(int floor, int roomWidth, int hallLength, Pair<Integer, Integer> entry, BlockPos worldPos, Random rand, ResourceLocation hallway, Map<Room.ConnectionType, List<ResourceLocation>> roomOptions, Map<Room.ConnectionType, List<ResourceLocation>> entryOptions, List<ResourceLocation> layers, Wall wall) {
            super(floor, roomWidth, hallLength, entry, worldPos, rand, hallway, roomOptions, entryOptions, wall);
            this.layers = layers;
        }

        @Override
        public void updateEntry() {
            this.setConnection((Integer)this.entryPos.getFirst(), (Integer)this.entryPos.getSecond(), this.getEntryDir(), true);
        }

        public Direction getEntryDir() {
            if (this.entryPos.equals(Floor.potentialExits.get(0))) {
                return Direction.WEST;
            }
            if (this.entryPos.equals(Floor.potentialExits.get(1))) {
                return Direction.EAST;
            }
            if (this.entryPos.equals(Floor.potentialExits.get(2))) {
                return Direction.NORTH;
            }
            return Direction.SOUTH;
        }

        public void addStairs(Direction entrySide, List<StructurePiece> components, TemplateManager templateManager, ChunkGenerator chunkGen) {
            BlockPos offset;
            Rotation rot;
            switch (entrySide) {
                case WEST: {
                    rot = Rotation.NONE;
                    offset = new BlockPos(-9, -3, 65);
                    break;
                }
                case EAST: {
                    rot = Rotation.CLOCKWISE_180;
                    offset = new BlockPos(144, -3, 70);
                    break;
                }
                case NORTH: {
                    rot = Rotation.CLOCKWISE_90;
                    offset = new BlockPos(70, -3, -9);
                    break;
                }
                default: {
                    rot = Rotation.COUNTERCLOCKWISE_90;
                    offset = new BlockPos(65, -3, 144);
                }
            }
            for (int i = 0; i < 10; ++i) {
                int xOffset = entrySide.func_176740_k() == Direction.Axis.X ? i * 4 * entrySide.func_176743_c().func_179524_a() : 0;
                int zOffset = entrySide.func_176740_k() == Direction.Axis.Z ? i * 4 * entrySide.func_176743_c().func_179524_a() : 0;
                BlockPos stairPos = this.worldPos.func_177971_a((Vector3i)offset.func_177982_a(xOffset, i * -4, zOffset));
                components.add((StructurePiece)new Piece(templateManager, stairPos, STAIRS, this.floor, this.rand, rot, 2));
                if (stairPos.func_177956_o() < chunkGen.func_222529_a(stairPos.func_177958_n(), stairPos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG)) break;
            }
        }

        @Override
        public void addRoom(int x, int z, int roomOffset, int xOffset, int zOffset, Room room, TemplateManager templateManager, List<StructurePiece> components) {
            super.addRoom(x, z, roomOffset, xOffset, zOffset, room, templateManager, components);
            Pair pos = Pair.of((Object)x, (Object)z);
            if (!this.exitPos.equals((Object)pos) && !this.entryPos.equals((Object)pos)) {
                components.add((StructurePiece)new Piece(templateManager, new BlockPos(this.worldPos.func_177958_n() + x * roomOffset + xOffset, this.worldPos.func_177956_o(), this.worldPos.func_177952_p() + z * roomOffset + zOffset), room, this.floor, this.rand, this.layers.get(this.rand.nextInt(this.layers.size()))));
            }
        }

        @Override
        public ResourceLocation getWallAddStairs(int i, Direction dir, List<StructurePiece> components, TemplateManager templateManager, ChunkGenerator chunkGen) {
            if (i == 2) {
                Pair<Integer, Integer> pos;
                switch (dir) {
                    case WEST: {
                        pos = Floor.potentialExits.get(0);
                        break;
                    }
                    case EAST: {
                        pos = Floor.potentialExits.get(1);
                        break;
                    }
                    case NORTH: {
                        pos = Floor.potentialExits.get(2);
                        break;
                    }
                    default: {
                        pos = Floor.potentialExits.get(3);
                    }
                }
                if (this.entryPos.equals(pos)) {
                    this.addStairs(dir, components, templateManager, chunkGen);
                    return WALL_ENTRY;
                }
            }
            return super.getWallAddStairs(i, dir, components, templateManager, chunkGen);
        }
    }

    protected static class Floor {
        protected final List<List<Room>> map;
        protected final Map<Room.ConnectionType, List<ResourceLocation>> roomOptions;
        protected final Map<Room.ConnectionType, List<ResourceLocation>> entryOptions;
        protected final int floor;
        protected final int roomWidth;
        protected final int hallLength;
        protected final BlockPos worldPos;
        protected final Random rand;
        protected final ResourceLocation hallway;
        protected final Wall wall;
        protected Pair<Integer, Integer> entryPos;
        protected Pair<Integer, Integer> exitPos;
        protected static final int size = 5;
        protected static final List<Pair<Integer, Integer>> potentialExits = new ArrayList<Pair<Integer, Integer>>();
        protected static final Direction[] DIRECTIONS;

        public Floor(int floor, int roomWidth, int hallLength, Pair<Integer, Integer> entry, BlockPos worldPos, Random rand, ResourceLocation hallway, Map<Room.ConnectionType, List<ResourceLocation>> roomOptions, Map<Room.ConnectionType, List<ResourceLocation>> entryOptions, Wall wall) {
            this.floor = floor;
            this.roomWidth = roomWidth;
            this.hallLength = hallLength;
            this.entryPos = entry;
            this.worldPos = worldPos;
            this.rand = rand;
            this.hallway = hallway;
            this.roomOptions = roomOptions;
            this.entryOptions = entryOptions;
            this.wall = wall;
            this.map = new ArrayList<List<Room>>();
            for (int i = 0; i < 5; ++i) {
                this.map.add(new ArrayList());
                for (int j = 0; j < 5; ++j) {
                    this.map.get(i).add(new Room());
                }
            }
            this.init();
        }

        public void init() {
            Room room;
            Pair pos;
            int x;
            List filteredExitPoses = potentialExits.stream().filter(p -> !p.equals(this.entryPos)).collect(Collectors.toList());
            this.exitPos = (Pair)filteredExitPoses.get(this.rand.nextInt(filteredExitPoses.size()));
            Pair<Integer, Integer> pointA = this.randomPair();
            this.connectMainPath(this.entryPos, pointA);
            this.connectMainPath(pointA, this.exitPos);
            boolean needsConnections = true;
            for (int loops = 0; needsConnections && loops < 15; ++loops) {
                boolean checkAgain = false;
                for (x = 0; x < 5; ++x) {
                    for (int z = 0; z < 5; ++z) {
                        pos = Pair.of((Object)x, (Object)z);
                        room = this.get((Pair<Integer, Integer>)pos).get();
                        if (room.mainPath || room.isConnectedToMain) continue;
                        checkAgain = true;
                        ArrayList connectionOptions = new ArrayList();
                        for (Direction dir : DIRECTIONS) {
                            Pair<Integer, Integer> offsetPos = this.offset(x, z, dir);
                            this.get(offsetPos).ifPresent(adjacentRoom -> {
                                if ((adjacentRoom.mainPath || adjacentRoom.isConnectedToMain) && !offsetPos.equals(this.exitPos)) {
                                    connectionOptions.add(dir);
                                }
                            });
                        }
                        if (connectionOptions.isEmpty()) continue;
                        this.setConnection(x, z, (Direction)connectionOptions.get(this.rand.nextInt(connectionOptions.size())), true);
                        room.isConnectedToMain = true;
                    }
                }
                needsConnections = checkAgain;
            }
            this.updateEntry();
            for (int x2 = 0; x2 < 5; ++x2) {
                block10: for (int z = 0; z < 5; ++z) {
                    Pair pos2 = Pair.of((Object)x2, (Object)z);
                    if (!this.get((Pair<Integer, Integer>)pos2).isPresent()) continue;
                    Room room2 = this.get((Pair<Integer, Integer>)pos2).get();
                    List<Direction> conns = this.getSurroundingConnections(x2, z);
                    if (this.exitPos.equals((Object)pos2)) {
                        Rotation rot = Rotation.NONE;
                        if (conns.contains(Direction.EAST)) {
                            rot = Rotation.CLOCKWISE_90;
                        } else if (conns.contains(Direction.SOUTH)) {
                            rot = Rotation.CLOCKWISE_180;
                        } else if (conns.contains(Direction.WEST)) {
                            rot = Rotation.COUNTERCLOCKWISE_90;
                        }
                        room2.setPieces(this.roomOptions.get((Object)Room.ConnectionType.EXIT));
                        room2.rotation = rot;
                        continue;
                    }
                    boolean isEntry = this.entryPos.equals((Object)pos2);
                    switch (conns.size()) {
                        case 1: {
                            Rotation rot = Rotation.NONE;
                            if (conns.contains(Direction.EAST)) {
                                rot = Rotation.CLOCKWISE_90;
                            } else if (conns.contains(Direction.SOUTH)) {
                                rot = Rotation.CLOCKWISE_180;
                            } else if (conns.contains(Direction.WEST)) {
                                rot = Rotation.COUNTERCLOCKWISE_90;
                            }
                            room2.setPieces(isEntry ? this.entryOptions.get((Object)Room.ConnectionType.END) : this.roomOptions.get((Object)Room.ConnectionType.END));
                            room2.rotation = rot;
                            continue block10;
                        }
                        case 2: {
                            if (conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH)) && !conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.EAST, (Object)Direction.WEST))) {
                                room2.setPieces(isEntry ? this.entryOptions.get((Object)Room.ConnectionType.I) : this.roomOptions.get((Object)Room.ConnectionType.I));
                                room2.rotation = this.rand.nextBoolean() ? Rotation.NONE : Rotation.CLOCKWISE_180;
                            } else if (!conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH)) && conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.EAST, (Object)Direction.WEST))) {
                                room2.setPieces(isEntry ? this.entryOptions.get((Object)Room.ConnectionType.I) : this.roomOptions.get((Object)Room.ConnectionType.I));
                                room2.rotation = this.rand.nextBoolean() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
                            }
                            for (Rotation rot : Rotation.values()) {
                                if (!conns.containsAll((Collection<?>)ImmutableList.of((Object)rot.func_185831_a(Direction.NORTH), (Object)rot.func_185831_a(Direction.WEST)))) continue;
                                room2.setPieces(isEntry ? this.entryOptions.get((Object)Room.ConnectionType.L) : this.roomOptions.get((Object)Room.ConnectionType.L));
                                room2.rotation = rot;
                                continue block10;
                            }
                            continue block10;
                        }
                        case 3: {
                            Rotation rot = Rotation.NONE;
                            if (!conns.contains(Direction.WEST)) {
                                rot = Rotation.CLOCKWISE_90;
                            } else if (!conns.contains(Direction.NORTH)) {
                                rot = Rotation.CLOCKWISE_180;
                            } else if (!conns.contains(Direction.EAST)) {
                                rot = Rotation.COUNTERCLOCKWISE_90;
                            }
                            room2.setPieces(isEntry ? this.entryOptions.get((Object)Room.ConnectionType.T) : this.roomOptions.get((Object)Room.ConnectionType.T));
                            room2.rotation = rot;
                            continue block10;
                        }
                        default: {
                            room2.setPieces(isEntry ? this.entryOptions.get((Object)Room.ConnectionType.CROSS) : this.roomOptions.get((Object)Room.ConnectionType.CROSS));
                            room2.rotation = Rotation.func_222466_a((Random)this.rand);
                        }
                    }
                }
            }
            ArrayList<Pair> potentialKeyRooms = new ArrayList<Pair>();
            for (x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    pos = Pair.of((Object)x, (Object)z);
                    room = this.get((Pair<Integer, Integer>)pos).get();
                    if (room.mainPath || pos.equals(this.entryPos) || pos.equals(this.exitPos) || !room.isConnectedToMain) continue;
                    potentialKeyRooms.add(pos);
                }
            }
            List potentialKeyDeadEnds = potentialKeyRooms.stream().filter(p -> this.getSurroundingConnections((Integer)p.getFirst(), (Integer)p.getSecond()).size() == 1).collect(Collectors.toList());
            if (!potentialKeyDeadEnds.isEmpty()) {
                this.get((Pair<Integer, Integer>)((Pair)potentialKeyDeadEnds.get((int)this.rand.nextInt((int)potentialKeyDeadEnds.size())))).get().hasKey = true;
            } else {
                this.get((Pair<Integer, Integer>)((Pair)potentialKeyRooms.get((int)this.rand.nextInt((int)potentialKeyRooms.size())))).get().hasKey = true;
            }
        }

        public void updateEntry() {
        }

        public void connectMainPath(Pair<Integer, Integer> pointA, Pair<Integer, Integer> pointB) {
            int x = (Integer)pointA.getFirst();
            int z = (Integer)pointA.getSecond();
            int x1 = (Integer)pointB.getFirst();
            int z1 = (Integer)pointB.getSecond();
            ArrayList<Object> path = new ArrayList<Object>();
            path.add(pointA);
            if (this.rand.nextBoolean()) {
                while (x != x1) {
                    if (x > x1) {
                        --x;
                    }
                    if (x < x1) {
                        ++x;
                    }
                    path.add(Pair.of((Object)x, (Object)z));
                }
                while (z != z1) {
                    if (z > z1) {
                        --z;
                    }
                    if (z < z1) {
                        ++z;
                    }
                    path.add(Pair.of((Object)x, (Object)z));
                }
            } else {
                while (z != z1) {
                    if (z > z1) {
                        --z;
                    }
                    if (z < z1) {
                        ++z;
                    }
                    path.add(Pair.of((Object)x, (Object)z));
                }
                while (x != x1) {
                    if (x > x1) {
                        --x;
                    }
                    if (x < x1) {
                        ++x;
                    }
                    path.add(Pair.of((Object)x, (Object)z));
                }
            }
            path.add(pointB);
            Pair prev = (Pair)path.get(0);
            for (Pair pair : path) {
                if ((Integer)pair.getSecond() < (Integer)prev.getSecond()) {
                    this.setConnection((Integer)pair.getFirst(), (Integer)pair.getSecond(), Direction.SOUTH, true);
                }
                if ((Integer)pair.getSecond() > (Integer)prev.getSecond()) {
                    this.setConnection((Integer)pair.getFirst(), (Integer)pair.getSecond(), Direction.NORTH, true);
                }
                if ((Integer)pair.getFirst() > (Integer)prev.getFirst()) {
                    this.setConnection((Integer)pair.getFirst(), (Integer)pair.getSecond(), Direction.WEST, true);
                }
                if ((Integer)pair.getFirst() < (Integer)prev.getFirst()) {
                    this.setConnection((Integer)pair.getFirst(), (Integer)pair.getSecond(), Direction.EAST, true);
                }
                this.get((Pair<Integer, Integer>)pair).ifPresent(r -> {
                    r.mainPath = true;
                });
                prev = pair;
            }
        }

        public void setConnection(int x, int z, Direction side, boolean value) {
            Room room = this.get(x, z).get();
            switch (side) {
                case NORTH: {
                    room.north = value;
                    this.get(x, z - 1).ifPresent(r -> {
                        r.south = value;
                    });
                    break;
                }
                case SOUTH: {
                    room.south = value;
                    this.get(x, z + 1).ifPresent(r -> {
                        r.north = value;
                    });
                    break;
                }
                case EAST: {
                    room.east = value;
                    this.get(x + 1, z).ifPresent(r -> {
                        r.west = value;
                    });
                    break;
                }
                default: {
                    room.west = value;
                    this.get(x - 1, z).ifPresent(r -> {
                        r.east = value;
                    });
                }
            }
        }

        public List<Direction> getSurroundingConnections(int x, int z) {
            ArrayList<Direction> list = new ArrayList<Direction>();
            Room room = this.get(x, z).get();
            for (Direction dir : DIRECTIONS) {
                if (!room.isConnected(dir)) continue;
                list.add(dir);
            }
            return list;
        }

        public Pair<Integer, Integer> randomPair() {
            return Pair.of((Object)this.rand.nextInt(5), (Object)this.rand.nextInt(5));
        }

        @Nullable
        public Optional<Room> get(int x, int z) {
            if (x >= 0 && x < 5 && z >= 0 && z < 5) {
                return Optional.of(this.map.get(x).get(z));
            }
            return Optional.empty();
        }

        @Nullable
        public Optional<Room> get(Pair<Integer, Integer> pair) {
            return this.get((Integer)pair.getFirst(), (Integer)pair.getSecond());
        }

        @Nullable
        public Optional<Room> get(int x, int z, Direction offset) {
            return this.get(this.offset(x, z, offset));
        }

        public void set(int x, int z, Room segment) {
            this.map.get(x).set(z, segment);
        }

        public Pair<Integer, Integer> offset(int x, int z, Direction direction) {
            return Pair.of((Object)(x + direction.func_82601_c()), (Object)(z + direction.func_82599_e()));
        }

        public void addPieces(List<StructurePiece> components, TemplateManager templateManager) {
            int roomOffset = this.roomWidth + this.hallLength;
            int hallOffset = this.roomWidth / 2 - 3;
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    Room room = this.get(x, z).get();
                    if (room == null) continue;
                    int xOffset = room.rotation == Rotation.CLOCKWISE_90 || room.rotation == Rotation.CLOCKWISE_180 ? -1 : 0;
                    int zOffset = room.rotation == Rotation.COUNTERCLOCKWISE_90 || room.rotation == Rotation.CLOCKWISE_180 ? -1 : 0;
                    this.addRoom(x, z, roomOffset, xOffset, zOffset, room, templateManager, components);
                    if ((x * 5 + z) % 2 != 0) continue;
                    switch (this.floor) {
                        case 1: {
                            xOffset = 1;
                            zOffset = -1;
                            break;
                        }
                        case 2: {
                            xOffset = 0;
                            zOffset = 0;
                            break;
                        }
                        case 3: {
                            xOffset = 0;
                            zOffset = -1;
                            break;
                        }
                        default: {
                            xOffset = -1;
                            zOffset = 0;
                        }
                    }
                    if (room.north && this.get(x, z, Direction.NORTH).isPresent()) {
                        components.add((StructurePiece)new Piece(templateManager, this.worldPos.func_177982_a(x * roomOffset + hallOffset, 0, z * roomOffset - this.hallLength), this.hallway, this.floor, this.rand, Rotation.NONE));
                    }
                    if (room.south && this.get(x, z, Direction.SOUTH).isPresent()) {
                        components.add((StructurePiece)new Piece(templateManager, this.worldPos.func_177982_a(x * roomOffset + hallOffset, 0, z * roomOffset + this.roomWidth), this.hallway, this.floor, this.rand, Rotation.NONE));
                    }
                    if (room.east && this.get(x, z, Direction.EAST).isPresent()) {
                        components.add((StructurePiece)new Piece(templateManager, this.worldPos.func_177982_a(x * roomOffset + this.roomWidth + xOffset, 0, z * roomOffset + hallOffset + zOffset), this.hallway, this.floor, this.rand, Rotation.CLOCKWISE_90));
                    }
                    if (!room.west || !this.get(x, z, Direction.WEST).isPresent()) continue;
                    components.add((StructurePiece)new Piece(templateManager, this.worldPos.func_177982_a(x * roomOffset - this.hallLength + xOffset, 0, z * roomOffset + hallOffset + zOffset), this.hallway, this.floor, this.rand, Rotation.CLOCKWISE_90));
                }
            }
        }

        public void addWalls(List<StructurePiece> components, TemplateManager templateManager, ChunkGenerator chunkGen) {
            int roomOffset = this.roomWidth + this.hallLength;
            int width = this.roomWidth * 5 + this.hallLength * 4;
            for (int i = 0; i < 5; ++i) {
                BlockPos northPos = this.worldPos.func_177982_a(i * roomOffset + (this.floor > 2 ? 17 : 19), 0, -5);
                BlockPos southPos = this.worldPos.func_177982_a(i * roomOffset, 0, width + 4);
                BlockPos westPos = this.worldPos.func_177982_a(-5, 0, i * roomOffset);
                BlockPos eastPos = this.worldPos.func_177982_a(width + 4, 0, i * roomOffset + (this.floor > 2 ? 17 : 19));
                components.add((StructurePiece)new Piece(templateManager, northPos, this.getWallAddStairs(i, Direction.NORTH, components, templateManager, chunkGen), this.floor, this.rand, Rotation.CLOCKWISE_90, 1));
                components.add((StructurePiece)new Piece(templateManager, southPos, this.getWallAddStairs(i, Direction.SOUTH, components, templateManager, chunkGen), this.floor, this.rand, Rotation.COUNTERCLOCKWISE_90, 1));
                components.add((StructurePiece)new Piece(templateManager, westPos, this.getWallAddStairs(i, Direction.WEST, components, templateManager, chunkGen), this.floor, this.rand, Rotation.NONE, 1));
                components.add((StructurePiece)new Piece(templateManager, eastPos, this.getWallAddStairs(i, Direction.EAST, components, templateManager, chunkGen), this.floor, this.rand, Rotation.CLOCKWISE_180, 1));
                if (i < 4) {
                    components.add((StructurePiece)new Piece(templateManager, northPos.func_177982_a(this.hallLength, 0, 0), this.wall.hall, this.floor, this.rand, Rotation.CLOCKWISE_90, 1));
                    components.add((StructurePiece)new Piece(templateManager, southPos.func_177982_a(this.roomWidth, 0, 0), this.wall.hall, this.floor, this.rand, Rotation.COUNTERCLOCKWISE_90, 1));
                    components.add((StructurePiece)new Piece(templateManager, westPos.func_177982_a(0, 0, this.roomWidth), this.wall.hall, this.floor, this.rand, Rotation.NONE, 1));
                    components.add((StructurePiece)new Piece(templateManager, eastPos.func_177982_a(0, 0, this.hallLength), this.wall.hall, this.floor, this.rand, Rotation.CLOCKWISE_180, 1));
                }
                if (i != 0) continue;
                components.add((StructurePiece)new Piece(templateManager, northPos.func_177982_a(width - (this.floor > 2 ? 13 : 15), 0, 0), this.wall.corner, this.floor, this.rand, Rotation.CLOCKWISE_90, 1));
                components.add((StructurePiece)new Piece(templateManager, southPos.func_177982_a(-5, 0, 0), this.wall.corner, this.floor, this.rand, Rotation.COUNTERCLOCKWISE_90, 1));
                components.add((StructurePiece)new Piece(templateManager, westPos.func_177982_a(0, 0, -5), this.wall.corner, this.floor, this.rand, Rotation.NONE, 1));
                components.add((StructurePiece)new Piece(templateManager, eastPos.func_177982_a(0, 0, width - (this.floor > 2 ? 13 : 15)), this.wall.corner, this.floor, this.rand, Rotation.CLOCKWISE_180, 1));
            }
        }

        public ResourceLocation getWallAddStairs(int i, Direction dir, List<StructurePiece> components, TemplateManager templateManager, ChunkGenerator chunkGen) {
            return this.wall.room;
        }

        public void addRoom(int x, int z, int roomOffset, int xOffset, int zOffset, Room room, TemplateManager templateManager, List<StructurePiece> components) {
            components.add((StructurePiece)new Piece(templateManager, this.worldPos.func_177982_a(x * roomOffset + xOffset, 0, z * roomOffset + zOffset), room, this.floor, this.rand));
        }

        static {
            potentialExits.add((Pair<Integer, Integer>)Pair.of((Object)0, (Object)2));
            potentialExits.add((Pair<Integer, Integer>)Pair.of((Object)4, (Object)2));
            potentialExits.add((Pair<Integer, Integer>)Pair.of((Object)2, (Object)0));
            potentialExits.add((Pair<Integer, Integer>)Pair.of((Object)2, (Object)4));
            DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        }
    }

    protected static class Wall {
        protected final ResourceLocation room;
        protected final ResourceLocation hall;
        protected final ResourceLocation corner;

        public Wall(int floor) {
            this.room = NatureDungeonPieces.locatePiece("wall/floor_" + floor + "_room");
            this.hall = NatureDungeonPieces.locatePiece("wall/floor_" + floor + "_hall");
            this.corner = NatureDungeonPieces.locatePiece("wall/floor_" + floor + "_corner");
        }
    }
}

