/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;

public class MapleTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.maple_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.maple_leaves.func_176223_P();

    public MapleTreeFeature(Codec<BaseTreeFeatureConfig> config, boolean natural) {
        super(config, natural);
    }

    @Override
    public boolean place(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox bounds) {
        int y;
        int height = rand.nextInt(4) + ((double)rand.nextFloat() < 0.2 ? 13 : 9);
        if (!this.isAreaOk(world, pos, height, 1, 5, 5)) {
            return false;
        }
        boolean branchType = rand.nextBoolean();
        for (y = 0; y <= height; ++y) {
            this.setBlockIfOk(changedLogs, world, pos.func_177981_b(y), LOG, bounds);
        }
        if (branchType) {
            for (y = -2; y < 1; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (y < 0) {
                            this.setBlockIfOk(changedLogs, world, pos.func_177982_a(x, y + height, z), LEAF, bounds);
                            continue;
                        }
                        if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                        this.setBlockIfOk(changedLogs, world, pos.func_177982_a(x, y + height, z), LEAF, bounds);
                    }
                }
            }
            this.setBlockIfOk(changedLeaves, world, pos.func_177981_b(height + 1), LEAF, bounds);
            this.setBlockIfOk(changedLeaves, world, pos.func_177981_b(height + 2), LEAF, bounds);
        } else {
            int z;
            int x;
            for (x = -2; x <= 2; ++x) {
                for (z = -2; z <= 2; ++z) {
                    if (Math.abs(x) + Math.abs(z) >= 3) continue;
                    this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, height - 5, z), LEAF, bounds);
                    this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, height - 1, z), LEAF, bounds);
                    this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, height, z), LEAF, bounds);
                }
            }
            for (x = -3; x <= 3; ++x) {
                for (z = -3; z <= 3; ++z) {
                    if (Math.abs(x) + Math.abs(z) >= 4) continue;
                    this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, height - 4, z), LEAF, bounds);
                    this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, height - 2, z), LEAF, bounds);
                }
            }
            for (x = -3; x <= 3; ++x) {
                for (z = -3; z <= 3; ++z) {
                    if (Math.abs(x) + Math.abs(z) >= 4 && (Math.abs(x) != 2 || Math.abs(z) != 2)) continue;
                    this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, height - 3, z), LEAF, bounds);
                }
            }
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (Math.abs(x) + Math.abs(z) >= 2) continue;
                    this.setBlockIfOk(changedLeaves, world, pos.func_177982_a(x, height + 1, z), LEAF, bounds);
                }
            }
        }
        if (branchType) {
            this.setLowerBranch(changedLogs, changedLeaves, world, pos.func_177982_a(0, height - rand.nextInt(3) - 3, -1), bounds, Direction.NORTH);
            this.setLowerBranch(changedLogs, changedLeaves, world, pos.func_177982_a(1, height - rand.nextInt(3) - 3, 0), bounds, Direction.EAST);
            this.setLowerBranch(changedLogs, changedLeaves, world, pos.func_177982_a(0, height - rand.nextInt(3) - 3, 1), bounds, Direction.SOUTH);
            this.setLowerBranch(changedLogs, changedLeaves, world, pos.func_177982_a(-1, height - rand.nextInt(3) - 3, 0), bounds, Direction.WEST);
        }
        return true;
    }

    protected void setLowerBranch(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, ISeedReader world, BlockPos pos, MutableBoundingBox bounds, Direction direction) {
        this.setBlockIfOk(changedLogs, world, pos, (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()), bounds);
        this.setBlockIfOk(changedLogs, world, pos.func_177967_a(direction, 1), (BlockState)LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()), bounds);
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                int x1 = Math.abs(x);
                int z1 = Math.abs(z);
                if (z1 == 1 && x1 == 1) continue;
                this.setBlockIfOk(changedLeaves, world, pos.func_177967_a(direction, 1).func_177982_a(x, 0, z), LEAF, bounds);
                this.setBlockIfOk(changedLeaves, world, pos.func_177967_a(direction, 1).func_177982_a(x, -1, z), LEAF, bounds);
            }
        }
        this.setBlockIfOk(changedLeaves, world, pos.func_177967_a(direction, 1).func_177984_a(), LEAF, bounds);
        this.setBlockIfOk(changedLeaves, world, pos.func_177967_a(direction, 1).func_177979_c(2), LEAF, bounds);
    }

    @Override
    public boolean isValidGround(ISeedReader world, BlockState state, BlockPos pos) {
        if (this.natural) {
            return super.isValidGround(world, state, pos) && state.func_177230_c() != SkiesBlocks.coarse_lunar_dirt;
        }
        return super.isValidGround(world, state, pos);
    }
}

