/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomes.core.api;

import com.blackgear.cavebiomes.core.CBAConfig;
import com.blackgear.cavebiomes.core.api.CaveLayer;
import com.blackgear.cavebiomes.core.registries.CaveBiomes;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.NetherBiomeProvider;
import net.minecraftforge.common.BiomeDictionary;

public class CaveBiomeAPI {
    public static final BiomeDictionary.Type UNDERGROUND = BiomeDictionary.Type.getType((String)"UNDERGROUND", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
    private static NetherBiomeProvider caveBiomeSource;

    public static void initializeCaveBiomes(Registry<Biome> biomeRegistry, long seed) {
        caveBiomeSource = CaveLayer.create(biomeRegistry, seed);
    }

    public static Biome injectCaveBiomes(Biome surfaceBiomes, int x, int y, int z) {
        Biome caveBiomes = caveBiomeSource.func_225526_b_(x, 0, z);
        if ((float)y <= 12.0f + surfaceBiomes.func_185355_j() * 3.0f && y >= 1) {
            if (!((Boolean)CBAConfig.GENERATE_DEFAULT_CAVES.get()).booleanValue()) {
                if (caveBiomes.func_201856_r() != Biome.Category.EXTREME_HILLS) {
                    return caveBiomes;
                }
            } else {
                return caveBiomes;
            }
        }
        return surfaceBiomes;
    }

    public static void addCaveBiome(RegistryKey<Biome> biome, Biome.Attributes noise) {
        if (biome == null) {
            throw new NullPointerException("CaveBiomeAPI's addCaveBiome method must take a registered biome. Null or unregistered biomes will be rejected.");
        }
        CaveLayer.addCaveBiome(biome, noise);
    }

    public static void addCaveBiome(Biome biome, Biome.Attributes noise) {
        if (biome == null || biome.getRegistryName() == null) {
            throw new NullPointerException("CaveBiomeAPI's addCaveBiome method must take a registered biome. Null or unregistered biomes will be rejected.");
        }
        CaveBiomeAPI.addCaveBiome((RegistryKey<Biome>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName()), noise);
    }

    public static void addDefaultCaves() {
        CaveBiomeAPI.addCaveBiome((Biome)CaveBiomes.CAVE.get(), new Biome.Attributes(0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
    }

    static {
        CaveBiomeAPI.addDefaultCaves();
    }
}

